/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.performancetest;

import fr.proline.studio.performancetest.PerformanceTestData;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerformanceTest {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.Commons.PerformanceTest");
    private static HashMap<String, PerformanceTestData> m_map = new HashMap();

    public static void startTime(String key) {
        PerformanceTest.startTime(key, false);
    }

    public static void startTime(String key, boolean global) {
        if (!m_logger.isDebugEnabled()) {
            return;
        }
        PerformanceTest.startTimeSync(key, global);
    }

    public static void stopTime(String key) {
        PerformanceTest.stopTime(key, false);
    }

    public static void stopTime(String key, boolean global) {
        if (!m_logger.isDebugEnabled()) {
            return;
        }
        PerformanceTest.stopTimeSync(key, global);
    }

    public static void displayTimeAllThreads() {
        if (!m_logger.isDebugEnabled()) {
            return;
        }
        PerformanceTest.displayTimeAllThreadSync();
    }

    public static void displayTimeCurrentThread() {
        if (!m_logger.isDebugEnabled()) {
            return;
        }
        PerformanceTest.displayTimeCurrentThreadSync();
    }

    public static void clearTimeAllThreads() {
        if (!m_logger.isDebugEnabled()) {
            return;
        }
        PerformanceTest.clearTimeAllThreadSync();
    }

    public static void clearTimeCurrentThread() {
        if (!m_logger.isDebugEnabled()) {
            return;
        }
        PerformanceTest.clearTimeCurrentThreadSync();
    }

    private static synchronized void startTimeSync(String key, boolean global) {
        PerformanceTest.getPerformanceTestData().startTime(key, global);
    }

    private static synchronized void stopTimeSync(String key, boolean global) {
        PerformanceTest.getPerformanceTestData().stopTime(key, global);
    }

    private static synchronized void displayTimeAllThreadSync() {
        PerformanceTestData mergedTestData = new PerformanceTestData(m_logger);
        for (String threadKey : m_map.keySet()) {
            PerformanceTestData testData = PerformanceTest.getPerformanceTestData(threadKey);
            mergedTestData.merge(testData);
        }
        mergedTestData.displayTime();
    }

    private static synchronized void displayTimeCurrentThreadSync() {
        PerformanceTest.getPerformanceTestData().displayTime();
    }

    private static synchronized void clearTimeAllThreadSync() {
        m_map.clear();
    }

    private static synchronized void clearTimeCurrentThreadSync() {
        String threadKey = Thread.currentThread().toString();
        m_map.remove(threadKey);
    }

    private static PerformanceTestData getPerformanceTestData() {
        String threadKey = Thread.currentThread().toString();
        return PerformanceTest.getPerformanceTestData(threadKey);
    }

    private static PerformanceTestData getPerformanceTestData(String threadKey) {
        PerformanceTestData testData = m_map.get(threadKey);
        if (testData == null) {
            testData = new PerformanceTestData(m_logger);
            m_map.put(threadKey, testData);
        }
        return testData;
    }
}

