/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.tabs;

import fr.proline.studio.tabs.GridPanel;
import fr.proline.studio.tabs.ILayoutPanel;
import fr.proline.studio.tabs.IWrappedPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelAsGrid
extends JPanel
implements ILayoutPanel {
    private static final int DEFAULT_NB_COL = 2;
    private List<IWrappedPanel> m_panels;
    private Map<GridPanel, IWrappedPanel> m_mapGridPanel;
    private int m_nbRows = 1;
    private int m_nbCols = 1;

    public PanelAsGrid() {
        this.initComponents();
        this.m_panels = new ArrayList<IWrappedPanel>();
    }

    private void initComponents() {
        this.setLayout(new GridLayout(this.m_nbRows, this.m_nbCols));
        this.m_mapGridPanel = new HashMap<GridPanel, IWrappedPanel>();
    }

    @Override
    public JPanel getComponent() {
        return this;
    }

    @Override
    public IWrappedPanel getSelectedPanel() {
        for (Map.Entry<GridPanel, IWrappedPanel> entrySet : this.m_mapGridPanel.entrySet()) {
            GridPanel gridPanel = entrySet.getKey();
            if (!gridPanel.isSelected()) continue;
            return entrySet.getValue();
        }
        return null;
    }

    @Override
    public void setPanels(List<IWrappedPanel> panels, Integer nbCols) {
        this.m_panels = panels;
        this.m_nbCols = nbCols == null || nbCols < 1 ? Math.max((int)Math.ceil(Math.sqrt(panels.size())), 1) : nbCols;
        this.m_nbRows = panels.size() % this.m_nbCols > 0 ? panels.size() / this.m_nbCols + 1 : panels.size() / this.m_nbCols;
        this.displayPanels();
    }

    @Override
    public void addPanel(IWrappedPanel panel) {
        GridPanel gridPanel = new GridPanel(this, panel);
        this.m_panels.add(panel);
        this.m_mapGridPanel.put(gridPanel, panel);
        this.add(gridPanel);
        if (panel.getTabHeaderComponent() != null) {
            this.setTabHeaderComponentAt(this.m_panels.size() - 1, panel.getTabHeaderComponent());
        }
        this.updateLayout();
    }

    @Override
    public void removePanel(int id) {
        IWrappedPanel panel = this.m_panels.get(id);
        GridPanel gp = this.getGridPanel(panel);
        if (gp != null) {
            this.m_mapGridPanel.remove(gp);
        }
        this.remove(gp);
        this.updateLayout();
    }

    @Override
    public void setSelectedPanel(IWrappedPanel panel) {
        GridPanel gridPanel = this.getGridPanel(panel);
        this.changeSelectionPanel();
        if (gridPanel != null) {
            gridPanel.setSelected(true);
        }
        this.fireStateChanged();
    }

    private void displayPanels() {
        this.removeAll();
        this.m_mapGridPanel = new HashMap<GridPanel, IWrappedPanel>();
        this.setLayout(new GridLayout(this.m_nbRows, this.m_nbCols));
        int id = 0;
        for (IWrappedPanel panel : this.m_panels) {
            GridPanel gridPanel = new GridPanel(this, panel);
            this.m_mapGridPanel.put(gridPanel, panel);
            this.add(gridPanel);
            if (panel.getTabHeaderComponent() == null) continue;
            this.setTabHeaderComponentAt(id++, panel.getTabHeaderComponent());
        }
    }

    private void updateLayout() {
        this.m_nbCols = Math.max((int)Math.ceil(Math.sqrt(this.m_panels.size())), 1);
        this.m_nbRows = this.m_panels.size() % this.m_nbCols > 0 ? this.m_panels.size() / this.m_nbCols + 1 : this.m_panels.size() / this.m_nbCols;
        this.setLayout(new GridLayout(this.m_nbRows, this.m_nbCols));
        this.revalidate();
        this.repaint();
    }

    private GridPanel getGridPanel(IWrappedPanel panel) {
        for (Map.Entry<GridPanel, IWrappedPanel> entrySet : this.m_mapGridPanel.entrySet()) {
            GridPanel gridPanel = entrySet.getKey();
            IWrappedPanel wrappedPanel = entrySet.getValue();
            if (!wrappedPanel.getId().equals(panel.getId())) continue;
            return gridPanel;
        }
        return null;
    }

    public void changeSelectionPanel() {
        for (Map.Entry<GridPanel, IWrappedPanel> entrySet : this.m_mapGridPanel.entrySet()) {
            GridPanel grP = entrySet.getKey();
            grP.setSelected(false);
        }
        this.fireStateChanged();
    }

    @Override
    public void setTabHeaderComponentAt(int index, Component c) {
        GridPanel gridP;
        IWrappedPanel p;
        if (index > -1 && index < this.m_panels.size() && (p = this.m_panels.get(index)) != null && (gridP = this.getGridPanel(p)) != null) {
            gridP.setTabHeaderComponent(c);
        }
    }

    @Override
    public int indexOfTabHeaderComponent(Component c) {
        for (int i = 0; i < this.m_panels.size(); ++i) {
            IWrappedPanel p = this.m_panels.get(i);
            GridPanel gridP = this.getGridPanel(p);
            if (gridP == null || gridP.indexOfTabHeaderComponent(c) == -1) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            ChangeEvent changeEvent = new ChangeEvent(this);
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }
}

