/*
 * Decompiled with CFR 0.152.
 */
package net.minidev.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import net.minidev.json.JSONStyle;
import net.minidev.json.parser.ContainerFactory;
import net.minidev.json.parser.ContentHandler;
import net.minidev.json.parser.ContentHandlerCompressor;
import net.minidev.json.parser.FakeContainerFactory;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import net.minidev.json.reader.JsonWriter;
import net.minidev.json.reader.JsonWriterI;

public class JSONValue {
    public static JSONStyle COMPRESSION = JSONStyle.NO_COMPRESS;
    private static final FakeContainerFactory FACTORY_FAKE_COINTAINER = new FakeContainerFactory();
    public static JsonWriter defaultWriter = new JsonWriter();

    public static Object parse(byte[] in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(byte[] in, int offset, int length) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, offset, length);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(InputStream in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(Reader in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parse(String s) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(byte[] in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(byte[] in, int offset, int length) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, offset, length, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(InputStream in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(Reader in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object parseKeepingOrder(String in) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_ORDERED);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void SAXParse(InputStream input, ContentHandler handler) throws ParseException, IOException {
        JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        p.parse(input, (ContainerFactory)FACTORY_FAKE_COINTAINER, handler);
    }

    public static void SAXParse(Reader input, ContentHandler handler) throws ParseException, IOException {
        JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        p.parse(input, (ContainerFactory)FACTORY_FAKE_COINTAINER, handler);
    }

    public static void SAXParse(String input, ContentHandler handler) throws ParseException {
        JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        p.parse(input, (ContainerFactory)FACTORY_FAKE_COINTAINER, handler);
    }

    public static String compress(String input, JSONStyle style) {
        try {
            StringBuilder sb = new StringBuilder();
            ContentHandlerCompressor comp = new ContentHandlerCompressor(sb, style);
            JSONParser p = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            p.parse(input, (ContainerFactory)FACTORY_FAKE_COINTAINER, (ContentHandler)comp);
            return sb.toString();
        }
        catch (Exception e) {
            return input;
        }
    }

    public static String compress(String s) {
        return JSONValue.compress(s, JSONStyle.MAX_COMPRESS);
    }

    public static String uncompress(String s) {
        return JSONValue.compress(s, JSONStyle.NO_COMPRESS);
    }

    public static Object parseWithException(byte[] in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(byte[] in, int offset, int length) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, offset, length, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(InputStream in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(Reader in) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseWithException(String s) throws ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(InputStream in) throws IOException, ParseException {
        return new JSONParser(400).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(Reader in) throws IOException, ParseException {
        return new JSONParser(400).parse(in, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(String s) throws ParseException {
        return new JSONParser(400).parse(s, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(byte[] s) throws ParseException {
        return new JSONParser(400).parse(s, ContainerFactory.FACTORY_SIMPLE);
    }

    public static Object parseStrict(byte[] s, int offset, int length) throws ParseException {
        return new JSONParser(400).parse(s, offset, length, ContainerFactory.FACTORY_SIMPLE);
    }

    public static boolean isValidJsonStrict(Reader in) throws IOException {
        try {
            new JSONParser(400).parse(in, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJsonStrict(String s) {
        try {
            new JSONParser(400).parse(s, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJson(Reader in) throws IOException {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(in, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidJson(String s) {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(s, (ContainerFactory)FACTORY_FAKE_COINTAINER);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static void writeJSONString(Object value, Appendable out) throws IOException {
        JSONValue.writeJSONString(value, out, COMPRESSION);
    }

    public static void writeJSONString(Object value, Appendable out, JSONStyle compression) throws IOException {
        if (value == null) {
            out.append("null");
            return;
        }
        Class<?> clz = value.getClass();
        JsonWriterI<Object> w = defaultWriter.getWrite(clz);
        if (w == null) {
            if (clz.isArray()) {
                w = JsonWriter.arrayWriter;
            } else {
                w = defaultWriter.getWriterByInterface(value.getClass());
                if (w == null) {
                    w = JsonWriter.beansWriter;
                }
            }
            defaultWriter.registerWriter(w, clz);
        }
        w.writeJSONString(value, out, compression);
    }

    public static String toJSONString(Object value) {
        return JSONValue.toJSONString(value, COMPRESSION);
    }

    public static String toJSONString(Object value, JSONStyle compression) {
        StringBuilder sb = new StringBuilder();
        try {
            JSONValue.writeJSONString(value, sb, compression);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static String escape(String s) {
        return JSONValue.escape(s, COMPRESSION);
    }

    public static String escape(String s, JSONStyle compression) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        compression.escape(s, sb);
        return sb.toString();
    }

    public static void escape(String s, Appendable ap) {
        JSONValue.escape(s, ap, COMPRESSION);
    }

    public static void escape(String s, Appendable ap, JSONStyle compression) {
        if (s == null) {
            return;
        }
        compression.escape(s, ap);
    }
}

