/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBuiltinFunction;
import org.python.core.PyBuiltinMethodNarrow;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyIntegerDerived;
import org.python.core.PyLong;
import org.python.core.PyMethodDescr;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;

public class PyInteger
extends PyObject {
    public static final String exposed_name = "int";
    private static final PyType INTTYPE = PyType.fromClass(PyInteger.class);
    private int value;

    public static void typeSetup(PyObject pyObject, PyType.Newstyle newstyle) {
        class Exposed___abs__
        extends PyBuiltinMethodNarrow {
            Exposed___abs__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___abs__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___abs__();
            }
        }
        pyObject.__setitem__("__abs__", (PyObject)new PyMethodDescr("__abs__", PyInteger.class, 0, 0, new Exposed___abs__(null, null)));
        class Exposed___float__
        extends PyBuiltinMethodNarrow {
            Exposed___float__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___float__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___float__();
            }
        }
        pyObject.__setitem__("__float__", (PyObject)new PyMethodDescr("__float__", PyInteger.class, 0, 0, new Exposed___float__(null, null)));
        class Exposed___hex__
        extends PyBuiltinMethodNarrow {
            Exposed___hex__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___hex__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___hex__();
            }
        }
        pyObject.__setitem__("__hex__", (PyObject)new PyMethodDescr("__hex__", PyInteger.class, 0, 0, new Exposed___hex__(null, null)));
        class Exposed___int__
        extends PyBuiltinMethodNarrow {
            Exposed___int__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___int__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___int__();
            }
        }
        pyObject.__setitem__("__int__", (PyObject)new PyMethodDescr("__int__", PyInteger.class, 0, 0, new Exposed___int__(null, null)));
        class Exposed___invert__
        extends PyBuiltinMethodNarrow {
            Exposed___invert__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___invert__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___invert__();
            }
        }
        pyObject.__setitem__("__invert__", (PyObject)new PyMethodDescr("__invert__", PyInteger.class, 0, 0, new Exposed___invert__(null, null)));
        class Exposed___long__
        extends PyBuiltinMethodNarrow {
            Exposed___long__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___long__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___long__();
            }
        }
        pyObject.__setitem__("__long__", (PyObject)new PyMethodDescr("__long__", PyInteger.class, 0, 0, new Exposed___long__(null, null)));
        class Exposed___neg__
        extends PyBuiltinMethodNarrow {
            Exposed___neg__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___neg__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___neg__();
            }
        }
        pyObject.__setitem__("__neg__", (PyObject)new PyMethodDescr("__neg__", PyInteger.class, 0, 0, new Exposed___neg__(null, null)));
        class Exposed___oct__
        extends PyBuiltinMethodNarrow {
            Exposed___oct__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___oct__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___oct__();
            }
        }
        pyObject.__setitem__("__oct__", (PyObject)new PyMethodDescr("__oct__", PyInteger.class, 0, 0, new Exposed___oct__(null, null)));
        class Exposed___pos__
        extends PyBuiltinMethodNarrow {
            Exposed___pos__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___pos__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___pos__();
            }
        }
        pyObject.__setitem__("__pos__", (PyObject)new PyMethodDescr("__pos__", PyInteger.class, 0, 0, new Exposed___pos__(null, null)));
        class Exposed___add__
        extends PyBuiltinMethodNarrow {
            Exposed___add__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___add__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___add__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__add__", (PyObject)new PyMethodDescr("__add__", PyInteger.class, 1, 1, new Exposed___add__(null, null)));
        class Exposed___and__
        extends PyBuiltinMethodNarrow {
            Exposed___and__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___and__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___and__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__and__", (PyObject)new PyMethodDescr("__and__", PyInteger.class, 1, 1, new Exposed___and__(null, null)));
        class Exposed___div__
        extends PyBuiltinMethodNarrow {
            Exposed___div__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___div__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___div__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__div__", (PyObject)new PyMethodDescr("__div__", PyInteger.class, 1, 1, new Exposed___div__(null, null)));
        class Exposed___divmod__
        extends PyBuiltinMethodNarrow {
            Exposed___divmod__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___divmod__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___divmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__divmod__", (PyObject)new PyMethodDescr("__divmod__", PyInteger.class, 1, 1, new Exposed___divmod__(null, null)));
        class Exposed___floordiv__
        extends PyBuiltinMethodNarrow {
            Exposed___floordiv__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___floordiv__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___floordiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__floordiv__", (PyObject)new PyMethodDescr("__floordiv__", PyInteger.class, 1, 1, new Exposed___floordiv__(null, null)));
        class Exposed___lshift__
        extends PyBuiltinMethodNarrow {
            Exposed___lshift__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___lshift__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___lshift__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__lshift__", (PyObject)new PyMethodDescr("__lshift__", PyInteger.class, 1, 1, new Exposed___lshift__(null, null)));
        class Exposed___mod__
        extends PyBuiltinMethodNarrow {
            Exposed___mod__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___mod__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___mod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__mod__", (PyObject)new PyMethodDescr("__mod__", PyInteger.class, 1, 1, new Exposed___mod__(null, null)));
        class Exposed___mul__
        extends PyBuiltinMethodNarrow {
            Exposed___mul__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___mul__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___mul__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__mul__", (PyObject)new PyMethodDescr("__mul__", PyInteger.class, 1, 1, new Exposed___mul__(null, null)));
        class Exposed___or__
        extends PyBuiltinMethodNarrow {
            Exposed___or__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___or__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___or__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__or__", (PyObject)new PyMethodDescr("__or__", PyInteger.class, 1, 1, new Exposed___or__(null, null)));
        class Exposed___radd__
        extends PyBuiltinMethodNarrow {
            Exposed___radd__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___radd__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___radd__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__radd__", (PyObject)new PyMethodDescr("__radd__", PyInteger.class, 1, 1, new Exposed___radd__(null, null)));
        class Exposed___rdiv__
        extends PyBuiltinMethodNarrow {
            Exposed___rdiv__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rdiv__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rdiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rdiv__", (PyObject)new PyMethodDescr("__rdiv__", PyInteger.class, 1, 1, new Exposed___rdiv__(null, null)));
        class Exposed___rfloordiv__
        extends PyBuiltinMethodNarrow {
            Exposed___rfloordiv__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rfloordiv__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rfloordiv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rfloordiv__", (PyObject)new PyMethodDescr("__rfloordiv__", PyInteger.class, 1, 1, new Exposed___rfloordiv__(null, null)));
        class Exposed___rmod__
        extends PyBuiltinMethodNarrow {
            Exposed___rmod__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rmod__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rmod__", (PyObject)new PyMethodDescr("__rmod__", PyInteger.class, 1, 1, new Exposed___rmod__(null, null)));
        class Exposed___rmul__
        extends PyBuiltinMethodNarrow {
            Exposed___rmul__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rmul__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rmul__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rmul__", (PyObject)new PyMethodDescr("__rmul__", PyInteger.class, 1, 1, new Exposed___rmul__(null, null)));
        class Exposed___rshift__
        extends PyBuiltinMethodNarrow {
            Exposed___rshift__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rshift__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rshift__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rshift__", (PyObject)new PyMethodDescr("__rshift__", PyInteger.class, 1, 1, new Exposed___rshift__(null, null)));
        class Exposed___rsub__
        extends PyBuiltinMethodNarrow {
            Exposed___rsub__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rsub__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rsub__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rsub__", (PyObject)new PyMethodDescr("__rsub__", PyInteger.class, 1, 1, new Exposed___rsub__(null, null)));
        class Exposed___rtruediv__
        extends PyBuiltinMethodNarrow {
            Exposed___rtruediv__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rtruediv__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rtruediv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rtruediv__", (PyObject)new PyMethodDescr("__rtruediv__", PyInteger.class, 1, 1, new Exposed___rtruediv__(null, null)));
        class Exposed___sub__
        extends PyBuiltinMethodNarrow {
            Exposed___sub__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___sub__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___sub__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__sub__", (PyObject)new PyMethodDescr("__sub__", PyInteger.class, 1, 1, new Exposed___sub__(null, null)));
        class Exposed___truediv__
        extends PyBuiltinMethodNarrow {
            Exposed___truediv__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___truediv__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___truediv__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__truediv__", (PyObject)new PyMethodDescr("__truediv__", PyInteger.class, 1, 1, new Exposed___truediv__(null, null)));
        class Exposed___xor__
        extends PyBuiltinMethodNarrow {
            Exposed___xor__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___xor__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___xor__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__xor__", (PyObject)new PyMethodDescr("__xor__", PyInteger.class, 1, 1, new Exposed___xor__(null, null)));
        class Exposed___rxor__
        extends PyBuiltinMethodNarrow {
            Exposed___rxor__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rxor__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rxor__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rxor__", (PyObject)new PyMethodDescr("__rxor__", PyInteger.class, 1, 1, new Exposed___rxor__(null, null)));
        class Exposed___rrshift__
        extends PyBuiltinMethodNarrow {
            Exposed___rrshift__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rrshift__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rrshift__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rrshift__", (PyObject)new PyMethodDescr("__rrshift__", PyInteger.class, 1, 1, new Exposed___rrshift__(null, null)));
        class Exposed___ror__
        extends PyBuiltinMethodNarrow {
            Exposed___ror__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___ror__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___ror__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__ror__", (PyObject)new PyMethodDescr("__ror__", PyInteger.class, 1, 1, new Exposed___ror__(null, null)));
        class Exposed___rand__
        extends PyBuiltinMethodNarrow {
            Exposed___rand__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rand__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rand__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rand__", (PyObject)new PyMethodDescr("__rand__", PyInteger.class, 1, 1, new Exposed___rand__(null, null)));
        class Exposed___rpow__
        extends PyBuiltinMethodNarrow {
            Exposed___rpow__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rpow__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rpow__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rpow__", (PyObject)new PyMethodDescr("__rpow__", PyInteger.class, 1, 1, new Exposed___rpow__(null, null)));
        class Exposed___rlshift__
        extends PyBuiltinMethodNarrow {
            Exposed___rlshift__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rlshift__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rlshift__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rlshift__", (PyObject)new PyMethodDescr("__rlshift__", PyInteger.class, 1, 1, new Exposed___rlshift__(null, null)));
        class Exposed___rdivmod__
        extends PyBuiltinMethodNarrow {
            Exposed___rdivmod__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___rdivmod__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___rdivmod__(pyObject);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__rdivmod__", (PyObject)new PyMethodDescr("__rdivmod__", PyInteger.class, 1, 1, new Exposed___rdivmod__(null, null)));
        class Exposed___cmp__
        extends PyBuiltinMethodNarrow {
            Exposed___cmp__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___cmp__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject) {
                int n = ((PyInteger)this.self).int___cmp__(pyObject);
                if (n == -2) {
                    throw Py.TypeError("int.__cmp__(x,y) requires y to be 'int', not a '" + pyObject.getType().fastGetName() + "'");
                }
                return Py.newInteger(n);
            }
        }
        pyObject.__setitem__("__cmp__", (PyObject)new PyMethodDescr("__cmp__", PyInteger.class, 1, 1, new Exposed___cmp__(null, null)));
        class Exposed___pow__
        extends PyBuiltinMethodNarrow {
            Exposed___pow__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___pow__(pyObject, this.info);
            }

            public PyObject __call__(PyObject pyObject, PyObject pyObject2) {
                PyObject pyObject3 = ((PyInteger)this.self).int___pow__(pyObject, pyObject2);
                if (pyObject3 == null) {
                    return Py.NotImplemented;
                }
                return pyObject3;
            }

            public PyObject __call__(PyObject pyObject) {
                PyObject pyObject2 = ((PyInteger)this.self).int___pow__(pyObject, null);
                if (pyObject2 == null) {
                    return Py.NotImplemented;
                }
                return pyObject2;
            }
        }
        pyObject.__setitem__("__pow__", (PyObject)new PyMethodDescr("__pow__", PyInteger.class, 1, 2, new Exposed___pow__(null, null)));
        class Exposed___nonzero__
        extends PyBuiltinMethodNarrow {
            Exposed___nonzero__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___nonzero__(pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newBoolean(((PyInteger)this.self).int___nonzero__());
            }
        }
        pyObject.__setitem__("__nonzero__", (PyObject)new PyMethodDescr("__nonzero__", PyInteger.class, 0, 0, new Exposed___nonzero__(null, null)));
        class Exposed___reduce__
        extends PyBuiltinMethodNarrow {
            Exposed___reduce__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___reduce__(pyObject, this.info);
            }

            public PyObject __call__() {
                return ((PyInteger)this.self).int___reduce__();
            }
        }
        pyObject.__setitem__("__reduce__", (PyObject)new PyMethodDescr("__reduce__", PyInteger.class, 0, 0, new Exposed___reduce__(null, null)));
        class Exposed___repr__
        extends PyBuiltinMethodNarrow {
            Exposed___repr__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___repr__(pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyInteger)this.self).int_toString());
            }
        }
        pyObject.__setitem__("__repr__", (PyObject)new PyMethodDescr("__repr__", PyInteger.class, 0, 0, new Exposed___repr__(null, null)));
        class Exposed___str__
        extends PyBuiltinMethodNarrow {
            Exposed___str__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___str__(pyObject, this.info);
            }

            public PyObject __call__() {
                return new PyString(((PyInteger)this.self).int_toString());
            }
        }
        pyObject.__setitem__("__str__", (PyObject)new PyMethodDescr("__str__", PyInteger.class, 0, 0, new Exposed___str__(null, null)));
        class Exposed___hash__
        extends PyBuiltinMethodNarrow {
            Exposed___hash__(PyObject pyObject, PyBuiltinFunction.Info info) {
                super(pyObject, info);
            }

            public PyBuiltinFunction bind(PyObject pyObject) {
                return new Exposed___hash__(pyObject, this.info);
            }

            public PyObject __call__() {
                return Py.newInteger(((PyInteger)this.self).int_hashCode());
            }
        }
        pyObject.__setitem__("__hash__", (PyObject)new PyMethodDescr("__hash__", PyInteger.class, 0, 0, new Exposed___hash__(null, null)));
        pyObject.__setitem__("__new__", (PyObject)new PyNewWrapper(PyInteger.class, "__new__", -1, -1){

            public PyObject new_impl(boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
                return PyInteger.int_new(this, bl, pyType, pyObjectArray, stringArray);
            }
        });
    }

    public static PyObject int_new(PyNewWrapper pyNewWrapper, boolean bl, PyType pyType, PyObject[] pyObjectArray, String[] stringArray) {
        ArgParser argParser = new ArgParser(exposed_name, pyObjectArray, stringArray, new String[]{"x", "base"}, 0);
        PyObject pyObject = argParser.getPyObject(0, null);
        int n = argParser.getInt(1, -909);
        if (pyNewWrapper.for_type == pyType) {
            if (pyObject == null) {
                return Py.Zero;
            }
            if (n == -909) {
                return PyInteger.asPyInteger(pyObject);
            }
            if (!(pyObject instanceof PyString)) {
                throw Py.TypeError("int: can't convert non-string with explicit base");
            }
            return Py.newInteger(((PyString)pyObject).atoi(n));
        }
        if (pyObject == null) {
            return new PyIntegerDerived(pyType, 0);
        }
        if (n == -909) {
            PyObject pyObject2 = PyInteger.asPyInteger(pyObject);
            if (pyObject2 instanceof PyInteger) {
                return new PyIntegerDerived(pyType, ((PyInteger)pyObject2).getValue());
            }
            throw Py.OverflowError("long int too large to convert to int");
        }
        if (!(pyObject instanceof PyString)) {
            throw Py.TypeError("int: can't convert non-string with explicit base");
        }
        return new PyIntegerDerived(pyType, ((PyString)pyObject).atoi(n));
    }

    private static PyObject asPyInteger(PyObject pyObject) {
        try {
            return pyObject.__int__();
        }
        catch (PyException pyException) {
            if (!Py.matchException(pyException, Py.AttributeError)) {
                throw pyException;
            }
            throw Py.TypeError("int() argument must be a string or a number");
        }
    }

    public PyInteger(PyType pyType, int n) {
        super(pyType);
        this.value = n;
    }

    public PyInteger(int n) {
        this(INTTYPE, n);
    }

    public int getValue() {
        return this.value;
    }

    public String safeRepr() throws PyIgnoreMethodTag {
        return "'int' object";
    }

    public String toString() {
        return this.int_toString();
    }

    final String int_toString() {
        return Integer.toString(this.getValue());
    }

    public int hashCode() {
        return this.int_hashCode();
    }

    final int int_hashCode() {
        return this.getValue();
    }

    private static void err_ovf(String string) {
        block2: {
            try {
                Py.OverflowWarning(string);
            }
            catch (PyException pyException) {
                if (!Py.matchException(pyException, Py.OverflowWarning)) break block2;
                throw Py.OverflowError(string);
            }
        }
    }

    public boolean __nonzero__() {
        return this.int___nonzero__();
    }

    final boolean int___nonzero__() {
        return this.getValue() != 0;
    }

    public Object __tojava__(Class clazz) {
        if (clazz == Integer.TYPE || clazz == Number.class || clazz == Object.class || clazz == Integer.class || clazz == Serializable.class) {
            return new Integer(this.getValue());
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return new Boolean(this.getValue() != 0);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return new Byte((byte)this.getValue());
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return new Short((short)this.getValue());
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return new Long(this.getValue());
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return new Float(this.getValue());
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return new Double(this.getValue());
        }
        return super.__tojava__(clazz);
    }

    public int __cmp__(PyObject pyObject) {
        return this.int___cmp__(pyObject);
    }

    final int int___cmp__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return -2;
        }
        int n = PyInteger.coerce(pyObject);
        return this.getValue() < n ? -1 : (this.getValue() > n ? 1 : 0);
    }

    public Object __coerce_ex__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return pyObject;
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject pyObject) {
        return pyObject instanceof PyInteger;
    }

    private static final int coerce(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return ((PyInteger)pyObject).getValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject pyObject) {
        return this.int___add__(pyObject);
    }

    final PyObject int___add__(PyObject pyObject) {
        int n;
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n2 = PyInteger.coerce(pyObject);
        int n3 = this.getValue();
        int n4 = n3 + (n = n2);
        if ((n4 ^ n3) >= 0 || (n4 ^ n) >= 0) {
            return Py.newInteger(n4);
        }
        PyInteger.err_ovf("integer addition");
        return new PyLong((long)n3 + (long)n);
    }

    public PyObject __radd__(PyObject pyObject) {
        return this.int___radd__(pyObject);
    }

    final PyObject int___radd__(PyObject pyObject) {
        return this.__add__(pyObject);
    }

    private static PyObject _sub(int n, int n2) {
        int n3 = n - n2;
        if ((n3 ^ n) >= 0 || (n3 ^ ~n2) >= 0) {
            return Py.newInteger(n3);
        }
        PyInteger.err_ovf("integer subtraction");
        return new PyLong((long)n - (long)n2);
    }

    public PyObject __sub__(PyObject pyObject) {
        return this.int___sub__(pyObject);
    }

    final PyObject int___sub__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return PyInteger._sub(this.getValue(), PyInteger.coerce(pyObject));
    }

    public PyObject __rsub__(PyObject pyObject) {
        return this.int___rsub__(pyObject);
    }

    final PyObject int___rsub__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return PyInteger._sub(PyInteger.coerce(pyObject), this.getValue());
    }

    public PyObject __mul__(PyObject pyObject) {
        return this.int___mul__(pyObject);
    }

    final PyObject int___mul__(PyObject pyObject) {
        if (pyObject instanceof PySequence) {
            return ((PySequence)pyObject).repeat(this.getValue());
        }
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        double d = this.getValue();
        if ((d *= (double)n) <= 2.147483647E9 && d >= -2.147483648E9) {
            return Py.newInteger((int)d);
        }
        PyInteger.err_ovf("integer multiplication");
        return this.__long__().__mul__(pyObject);
    }

    public PyObject __rmul__(PyObject pyObject) {
        return this.int___rmul__(pyObject);
    }

    final PyObject int___rmul__(PyObject pyObject) {
        return this.__mul__(pyObject);
    }

    private static int divide(int n, int n2) {
        int n3;
        int n4;
        if (n2 == 0) {
            throw Py.ZeroDivisionError("integer division or modulo by zero");
        }
        if (n2 == -1 && n < 0 && n == -n) {
            PyInteger.err_ovf("integer division: " + n + " + " + n2);
        }
        if ((n4 = n - (n3 = n / n2) * n2) != 0 && (n2 ^ n4) < 0) {
            n4 += n2;
            --n3;
        }
        return n3;
    }

    public PyObject __div__(PyObject pyObject) {
        return this.int___div__(pyObject);
    }

    final PyObject int___div__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(pyObject)));
    }

    public PyObject __rdiv__(PyObject pyObject) {
        return this.int___rdiv__(pyObject);
    }

    final PyObject int___rdiv__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        if (Options.divisionWarning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(pyObject), this.getValue()));
    }

    public PyObject __floordiv__(PyObject pyObject) {
        return this.int___floordiv__(pyObject);
    }

    final PyObject int___floordiv__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(pyObject)));
    }

    public PyObject __rfloordiv__(PyObject pyObject) {
        return this.int___rfloordiv__(pyObject);
    }

    final PyObject int___rfloordiv__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(pyObject), this.getValue()));
    }

    public PyObject __truediv__(PyObject pyObject) {
        return this.int___truediv__(pyObject);
    }

    final PyObject int___truediv__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return this.__float__().__truediv__(pyObject);
        }
        if (pyObject instanceof PyLong) {
            return this.int___long__().__truediv__(pyObject);
        }
        return null;
    }

    public PyObject __rtruediv__(PyObject pyObject) {
        return this.int___rtruediv__(pyObject);
    }

    final PyObject int___rtruediv__(PyObject pyObject) {
        if (pyObject instanceof PyInteger) {
            return pyObject.__float__().__truediv__(this);
        }
        if (pyObject instanceof PyLong) {
            return pyObject.__truediv__(this.int___long__());
        }
        return null;
    }

    private static int modulo(int n, int n2, int n3) {
        return n - n3 * n2;
    }

    public PyObject __mod__(PyObject pyObject) {
        return this.int___mod__(pyObject);
    }

    final PyObject int___mod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        int n2 = this.getValue();
        return Py.newInteger(PyInteger.modulo(n2, n, PyInteger.divide(n2, n)));
    }

    public PyObject __rmod__(PyObject pyObject) {
        return this.int___rmod__(pyObject);
    }

    final PyObject int___rmod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        int n2 = this.getValue();
        return Py.newInteger(PyInteger.modulo(n, n2, PyInteger.divide(n, n2)));
    }

    public PyObject __divmod__(PyObject pyObject) {
        return this.int___divmod__(pyObject);
    }

    final PyObject int___divmod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        int n2 = this.getValue();
        int n3 = PyInteger.divide(n2, n);
        return new PyTuple(new PyObject[]{Py.newInteger(n3), Py.newInteger(PyInteger.modulo(n2, n, n3))});
    }

    final PyObject int___rdivmod__(PyObject pyObject) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        int n = PyInteger.coerce(pyObject);
        int n2 = this.getValue();
        int n3 = PyInteger.divide(n, n2);
        return new PyTuple(new PyObject[]{Py.newInteger(n3), Py.newInteger(PyInteger.modulo(n, n2, n3))});
    }

    public PyObject __pow__(PyObject pyObject, PyObject pyObject2) {
        return this.int___pow__(pyObject, pyObject2);
    }

    final PyObject int___pow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null && !PyInteger.canCoerce(pyObject2)) {
            return null;
        }
        return PyInteger._pow(this.getValue(), PyInteger.coerce(pyObject), pyObject2, this, pyObject);
    }

    public PyObject __rpow__(PyObject pyObject, PyObject pyObject2) {
        if (!PyInteger.canCoerce(pyObject)) {
            return null;
        }
        if (pyObject2 != null && !PyInteger.canCoerce(pyObject2)) {
            return null;
        }
        return PyInteger._pow(PyInteger.coerce(pyObject), this.getValue(), pyObject2, pyObject, this);
    }

    final PyObject int___rpow__(PyObject pyObject) {
        return this.__rpow__(pyObject, null);
    }

    private static PyObject _pow(int n, int n2, PyObject pyObject, PyObject pyObject2, PyObject pyObject3) {
        int n3 = 0;
        long l = n;
        boolean bl = false;
        if (l < 0L) {
            l = -l;
            bl = (n2 & 1) != 0;
        }
        long l2 = 1L;
        if (n2 < 0) {
            if (n != 0) {
                return pyObject2.__float__().__pow__(pyObject3, pyObject);
            }
            throw Py.ZeroDivisionError("cannot raise 0 to a negative power");
        }
        if (pyObject != null && (n3 = PyInteger.coerce(pyObject)) == 0) {
            throw Py.ValueError("pow(x, y, z) with z==0");
        }
        while (n2 > 0) {
            if ((n2 & 1) != 0) {
                l2 *= l;
                if (n3 != 0) {
                    l2 %= (long)n3;
                }
                if (l2 > Integer.MAX_VALUE) {
                    PyInteger.err_ovf("integer exponentiation");
                    return pyObject2.__long__().__pow__(pyObject3, pyObject);
                }
            }
            if ((n2 >>= 1) == 0) break;
            l *= l;
            if (n3 != 0) {
                l %= (long)n3;
            }
            if (l <= Integer.MAX_VALUE) continue;
            PyInteger.err_ovf("integer exponentiation");
            return pyObject2.__long__().__pow__(pyObject3, pyObject);
        }
        int n4 = (int)l2;
        if (bl) {
            n4 = -n4;
        }
        if (n3 != 0) {
            n4 = PyInteger.modulo(n4, n3, PyInteger.divide(n4, n3));
        }
        return Py.newInteger(n4);
    }

    public PyObject __lshift__(PyObject pyObject) {
        return this.int___lshift__(pyObject);
    }

    final PyObject int___lshift__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return this.int___long__().__lshift__(pyObject);
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        if (n > 31) {
            return Py.newInteger(0);
        }
        if (n < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(this.getValue() << n);
    }

    final PyObject int___rlshift__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return pyObject.__rlshift__(this.int___long__());
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        if (this.getValue() > 31) {
            return Py.newInteger(0);
        }
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(n << this.getValue());
    }

    public PyObject __rshift__(PyObject pyObject) {
        return this.int___rshift__(pyObject);
    }

    final PyObject int___rshift__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return this.int___long__().__rshift__(pyObject);
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        if (n < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(this.getValue() >> n);
    }

    final PyObject int___rrshift__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return pyObject.__rshift__(this.int___long__());
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        return Py.newInteger(n >> this.getValue());
    }

    public PyObject __and__(PyObject pyObject) {
        return this.int___and__(pyObject);
    }

    final PyObject int___and__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return this.int___long__().__and__(pyObject);
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        return Py.newInteger(this.getValue() & n);
    }

    final PyObject int___rand__(PyObject pyObject) {
        return this.int___and__(pyObject);
    }

    public PyObject __xor__(PyObject pyObject) {
        return this.int___xor__(pyObject);
    }

    final PyObject int___xor__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return this.int___long__().__xor__(pyObject);
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        return Py.newInteger(this.getValue() ^ n);
    }

    final PyObject int___rxor__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return pyObject.__rxor__(this.int___long__());
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        return Py.newInteger(n ^ this.getValue());
    }

    public PyObject __or__(PyObject pyObject) {
        return this.int___or__(pyObject);
    }

    final PyObject int___or__(PyObject pyObject) {
        if (!(pyObject instanceof PyInteger)) {
            if (pyObject instanceof PyLong) {
                return this.int___long__().__or__(pyObject);
            }
            return null;
        }
        int n = ((PyInteger)pyObject).getValue();
        return Py.newInteger(this.getValue() | n);
    }

    final PyObject int___ror__(PyObject pyObject) {
        return this.int___or__(pyObject);
    }

    public PyObject __neg__() {
        return this.int___neg__();
    }

    final PyObject int___neg__() {
        int n = -this.getValue();
        if (this.getValue() < 0 && n < 0) {
            PyInteger.err_ovf("integer negation");
        }
        return Py.newInteger(n);
    }

    public PyObject __pos__() {
        return this.int___pos__();
    }

    final PyObject int___pos__() {
        return Py.newInteger(this.getValue());
    }

    public PyObject __abs__() {
        return this.int___abs__();
    }

    final PyObject int___abs__() {
        if (this.getValue() >= 0) {
            return Py.newInteger(this.getValue());
        }
        return this.__neg__();
    }

    public PyObject __invert__() {
        return this.int___invert__();
    }

    final PyObject int___invert__() {
        return Py.newInteger(~this.getValue());
    }

    public PyObject __int__() {
        return this.int___int__();
    }

    final PyInteger int___int__() {
        return Py.newInteger(this.getValue());
    }

    public PyLong __long__() {
        return this.int___long__();
    }

    final PyLong int___long__() {
        return new PyLong(this.getValue());
    }

    public PyFloat __float__() {
        return this.int___float__();
    }

    final PyFloat int___float__() {
        return new PyFloat((double)this.getValue());
    }

    public PyComplex __complex__() {
        return new PyComplex(this.getValue(), 0.0);
    }

    public PyString __oct__() {
        return this.int___oct__();
    }

    final PyString int___oct__() {
        if (this.getValue() < 0) {
            return new PyString("0" + Long.toString(0x100000000L + (long)this.getValue(), 8));
        }
        if (this.getValue() > 0) {
            return new PyString("0" + Integer.toString(this.getValue(), 8));
        }
        return new PyString("0");
    }

    public PyString __hex__() {
        return this.int___hex__();
    }

    final PyString int___hex__() {
        if (this.getValue() < 0) {
            return new PyString("0x" + Long.toString(0x100000000L + (long)this.getValue(), 16));
        }
        return new PyString("0x" + Integer.toString(this.getValue(), 16));
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    public long asLong(int n) throws PyObject.ConversionException {
        return this.getValue();
    }

    public int asInt(int n) throws PyObject.ConversionException {
        return this.getValue();
    }

    public PyObject __reduce__() {
        return this.int___reduce__();
    }

    final PyObject int___reduce__() {
        return new PyTuple(new PyObject[]{this.getType(), new PyTuple(new PyObject[]{Py.newInteger(this.getValue())})});
    }
}

