/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HmmerRest {
    static final String LIST_SEPARATOR = "%0A";
    static final String LINE_SEPARATOR = "\n";
    private static final String BASE_URL = "http://pfam.sanger.ac.uk/search/sequence";

    public static void main(String[] args) {
        String seq = "MASTENNEKDNFMRDTASRSKKSRRRSLWIAAGAVPTAIALSLSLASPAAVAQSSFGSSDIIDSGVLDSITRGLTDYLTPRDEALPAGEVTYPAIEGLPAGVRVNSAEYVTSHHVVLSIQSAAMPERPIKVQLLLPRDWYSSPDRDFPEIWALDGLRAIEKQSGWTIETNIEQFFADKNAIVVLPVGGESSFYTDWNEPNNGKNYQWETFLTEELAPILDKGFRSNGERAITGISMGGTAAVNIATHNPEMFNFVGSFSGYLDTTSNGMPAAIGAALADAGGYNVNAMWGPAGSERWLENDPKRNVDQLRGKQVYVSAGSGADDYGQDGSVATGPANAAGVGLELISRMTSQTFVDAANGAGVNVIANFRPSGVHAWPYWQFEMTQAWPYMADSLGMSREDRGADCVALGAIADATADGSLGSCLNNEYLVANGVGRAQDFTNGRAYWSPNTGAFGLFGRINARYSELGGPDSWLGFPKTRELSTPDGRGRYVHFENGSIYWSAATGPWEIPGDMFTAWGTQGYEAGGLGYPVGPAKDFNGGLAQEFQGGYVLRTPQNRAYWVRGAISAKYMEPGVATTLGFPTGNERLIPGGAFQEFTNGNIYWSASTGAHYILRGGIFDAWGAKGYEQGEYGWPTTDQTSIAAGGETITFQNGTIRQVNGRIEESR";
        String query = "seq=MASTENNEKDNFMRDTASRSKKSRRRSLWIAAGAVPTAIALSLSLASPAAVAQSSFGSSDIIDSGVLDSITRGLTDYLTPRDEALPAGEVTYPAIEGLPAGVRVNSAEYVTSHHVVLSIQSAAMPERPIKVQLLLPRDWYSSPDRDFPEIWALDGLRAIEKQSGWTIETNIEQFFADKNAIVVLPVGGESSFYTDWNEPNNGKNYQWETFLTEELAPILDKGFRSNGERAITGISMGGTAAVNIATHNPEMFNFVGSFSGYLDTTSNGMPAAIGAALADAGGYNVNAMWGPAGSERWLENDPKRNVDQLRGKQVYVSAGSGADDYGQDGSVATGPANAAGVGLELISRMTSQTFVDAANGAGVNVIANFRPSGVHAWPYWQFEMTQAWPYMADSLGMSREDRGADCVALGAIADATADGSLGSCLNNEYLVANGVGRAQDFTNGRAYWSPNTGAFGLFGRINARYSELGGPDSWLGFPKTRELSTPDGRGRYVHFENGSIYWSAATGPWEIPGDMFTAWGTQGYEAGGLGYPVGPAKDFNGGLAQEFQGGYVLRTPQNRAYWVRGAISAKYMEPGVATTLGFPTGNERLIPGGAFQEFTNGNIYWSASTGAHYILRGGIFDAWGAKGYEQGEYGWPTTDQTSIAAGGETITFQNGTIRQVNGRIEESR&output=xml";
        String result = "";
        try {
            result = HmmerRest.getResult("seq=MASTENNEKDNFMRDTASRSKKSRRRSLWIAAGAVPTAIALSLSLASPAAVAQSSFGSSDIIDSGVLDSITRGLTDYLTPRDEALPAGEVTYPAIEGLPAGVRVNSAEYVTSHHVVLSIQSAAMPERPIKVQLLLPRDWYSSPDRDFPEIWALDGLRAIEKQSGWTIETNIEQFFADKNAIVVLPVGGESSFYTDWNEPNNGKNYQWETFLTEELAPILDKGFRSNGERAITGISMGGTAAVNIATHNPEMFNFVGSFSGYLDTTSNGMPAAIGAALADAGGYNVNAMWGPAGSERWLENDPKRNVDQLRGKQVYVSAGSGADDYGQDGSVATGPANAAGVGLELISRMTSQTFVDAANGAGVNVIANFRPSGVHAWPYWQFEMTQAWPYMADSLGMSREDRGADCVALGAIADATADGSLGSCLNNEYLVANGVGRAQDFTNGRAYWSPNTGAFGLFGRINARYSELGGPDSWLGFPKTRELSTPDGRGRYVHFENGSIYWSAATGPWEIPGDMFTAWGTQGYEAGGLGYPVGPAKDFNGGLAQEFQGGYVLRTPQNRAYWVRGAISAKYMEPGVATTLGFPTGNERLIPGGAFQEFTNGNIYWSASTGAHYILRGGIFDAWGAKGYEQGEYGWPTTDQTSIAAGGETITFQNGTIRQVNGRIEESR&output=xml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document dom = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(new ByteArrayInputStream(result.getBytes()));
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Element docEle = dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("job");
        String result_url = "";
        for (int i = 0; i < nl.getLength(); ++i) {
            result_url = HmmerRest.getTextValue((Element)nl.item(i), "result_url");
        }
        System.out.println("result url = " + result_url);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        try {
            result = HmmerRest.getResult(result_url, "");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(result);
    }

    private static String getTextValue(Element ele, String tagName) {
        String textVal = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    public static String getResult(String base_url, String query) throws IOException {
        System.out.println(query);
        URL url = new URL(base_url);
        URLConnection urlc = url.openConnection();
        urlc.setDoOutput(true);
        urlc.setAllowUserInteraction(false);
        PrintStream ps = new PrintStream(urlc.getOutputStream());
        ps.print(query.trim());
        ps.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + LINE_SEPARATOR);
        }
        br.close();
        return sb.toString().trim();
    }

    public static String getResult(String query) throws IOException {
        System.out.println(query);
        URL url = new URL(BASE_URL);
        URLConnection urlc = url.openConnection();
        urlc.setDoOutput(true);
        urlc.setAllowUserInteraction(false);
        PrintStream ps = new PrintStream(urlc.getOutputStream());
        ps.print(query.trim());
        ps.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(urlc.getInputStream()));
        StringBuffer sb = new StringBuffer();
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line + LINE_SEPARATOR);
        }
        br.close();
        return sb.toString().trim();
    }
}

