/*
 * Decompiled with CFR 0.152.
 */
package org.forester.msa;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.FastaParser;
import org.forester.io.writers.SequenceWriter;
import org.forester.msa.Msa;
import org.forester.msa.MsaInferrer;
import org.forester.sequence.MolecularSequence;
import org.forester.util.SystemCommandExecutor;

public final class Mafft
extends MsaInferrer {
    private static final String DEFAULT_PARAMETERS = "--maxiterate 1000 --localpair";
    private String _error;
    private int _exit_code;
    private final String _path_to_prg;

    public static MsaInferrer createInstance(String path_to_prg) throws IOException {
        return new Mafft(path_to_prg);
    }

    private Mafft(String path_to_prg) throws IOException {
        if (!Mafft.isInstalled(path_to_prg)) {
            throw new IOException("cannot execute MAFFT with \"" + path_to_prg + "\"");
        }
        this._path_to_prg = new String(path_to_prg);
        this.init();
    }

    public static String getDefaultParameters() {
        return DEFAULT_PARAMETERS;
    }

    @Override
    public String getErrorDescription() {
        return this._error;
    }

    @Override
    public int getExitCode() {
        return this._exit_code;
    }

    @Override
    public Msa infer(List<MolecularSequence> seqs, List<String> opts) throws IOException, InterruptedException {
        File file = File.createTempFile("__mafft_input_", ".fasta");
        file.deleteOnExit();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        SequenceWriter.writeSeqs(seqs, writer, SequenceWriter.SEQ_FORMAT.FASTA, 100);
        writer.close();
        Msa msa = this.infer(file, opts);
        file.delete();
        return msa;
    }

    @Override
    public Msa infer(File path_to_input_seqs, List<String> opts) throws IOException, InterruptedException {
        this.init();
        ArrayList<String> my_opts = new ArrayList<String>();
        my_opts.add(this._path_to_prg);
        for (int i = 0; i < opts.size(); ++i) {
            my_opts.add(opts.get(i));
        }
        my_opts.add(path_to_input_seqs.getAbsolutePath());
        SystemCommandExecutor command_executor = new SystemCommandExecutor(my_opts);
        int _exit_code = command_executor.executeCommand();
        StringBuilder stderr = command_executor.getStandardErrorFromCommand();
        this._error = stderr.toString();
        if (_exit_code != 0) {
            throw new IOException("MAFFT program failed, exit code: " + _exit_code + "\nCommand:\n" + my_opts + "\nError:\n" + stderr);
        }
        StringBuilder stdout = command_executor.getStandardOutputFromCommand();
        if (stdout == null || stdout.length() < 2) {
            throw new IOException("MAFFT program did not produce any output\nCommand:\n" + my_opts + "\nError:\n" + stderr);
        }
        Msa msa = FastaParser.parseMsa(stdout.toString());
        return msa;
    }

    private void init() {
        this._error = null;
        this._exit_code = -100;
    }
}

