/*
 * Decompiled with CFR 0.152.
 */
package org.forester.pccx;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.forester.pccx.BranchCountingBasedScoringMethod;
import org.forester.pccx.CoverageCalculationOptions;
import org.forester.pccx.CoverageExtender;
import org.forester.pccx.ExternalNodeBasedCoverageMethodOptions;
import org.forester.pccx.ModelingUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public class BasicExternalNodeBasedCoverageExtender
implements CoverageExtender {
    private String find(CoverageCalculationOptions options, BranchCountingBasedScoringMethod scoring_method, List<SortedMap<PhylogenyNode, Double>> external_node_scores_list, List<SortedMap<PhylogenyNode, Double>> external_node_scores_list_temp, List<Phylogeny> phylogenies, Set<String> already_covered, PrintStream out, int i, double normalization_factor) {
        Phylogeny p = phylogenies.get(0);
        String best_name = null;
        double best_score = -1.7976931348623157E308;
        PhylogenyNodeIterator iter = p.iteratorExternalForward();
        while (iter.hasNext()) {
            double score;
            String name = iter.next().getName();
            if (already_covered.contains(name) || !((score = BasicExternalNodeBasedCoverageExtender.calculateCoverage(phylogenies, name, options, scoring_method, external_node_scores_list_temp, false)) > best_score)) continue;
            best_score = score;
            best_name = name;
        }
        BasicExternalNodeBasedCoverageExtender.calculateCoverage(phylogenies, best_name, options, scoring_method, external_node_scores_list_temp, true);
        if (out != null) {
            out.println(i + "\t" + best_name + "\t" + best_score * normalization_factor);
        }
        return best_name;
    }

    @Override
    public List<String> find(List<Phylogeny> phylogenies, List<String> already_covered, int number_names_to_find, CoverageCalculationOptions options, PrintStream out) {
        BranchCountingBasedScoringMethod scoring_method;
        ExternalNodeBasedCoverageMethodOptions my_options = (ExternalNodeBasedCoverageMethodOptions)options;
        if (my_options == null || ForesterUtil.isEmpty(my_options.getScoringMethod())) {
            throw new IllegalArgumentException("options for external node based coverage method appear to not have been set");
        }
        try {
            scoring_method = (BranchCountingBasedScoringMethod)Class.forName(my_options.getScoringMethod()).newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not create scoring method class \"" + my_options.getScoringMethod() + "\"");
        }
        ArrayList<String> best_names = new ArrayList<String>();
        HashSet<String> my_already_covered = new HashSet<String>();
        ArrayList<SortedMap<PhylogenyNode, Double>> external_node_scores_list = new ArrayList<SortedMap<PhylogenyNode, Double>>();
        for (int i = 0; i < phylogenies.size(); ++i) {
            external_node_scores_list.add(ModelingUtils.setUpExternalCoverageHashMap(phylogenies.get(i)));
        }
        if (already_covered != null) {
            for (String name : already_covered) {
                my_already_covered.add(name);
                BasicExternalNodeBasedCoverageExtender.calculateCoverage(phylogenies, name, options, scoring_method, external_node_scores_list, true);
            }
        }
        if (number_names_to_find < 1) {
            number_names_to_find = phylogenies.get(0).getNumberOfExternalNodes() - my_already_covered.size();
        }
        double normalization_factor = scoring_method.getNormalizationFactor(phylogenies.get(0));
        for (int i = 0; i < number_names_to_find; ++i) {
            String name = this.find(my_options, scoring_method, external_node_scores_list, external_node_scores_list, phylogenies, my_already_covered, out, i, normalization_factor);
            my_already_covered.add(name);
            best_names.add(name);
        }
        return best_names;
    }

    private static double calculateCoverage(List<Phylogeny> phylogenies, String name, CoverageCalculationOptions options, BranchCountingBasedScoringMethod scoring_method, List<SortedMap<PhylogenyNode, Double>> external_node_scores_list, boolean update_external_node_scores_list) {
        int i = 0;
        double score_sum = 0.0;
        for (Phylogeny element : phylogenies) {
            SortedMap<PhylogenyNode, Double> external_node_scores = update_external_node_scores_list ? external_node_scores_list.get(i++) : new TreeMap<PhylogenyNode, Double>(external_node_scores_list.get(i++));
            Phylogeny phylogeny = element;
            scoring_method.calculateScoreForExternalNode(external_node_scores, phylogeny, phylogeny.getNode(name), options);
            for (Double element2 : external_node_scores.values()) {
                score_sum += element2.doubleValue();
            }
        }
        return score_sum / (double)i;
    }
}

