/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny;

import java.util.ArrayList;
import java.util.List;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.phylogeny.data.BranchData;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.NodeData;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.ForesterUtil;

public final class PhylogenyNode
implements Comparable<PhylogenyNode> {
    private static long NODE_COUNT = 0L;
    private BranchData _branch_data;
    private boolean _collapse;
    private ArrayList<PhylogenyNode> _descendants;
    private double _distance_parent = -1024.0;
    private long _id;
    private byte _indicator;
    private PhylogenyNode _link;
    private NodeData _node_data;
    private PhylogenyNode _parent;
    private int _sum_ext_nodes;
    private float _x;
    private float _x_secondary;
    private float _y;
    private float _y_secondary;

    public PhylogenyNode() {
        this.setId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public PhylogenyNode(String node_name) {
        this.setId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
        if (node_name != null) {
            this.getNodeData().setNodeName(node_name);
        }
    }

    private PhylogenyNode(String nhx, NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction, boolean replace_underscores) throws NHXFormatException, PhyloXmlDataFormatException {
        NHXParser.parseNHX(nhx, this, taxonomy_extraction, replace_underscores, false, false);
        this.setId(PhylogenyNode.getNodeCount());
        PhylogenyNode.increaseNodeCount();
        this.setSumExtNodes(1);
    }

    public final void addAsChild(PhylogenyNode node) {
        PhylogenyNode n = node;
        this.addChildNode(n);
        n.setParent(this);
    }

    public final int calculateDepth() {
        PhylogenyNode n = this;
        int steps = 0;
        while (n._parent != null) {
            ++steps;
            n = n._parent;
        }
        return steps;
    }

    public final double calculateDistanceToRoot() {
        PhylogenyNode n = this;
        double d = 0.0;
        while (n._parent != null) {
            if (n._distance_parent > 0.0) {
                d += n._distance_parent;
            }
            n = n._parent;
        }
        return d;
    }

    @Override
    public final int compareTo(PhylogenyNode o) {
        PhylogenyNode n = o;
        if (this.getName() == null || n.getName() == null) {
            return 0;
        }
        return this.getName().compareTo(n.getName());
    }

    public final PhylogenyNode copyNodeData() {
        PhylogenyNode node = new PhylogenyNode();
        PhylogenyNode.decreaseNodeCount();
        node._id = this._id;
        node._sum_ext_nodes = this._sum_ext_nodes;
        node._indicator = this._indicator;
        node._x = this._x;
        node._y = this._y;
        node._distance_parent = this._distance_parent;
        node._collapse = this._collapse;
        node._link = this._link;
        if (this._node_data != null) {
            node._node_data = (NodeData)this._node_data.copy();
        }
        if (this._branch_data != null) {
            node._branch_data = (BranchData)this._branch_data.copy();
        }
        return node;
    }

    public final PhylogenyNode copyNodeDataShallow() {
        PhylogenyNode node = new PhylogenyNode();
        PhylogenyNode.decreaseNodeCount();
        node._id = this._id;
        node._sum_ext_nodes = this._sum_ext_nodes;
        node._indicator = this._indicator;
        node._x = this._x;
        node._y = this._y;
        node._distance_parent = this._distance_parent;
        node._collapse = this._collapse;
        node._link = this._link;
        node._node_data = this._node_data;
        node._branch_data = this._branch_data;
        return node;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            throw new IllegalArgumentException("attempt to check [" + this.getClass() + "] equality to " + o + " [" + o.getClass() + "]");
        }
        PhylogenyNode other = (PhylogenyNode)o;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        NodeData this_data = this.getNodeData();
        NodeData other_data = other.getNodeData();
        if (this_data.isHasSequence() && other_data.isHasSequence() && this_data.isHasTaxonomy() && other_data.isHasTaxonomy()) {
            return this_data.getTaxonomy().isEqual(other_data.getTaxonomy()) && this_data.getSequence().isEqual(other_data.getSequence());
        }
        if (this_data.isHasTaxonomy() && other_data.isHasTaxonomy()) {
            return this_data.getTaxonomy().isEqual(other_data.getTaxonomy());
        }
        if (this_data.isHasSequence() && other_data.isHasSequence()) {
            return this_data.getSequence().isEqual(other_data.getSequence());
        }
        return this.getName().length() > 0;
    }

    public final List<PhylogenyNode> getAllDescendants() {
        return this._descendants;
    }

    public final List<PhylogenyNode> getAllExternalDescendants() {
        ArrayList<PhylogenyNode> nodes = new ArrayList<PhylogenyNode>();
        if (this.isExternal()) {
            nodes.add(this);
            return nodes;
        }
        PhylogenyNode node1 = this;
        while (!node1.isExternal()) {
            node1 = node1.getFirstChildNode();
        }
        PhylogenyNode node2 = this;
        while (!node2.isExternal()) {
            node2 = node2.getLastChildNode();
        }
        while (node1 != node2) {
            nodes.add(node1);
            node1 = node1.getNextExternalNode();
        }
        nodes.add(node2);
        return nodes;
    }

    public final List<String> getAllExternalDescendantsNames() {
        List<PhylogenyNode> c = this.getAllExternalDescendants();
        ArrayList<String> n = new ArrayList<String>(c.size());
        for (PhylogenyNode phylogenyNode : c) {
            n.add(phylogenyNode.getName());
        }
        return n;
    }

    public final BranchData getBranchData() {
        if (this._branch_data == null) {
            this._branch_data = new BranchData();
        }
        return this._branch_data;
    }

    public final PhylogenyNode getChildNode(int i) {
        if (this.isExternal()) {
            throw new UnsupportedOperationException("attempt to get the child node of an external node.");
        }
        if (i >= this.getNumberOfDescendants() || i < 0) {
            throw new IllegalArgumentException("attempt to get child node " + i + " of a node with " + this.getNumberOfDescendants() + " child nodes");
        }
        return this.getDescendants().get(i);
    }

    public final PhylogenyNode getChildNode1() {
        return this.getChildNode(0);
    }

    public final PhylogenyNode getChildNode2() {
        return this.getChildNode(1);
    }

    public final int getChildNodeIndex() {
        return this.getChildNodeIndex(this.getParent());
    }

    public final int getChildNodeIndex(PhylogenyNode parent) {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the child index for a root node.");
        }
        for (int i = 0; i < parent.getNumberOfDescendants(); ++i) {
            if (parent.getChildNode(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Unexpected exception: Could not determine the child index for node: " + this);
    }

    public final List<PhylogenyNode> getDescendants() {
        if (this._descendants == null) {
            this._descendants = new ArrayList();
        }
        return this._descendants;
    }

    public final double getDistanceToParent() {
        return this._distance_parent;
    }

    public final PhylogenyNode getFirstChildNode() {
        return this.getChildNode(0);
    }

    public final long getId() {
        return this._id;
    }

    public final byte getIndicator() {
        return this._indicator;
    }

    public final PhylogenyNode getLastChildNode() {
        return this.getChildNode(this.getNumberOfDescendants() - 1);
    }

    public final PhylogenyNode getLink() {
        return this._link;
    }

    public final String getName() {
        return this.getNodeData().getNodeName();
    }

    public final PhylogenyNode getNextExternalNode() {
        if (this.isInternal()) {
            throw new UnsupportedOperationException("attempt to get next external node of an internal node");
        }
        if (this.isLastExternalNode()) {
            return null;
        }
        int index = this.getChildNodeIndex();
        PhylogenyNode previous_node = this;
        PhylogenyNode current_node = this.getParent();
        while (!current_node.isRoot() && (current_node.getNumberOfDescendants() == 1 || previous_node.isLastChildNode())) {
            index = current_node.getChildNodeIndex();
            previous_node = current_node;
            current_node = current_node.getParent();
        }
        current_node = current_node.getChildNode(index + 1);
        while (current_node.isInternal()) {
            current_node = current_node.getFirstChildNode();
        }
        return current_node;
    }

    public final PhylogenyNode getNextExternalNodeWhileTakingIntoAccountCollapsedNodes() {
        if (this.isInternal() && !this.isCollapse()) {
            throw new UnsupportedOperationException("attempt to get next external node of an uncollapsed internal node");
        }
        if (this.isRoot()) {
            return null;
        }
        if (this.getParent().isCollapse()) {
            throw new UnsupportedOperationException("attempt to get next external node of node with a collapsed parent");
        }
        PhylogenyNode n = this;
        boolean last = true;
        while (!n.isRoot()) {
            if (!n.isLastChildNode()) {
                last = false;
                break;
            }
            n = n.getParent();
        }
        if (last) {
            return null;
        }
        int index = this.getChildNodeIndex();
        PhylogenyNode previous_node = this;
        PhylogenyNode current_node = this.getParent();
        while (!current_node.isRoot() && (current_node.isCollapse() || current_node.getNumberOfDescendants() == 1 || previous_node.isLastChildNode())) {
            index = current_node.getChildNodeIndex();
            previous_node = current_node;
            current_node = current_node.getParent();
        }
        if (index < current_node.getNumberOfDescendants() - 1) {
            current_node = current_node.getChildNode(index + 1);
        }
        while (current_node.isInternal() && !current_node.isCollapse()) {
            current_node = current_node.getFirstChildNode();
        }
        return current_node;
    }

    public final NodeData getNodeData() {
        if (this._node_data == null) {
            this._node_data = new NodeData();
        }
        return this._node_data;
    }

    public final int getNumberOfDescendants() {
        if (this._descendants == null) {
            return 0;
        }
        return this._descendants.size();
    }

    public final int getNumberOfExternalNodes() {
        return this._sum_ext_nodes;
    }

    public final int getNumberOfParents() {
        return 1;
    }

    public final PhylogenyNode getParent() {
        return this._parent;
    }

    public final PhylogenyNode getPreviousExternalNode() {
        if (this.isInternal()) {
            throw new UnsupportedOperationException("Cannot get the previous external node for an internal node.");
        }
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot get the previous external node for a root node.");
        }
        if (this.isFirstExternalNode()) {
            throw new UnsupportedOperationException("Attempt to get previous external node of the first external node.");
        }
        int index = this.getChildNodeIndex();
        PhylogenyNode previous_node = this;
        PhylogenyNode current_node = this.getParent();
        while (!current_node.isRoot() && (current_node.getNumberOfDescendants() == 1 || previous_node.isFirstChildNode())) {
            index = current_node.getChildNodeIndex();
            previous_node = current_node;
            current_node = current_node.getParent();
        }
        current_node = current_node.getChildNode(index - 1);
        while (current_node.isInternal()) {
            current_node = current_node.getLastChildNode();
        }
        return current_node;
    }

    public final float getXcoord() {
        return this._x;
    }

    public final float getXSecondary() {
        return this._x_secondary;
    }

    public final float getYcoord() {
        return this._y;
    }

    public final float getYSecondary() {
        return this._y_secondary;
    }

    public final int hashCode() {
        NodeData data = this.getNodeData();
        if (this.getName().length() < 1 && !data.isHasSequence() && !data.isHasTaxonomy()) {
            return super.hashCode();
        }
        int result = this.getName().hashCode();
        if (data.isHasSequence()) {
            result ^= data.getSequence().hashCode();
        }
        if (data.isHasTaxonomy()) {
            result ^= data.getTaxonomy().hashCode();
        }
        return result;
    }

    public final boolean isCollapse() {
        return this._collapse;
    }

    public final boolean isDuplication() {
        return this.getNodeData().isHasEvent() && this.getNodeData().getEvent().isDuplication();
    }

    public boolean isEmpty() {
        return this._node_data == null || this._node_data.isEmpty();
    }

    public final boolean isExternal() {
        if (this._descendants == null) {
            return true;
        }
        return this.getNumberOfDescendants() < 1;
    }

    public final boolean isFirstChildNode() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot determine whether the root is the first child node of its _parent.");
        }
        return this.getChildNodeIndex() == 0;
    }

    public final boolean isFirstExternalNode() {
        if (this.isInternal()) {
            return false;
        }
        PhylogenyNode node = this;
        while (!node.isRoot()) {
            if (!node.isFirstChildNode()) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    public final boolean isHasAssignedEvent() {
        if (!this.getNodeData().isHasEvent()) {
            return false;
        }
        return !this.getNodeData().getEvent().isUnassigned();
    }

    public final boolean isInternal() {
        return !this.isExternal();
    }

    public final boolean isLastChildNode() {
        if (this.isRoot()) {
            throw new UnsupportedOperationException("Cannot determine whether the root is the last child node of its _parent.");
        }
        return this.getChildNodeIndex() == this.getParent().getNumberOfDescendants() - 1;
    }

    public final boolean isLastExternalNode() {
        if (this.isInternal()) {
            return false;
        }
        PhylogenyNode node = this;
        while (!node.isRoot()) {
            if (!node.isLastChildNode()) {
                return false;
            }
            node = node.getParent();
        }
        return true;
    }

    public final boolean isRoot() {
        return this._parent == null;
    }

    public final boolean isSpeciation() {
        return this.getNodeData().isHasEvent() && this.getNodeData().getEvent().isSpeciation();
    }

    public void preorderPrint() {
        System.out.println(this + "\n");
        if (this.isInternal()) {
            for (int i = 0; i < this.getNumberOfDescendants(); ++i) {
                this.getChildNode(i).preorderPrint();
            }
        }
    }

    public final void removeChildNode(int i) {
        if (this.isExternal()) {
            throw new UnsupportedOperationException("cannot get the child node for a external node.");
        }
        if (i >= this.getNumberOfDescendants() || i < 0) {
            throw new IllegalArgumentException("attempt to get child node " + i + " of a node with " + this.getNumberOfDescendants() + " child nodes.");
        }
        this.getDescendants().remove(i);
    }

    public final void removeChildNode(PhylogenyNode remove_me) {
        this.removeChildNode(remove_me.getChildNodeIndex());
    }

    public void removeConnections() {
        this._parent = null;
        this._link = null;
        this._descendants = null;
    }

    public final void setBranchData(BranchData branch_data) {
        this._branch_data = branch_data;
    }

    public final void setChild1(PhylogenyNode n) {
        this.setChildNode(0, n);
    }

    public final void setChild2(PhylogenyNode n) {
        this.setChildNode(1, n);
    }

    public final void setChildNode(int i, PhylogenyNode node) {
        node.setParent(this);
        if (this.getNumberOfDescendants() <= i) {
            this.addChildNode(node);
        } else {
            this.getDescendants().set(i, node);
        }
    }

    public final void setCollapse(boolean b) {
        this._collapse = b;
    }

    public final void setDistanceToParent(double d) {
        this._distance_parent = d;
    }

    public final void setIndicator(byte i) {
        this._indicator = i;
    }

    public final void setLink(PhylogenyNode n) {
        this._link = n;
    }

    public final void setName(String node_name) {
        this.getNodeData().setNodeName(node_name);
    }

    public final void setParent(PhylogenyNode n) {
        this._parent = n;
    }

    public final void setSumExtNodes(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("attempt to set sum of external nodes to less than one");
        }
        this._sum_ext_nodes = i;
    }

    public final void setXcoord(float x) {
        this._x = x;
    }

    public final void setXSecondary(float x_secondary) {
        this._x_secondary = x_secondary;
    }

    public final void setYcoord(float y) {
        this._y = y;
    }

    public final void setYSecondary(float y_secondary) {
        this._y_secondary = y_secondary;
    }

    public final void swapChildren() throws RuntimeException {
        if (this.isExternal()) {
            throw new RuntimeException("attempt to swap descendants of external node");
        }
        if (this.getNumberOfDescendants() != 2) {
            throw new RuntimeException("attempt to swap descendants of node with " + this.getNumberOfDescendants() + " descendants");
        }
        PhylogenyNode a = this.getChildNode(0);
        PhylogenyNode b = this.getChildNode(1);
        this.setChildNode(0, b);
        this.setChildNode(1, a);
    }

    public final String toNewHampshire(boolean write_distance_to_parent, NH_CONVERSION_SUPPORT_VALUE_STYLE svs) {
        String data = "";
        if (svs == NH_CONVERSION_SUPPORT_VALUE_STYLE.AS_INTERNAL_NODE_NAMES && !this.isExternal()) {
            if (this.getBranchData().isHasConfidences() && this.getBranchData().getConfidence(0).getValue() != -9999.0) {
                data = Confidence.FORMATTER.format(ForesterUtil.round(this.getBranchData().getConfidence(0).getValue(), 9));
            }
        } else if (!ForesterUtil.isEmpty(this.getName())) {
            data = this.getName();
        } else if (this.getNodeData().isHasTaxonomy()) {
            if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getTaxonomyCode())) {
                data = this.getNodeData().getTaxonomy().getTaxonomyCode();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getScientificName())) {
                data = this.getNodeData().getTaxonomy().getScientificName();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getCommonName())) {
                data = this.getNodeData().getTaxonomy().getCommonName();
            }
        } else if (this.getNodeData().isHasSequence()) {
            if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getName())) {
                data = this.getNodeData().getSequence().getName();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getSymbol())) {
                data = this.getNodeData().getSequence().getSymbol();
            } else if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getGeneName())) {
                data = this.getNodeData().getSequence().getGeneName();
            }
        }
        StringBuilder sb = ForesterUtil.santitizeStringForNH(data);
        if (write_distance_to_parent && this.getDistanceToParent() != -1024.0) {
            sb.append(":");
            sb.append(this.getDistanceToParent());
        }
        if (svs == NH_CONVERSION_SUPPORT_VALUE_STYLE.IN_SQUARE_BRACKETS && !this.isExternal() && this.getBranchData().isHasConfidences() && this.getBranchData().getConfidence(0).getValue() != -9999.0) {
            sb.append("[");
            sb.append(Confidence.FORMATTER.format(ForesterUtil.round(this.getBranchData().getConfidence(0).getValue(), 9)));
            sb.append("]");
        }
        return sb.toString();
    }

    public final String toNewHampshireX() {
        StringBuilder sb = new StringBuilder();
        StringBuffer s_nhx = new StringBuffer();
        if (!ForesterUtil.isEmpty(this.getName())) {
            sb.append((CharSequence)ForesterUtil.santitizeStringForNH(this.getName()));
        }
        if (this.getDistanceToParent() != -1024.0) {
            sb.append(":");
            sb.append(this.getDistanceToParent());
        }
        if (this.getNodeDataDirectly() != null) {
            s_nhx.append(this.getNodeDataDirectly().toNHX());
        }
        if (this.getBranchDataDirectly() != null) {
            s_nhx.append(this.getBranchDataDirectly().toNHX());
        }
        if (s_nhx.length() > 0) {
            sb.append("[&&NHX");
            sb.append(s_nhx);
            sb.append("]");
        }
        return sb.toString();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        if (!ForesterUtil.isEmpty(this.getName())) {
            sb.append(this.getName());
            sb.append(" ");
        }
        if (this.getNodeData().isHasTaxonomy()) {
            if (!ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getScientificName())) {
                sb.append(this.getNodeData().getTaxonomy().getScientificName());
                sb.append(" ");
            } else if (sb.length() <= 1 && !ForesterUtil.isEmpty(this.getNodeData().getTaxonomy().getTaxonomyCode())) {
                sb.append(this.getNodeData().getTaxonomy().getTaxonomyCode());
                sb.append(" ");
            } else if (this.getNodeData().getTaxonomy().getIdentifier() != null) {
                sb.append(this.getNodeData().getTaxonomy().getIdentifier().toString());
                sb.append(" ");
            }
        }
        if (this.getNodeData().isHasSequence()) {
            if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getName())) {
                sb.append(this.getNodeData().getSequence().getName());
                sb.append(" ");
            }
            if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getSymbol())) {
                sb.append(this.getNodeData().getSequence().getSymbol());
                sb.append(" ");
            }
            if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getGeneName())) {
                sb.append(this.getNodeData().getSequence().getGeneName());
                sb.append(" ");
            }
            if (this.getNodeData().getSequence().getAccession() != null) {
                sb.append(this.getNodeData().getSequence().getAccession().toString());
                sb.append(" ");
            }
            if (!ForesterUtil.isEmpty(this.getNodeData().getSequence().getMolecularSequence())) {
                sb.append(this.getNodeData().getSequence().getMolecularSequence());
                sb.append(" ");
            }
        }
        if (sb.length() <= 1) {
            sb.append("[");
            sb.append(this.getId());
            sb.append("]");
        }
        return sb.toString().trim();
    }

    protected final synchronized void setId(long i) {
        if (i < PhylogenyNode.getNodeCount()) {
            throw new IllegalArgumentException("attempt to set node id to a value less than total node count (thus violating the uniqueness of node ids)");
        }
        this._id = i;
    }

    final BranchData getBranchDataDirectly() {
        return this._branch_data;
    }

    final NodeData getNodeDataDirectly() {
        return this._node_data;
    }

    final void setChildNodeOnly(int i, PhylogenyNode node) {
        if (this.getNumberOfDescendants() <= i) {
            this.addChildNode(node);
        } else {
            this.getDescendants().set(i, node);
        }
    }

    final void setIndicatorsToZero() {
        PreorderTreeIterator it = new PreorderTreeIterator(this);
        while (it.hasNext()) {
            it.next().setIndicator((byte)0);
        }
    }

    private final void addChildNode(PhylogenyNode child) {
        this.getDescendants().add(child);
    }

    public static PhylogenyNode createInstanceFromNhxString(String nhx) throws NHXFormatException, PhyloXmlDataFormatException {
        return new PhylogenyNode(nhx, NHXParser.TAXONOMY_EXTRACTION.NO, false);
    }

    public static PhylogenyNode createInstanceFromNhxString(String nhx, NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction) throws NHXFormatException, PhyloXmlDataFormatException {
        return new PhylogenyNode(nhx, taxonomy_extraction, false);
    }

    public static PhylogenyNode createInstanceFromNhxString(String nhx, NHXParser.TAXONOMY_EXTRACTION taxonomy_extraction, boolean replace_underscores) throws NHXFormatException, PhyloXmlDataFormatException {
        return new PhylogenyNode(nhx, taxonomy_extraction, replace_underscores);
    }

    public static final synchronized long getNodeCount() {
        return NODE_COUNT;
    }

    static final synchronized void decreaseNodeCount() {
        --NODE_COUNT;
    }

    static final synchronized void setNodeCount(long i) {
        NODE_COUNT = i;
    }

    private static final synchronized void increaseNodeCount() {
        ++NODE_COUNT;
    }

    public static enum NH_CONVERSION_SUPPORT_VALUE_STYLE {
        AS_INTERNAL_NODE_NAMES,
        IN_SQUARE_BRACKETS,
        NONE;

    }
}

