/*
 * Decompiled with CFR 0.152.
 */
package org.forester.phylogeny.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.forester.phylogeny.data.PhylogenyData;
import org.forester.phylogeny.data.PhylogenyDataUtil;
import org.forester.phylogeny.data.Point;
import org.forester.util.ForesterUtil;

public class Polygon
implements PhylogenyData {
    private final List<Point> _points;

    public Polygon(List<Point> points) {
        this._points = points;
    }

    @Override
    public StringBuffer asSimpleText() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (Point point : this.getPoints()) {
            if (first) {
                first = false;
            } else {
                sb.append(ForesterUtil.LINE_SEPARATOR);
            }
            sb.append(point.asSimpleText());
        }
        return sb;
    }

    @Override
    public StringBuffer asText() {
        return this.asSimpleText();
    }

    @Override
    public PhylogenyData copy() {
        ArrayList<Point> new_points = new ArrayList<Point>();
        for (Point point : this.getPoints()) {
            new_points.add((Point)point.copy());
        }
        return new Polygon(new_points);
    }

    public List<Point> getPoints() {
        return this._points;
    }

    public boolean isEmpty() {
        return ForesterUtil.isEmpty(this._points);
    }

    @Override
    public boolean isEqual(PhylogenyData data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StringBuffer toNHX() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toPhyloXML(Writer writer, int level, String indentation) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendOpen(writer, "polygon");
        for (Point point : this.getPoints()) {
            point.toPhyloXML(writer, level, indentation + "  ");
            writer.write(indentation);
        }
        writer.write(ForesterUtil.LINE_SEPARATOR);
        writer.write(indentation);
        PhylogenyDataUtil.appendClose(writer, "polygon");
    }
}

