/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.math;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import fr.profi.util.math.RatioFitting$;
import fr.profi.util.math.RatioFitting$$anonfun$buildImputedRatioMatrix$1$;
import fr.profi.util.math.RatioFitting$$anonfun$buildRatioMatrix$1$;
import fr.profi.util.math.package$;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class RatioFitting$
implements LazyLogging {
    public static final RatioFitting$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new RatioFitting$();
    }

    private Logger logger$lzycompute() {
        RatioFitting$ ratioFitting$ = this;
        synchronized (ratioFitting$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public float[] fit(float[][] abundanceMatrix, float[] minAbundances) {
        int[] valuesCountByColumns = (int[])Predef$.MODULE$.refArrayOps(Predef$.MODULE$.refArrayOps((Object[])abundanceMatrix).transpose((Function1)Predef$.MODULE$.$conforms())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(float[] col) {
                return Predef$.MODULE$.floatArrayOps(col).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(float x$1) {
                        return this.apply$mcZF$sp(x$1);
                    }

                    public boolean apply$mcZF$sp(float x$1) {
                        return !Predef$.MODULE$.float2Float(x$1).isNaN();
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return this._fit(abundanceMatrix, this.buildImputedRatioMatrix(abundanceMatrix, minAbundances, valuesCountByColumns), valuesCountByColumns);
    }

    public float[] fitWithoutImputation(float[][] abundanceMatrix) {
        int[] valuesCountByColumns = (int[])Predef$.MODULE$.refArrayOps(Predef$.MODULE$.refArrayOps((Object[])abundanceMatrix).transpose((Function1)Predef$.MODULE$.$conforms())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(float[] col) {
                return Predef$.MODULE$.floatArrayOps(col).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(float x$2) {
                        return this.apply$mcZF$sp(x$2);
                    }

                    public boolean apply$mcZF$sp(float x$2) {
                        return !Predef$.MODULE$.float2Float(x$2).isNaN();
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        return this._fit(abundanceMatrix, this.buildRatioMatrix(abundanceMatrix), valuesCountByColumns);
    }

    public float[] fitWithCountPredicate(float[][] abundanceMatrix, int minRatioCount) {
        ObjectRef matrix = ObjectRef.create((Object)((float[][])Predef$.MODULE$.refArrayOps((Object[])abundanceMatrix).transpose((Function1)Predef$.MODULE$.$conforms())));
        int[] valuesCountByColumns = (int[])Predef$.MODULE$.refArrayOps((Object[])((float[][])matrix.elem)).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(float[] col) {
                return Predef$.MODULE$.floatArrayOps(col).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(float x$3) {
                        return this.apply$mcZF$sp(x$3);
                    }

                    public boolean apply$mcZF$sp(float x$3) {
                        return !Predef$.MODULE$.float2Float(x$3).isNaN();
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        valuesCountByColumns = (int[])Predef$.MODULE$.intArrayOps(valuesCountByColumns).map((Function1)new Serializable(abundanceMatrix, minRatioCount){
            public static final long serialVersionUID = 0L;
            private final float[][] abundanceMatrix$1;
            private final int minRatioCount$1;

            public final int apply(int c) {
                return this.apply$mcII$sp(c);
            }

            public int apply$mcII$sp(int c) {
                return c < scala.math.package$.MODULE$.min(this.minRatioCount$1, this.abundanceMatrix$1.length - 1) ? 0 : c;
            }
            {
                this.abundanceMatrix$1 = abundanceMatrix$1;
                this.minRatioCount$1 = minRatioCount$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(valuesCountByColumns).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(abundanceMatrix, matrix){
            public static final long serialVersionUID = 0L;
            private final float[][] abundanceMatrix$1;
            private final ObjectRef matrix$1;

            public final void apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    int c = tuple2._1$mcI$sp();
                    int index = tuple2._2$mcI$sp();
                    if (c == 0) {
                        ((float[][])this.matrix$1.elem)[index] = (float[])Array$.MODULE$.fill(this.abundanceMatrix$1.length, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final float apply() {
                                return this.apply$mcF$sp();
                            }

                            public float apply$mcF$sp() {
                                return Float.NaN;
                            }
                        }, ClassTag$.MODULE$.Float());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.abundanceMatrix$1 = abundanceMatrix$1;
                this.matrix$1 = matrix$1;
            }
        });
        matrix.elem = (float[][])Predef$.MODULE$.refArrayOps((Object[])((float[][])matrix.elem)).transpose((Function1)Predef$.MODULE$.$conforms());
        return this._fit((float[][])matrix.elem, this.buildRatioMatrix((float[][])matrix.elem), valuesCountByColumns);
    }

    private float[] _fit(float[][] abundanceMatrix, double[][] imputedRatioMatrixr, int[] valuesCountByColumns) {
        double[] ratios = this.rowMedian(imputedRatioMatrixr);
        double[] logRatios = (double[])Predef$.MODULE$.doubleArrayOps(ratios).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$4) {
                return this.apply$mcDD$sp(x$4);
            }

            public double apply$mcDD$sp(double x$4) {
                return Math.log(x$4);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        int[] naNRatiosIndexes = (int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(logRatios).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> p) {
                return Predef$.MODULE$.double2Double(p._1$mcD$sp()).isNaN();
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x$5) {
                return x$5._2$mcI$sp();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        double[] filteredLogRatios = (double[])Predef$.MODULE$.doubleArrayOps(logRatios).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double x$6) {
                return this.apply$mcZD$sp(x$6);
            }

            public boolean apply$mcZD$sp(double x$6) {
                return !Predef$.MODULE$.double2Double(x$6).isNaN();
            }
        });
        if (Predef$.MODULE$.doubleArrayOps(filteredLogRatios).isEmpty()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("No eligible columns for ratios computation");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (float[])Predef$.MODULE$.refArrayOps(Predef$.MODULE$.refArrayOps((Object[])abundanceMatrix).transpose((Function1)Predef$.MODULE$.$conforms())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final float apply(float[] x$7) {
                    return RatioFitting$.MODULE$.fr$profi$util$math$RatioFitting$$_calcAbundanceSum(x$7);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        }
        double[][] gc = this.buildCoefficientMatrix(abundanceMatrix, naNRatiosIndexes);
        DecompositionSolver solver = new SingularValueDecomposition((RealMatrix)new Array2DRowRealMatrix(gc, false)).getSolver();
        ArrayRealVector constants = new ArrayRealVector(filteredLogRatios, false);
        RealVector solution = solver.solve((RealVector)constants);
        double[] coeffs = solution.toArray();
        coeffs = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(coeffs).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(valuesCountByColumns){
            public static final long serialVersionUID = 0L;
            private final int[] valuesCountByColumns$1;

            public final double apply(Tuple2<Object, Object> x0$2) {
                Tuple2<Object, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    double p = tuple2._1$mcD$sp();
                    int i = tuple2._2$mcI$sp();
                    double d = this.valuesCountByColumns$1[i] == 0 ? 0.0 : Math.exp(p);
                    return d;
                }
                throw new MatchError(tuple2);
            }
            {
                this.valuesCountByColumns$1 = valuesCountByColumns$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        double coeffSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(coeffs).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$8, double x$9) {
                return this.apply$mcDDD$sp(x$8, x$9);
            }

            public double apply$mcDDD$sp(double x$8, double x$9) {
                return x$8 + x$9;
            }
        }));
        double intensitySum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps((double[])Predef$.MODULE$.refArrayOps((Object[])abundanceMatrix).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(float[] x$10) {
                return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.floatArrayOps(x$10).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, float b) {
                        return Predef$.MODULE$.float2Float(b).isNaN() ? a : a + (double)b;
                    }
                }));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double a, double b) {
                return this.apply$mcDDD$sp(a, b);
            }

            public double apply$mcDDD$sp(double a, double b) {
                return a + b;
            }
        }));
        coeffs = (double[])Predef$.MODULE$.doubleArrayOps(coeffs).map((Function1)new Serializable(coeffSum, intensitySum){
            public static final long serialVersionUID = 0L;
            private final double coeffSum$1;
            private final double intensitySum$1;

            public final double apply(double x$11) {
                return this.apply$mcDD$sp(x$11);
            }

            public double apply$mcDD$sp(double x$11) {
                return x$11 * this.intensitySum$1 / this.coeffSum$1;
            }
            {
                this.coeffSum$1 = coeffSum$1;
                this.intensitySum$1 = intensitySum$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        float[] abundances = (float[])Predef$.MODULE$.doubleArrayOps(coeffs).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(double x$12) {
                return this.apply$mcFD$sp(x$12);
            }

            public float apply$mcFD$sp(double x$12) {
                return (float)x$12;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        abundances = (float[])Predef$.MODULE$.floatArrayOps(abundances).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(float p) {
                return this.apply$mcFF$sp(p);
            }

            public float apply$mcFF$sp(float p) {
                return (double)p == 0.0 ? Float.NaN : p;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        return abundances;
    }

    private double[][] buildImputedRatioMatrix(float[][] pep, float[] min, int[] valuesColumnCount) {
        ObjectRef ratiosMatrix = ObjectRef.create((Object)this.buildRatioMatrix(pep));
        int[] nonNullRatiosCount = (int[])Predef$.MODULE$.refArrayOps(Predef$.MODULE$.refArrayOps((Object[])((double[][])ratiosMatrix.elem)).transpose((Function1)Predef$.MODULE$.$conforms())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(double[] col) {
                return Predef$.MODULE$.doubleArrayOps(col).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(double x$13) {
                        return this.apply$mcZD$sp(x$13);
                    }

                    public boolean apply$mcZD$sp(double x$13) {
                        return !Predef$.MODULE$.double2Double(x$13).isNaN();
                    }
                });
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        IntRef rowIdx = IntRef.create((int)0);
        Predef$.MODULE$.refArrayOps((Object[])pep).foreach((Function1)new Serializable(min, ratiosMatrix, nonNullRatiosCount, rowIdx){
            public static final long serialVersionUID = 0L;
            public final float[] min$1;
            private final ObjectRef ratiosMatrix$1;
            public final int[] nonNullRatiosCount$1;
            private final IntRef rowIdx$1;

            public final void apply(float[] row) {
                double[] nr = ((double[][])this.ratiosMatrix$1.elem)[this.rowIdx$1.elem];
                IntRef index = IntRef.create((int)0);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), row.length - 2).foreach$mVc$sp((Function1)new Serializable(this, nr, index, row){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.buildImputedRatioMatrix.1 $outer;
                    public final double[] nr$1;
                    public final IntRef index$1;
                    public final float[] row$2;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(i + 1), this.row$2.length - 1).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$buildImputedRatioMatrix$1$$anonfun$apply$6 $outer;
                            private final int i$1;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                if (!Predef$.MODULE$.float2Float(this.$outer.row$2[this.i$1]).isNaN() || !Predef$.MODULE$.float2Float(this.$outer.row$2[j]).isNaN()) {
                                    float a = Predef$.MODULE$.float2Float(this.$outer.row$2[j]).isNaN() && this.$outer.fr$profi$util$math$RatioFitting$$anonfun$$anonfun$$$outer().nonNullRatiosCount$1[this.$outer.index$1.elem] != 0 ? this.$outer.fr$profi$util$math$RatioFitting$$anonfun$$anonfun$$$outer().min$1[j] : this.$outer.row$2[j];
                                    float b = Predef$.MODULE$.float2Float(this.$outer.row$2[this.i$1]).isNaN() && this.$outer.fr$profi$util$math$RatioFitting$$anonfun$$anonfun$$$outer().nonNullRatiosCount$1[this.$outer.index$1.elem] != 0 ? this.$outer.fr$profi$util$math$RatioFitting$$anonfun$$anonfun$$$outer().min$1[this.i$1] : this.$outer.row$2[this.i$1];
                                    this.$outer.nr$1[this.$outer.index$1.elem] = a / b;
                                }
                                ++this.$outer.index$1.elem;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.i$1 = i$1;
                            }
                        });
                    }

                    public /* synthetic */ anonfun.buildImputedRatioMatrix.1 fr$profi$util$math$RatioFitting$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.nr$1 = nr$1;
                        this.index$1 = index$1;
                        this.row$2 = row$2;
                    }
                });
                ++this.rowIdx$1.elem;
            }
            {
                this.min$1 = min$1;
                this.ratiosMatrix$1 = ratiosMatrix$1;
                this.nonNullRatiosCount$1 = nonNullRatiosCount$1;
                this.rowIdx$1 = rowIdx$1;
            }
        });
        return (double[][])ratiosMatrix.elem;
    }

    private double[][] buildRatioMatrix(float[][] pep) {
        int length = BoxesRunTime.unboxToInt((Object)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), pep[0].length - 1).view().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        ObjectRef matrix = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Predef$.MODULE$.refArrayOps((Object[])pep).foreach((Function1)new Serializable(length, matrix){
            public static final long serialVersionUID = 0L;
            private final int length$1;
            private final ObjectRef matrix$2;

            public final ArrayBuffer<double[]> apply(float[] row) {
                double[] nr = (double[])Array$.MODULE$.fill(this.length$1, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return Double.NaN;
                    }
                }, ClassTag$.MODULE$.Double());
                IntRef index = IntRef.create((int)0);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), row.length - 2).foreach$mVc$sp((Function1)new Serializable(this, nr, index, row){
                    public static final long serialVersionUID = 0L;
                    public final double[] nr$2;
                    public final IntRef index$2;
                    public final float[] row$3;

                    public final void apply(int i) {
                        this.apply$mcVI$sp(i);
                    }

                    public void apply$mcVI$sp(int i) {
                        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(i + 1), this.row$3.length - 1).foreach$mVc$sp((Function1)new Serializable(this, i){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$buildRatioMatrix$1$$anonfun$apply$7 $outer;
                            private final int i$2;

                            public final void apply(int j) {
                                this.apply$mcVI$sp(j);
                            }

                            public void apply$mcVI$sp(int j) {
                                if (!Predef$.MODULE$.float2Float(this.$outer.row$3[this.i$2]).isNaN() && !Predef$.MODULE$.float2Float(this.$outer.row$3[j]).isNaN() && this.$outer.row$3[this.i$2] * this.$outer.row$3[j] != 0.0f) {
                                    this.$outer.nr$2[this.$outer.index$2.elem] = this.$outer.row$3[j] / this.$outer.row$3[this.i$2];
                                }
                                ++this.$outer.index$2.elem;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.i$2 = i$2;
                            }
                        });
                    }
                    {
                        this.nr$2 = nr$2;
                        this.index$2 = index$2;
                        this.row$3 = row$3;
                    }
                });
                return ((ArrayBuffer)this.matrix$2.elem).$plus$eq((Object)nr);
            }
            {
                this.length$1 = length$1;
                this.matrix$2 = matrix$2;
            }
        });
        return (double[][])((ArrayBuffer)matrix.elem).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    public double[][] buildCoefficientMatrix(float[][] pep, int[] naNRatiosIndexes) {
        ObjectRef matrix = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        IntRef row = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), pep[0].length - 2).foreach$mVc$sp((Function1)new Serializable(pep, naNRatiosIndexes, matrix, row){
            public static final long serialVersionUID = 0L;
            public final float[][] pep$1;
            public final int[] naNRatiosIndexes$1;
            public final ObjectRef matrix$3;
            public final IntRef row$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(i + 1), this.pep$1[0].length - 1).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.buildCoefficientMatrix.1 $outer;
                    private final int i$3;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        BoxedUnit boxedUnit;
                        if (Predef$.MODULE$.intArrayOps(this.$outer.naNRatiosIndexes$1).contains((Object)BoxesRunTime.boxToInteger((int)this.$outer.row$1.elem))) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            double[] nr = (double[])Array$.MODULE$.fill(this.$outer.pep$1[0].length, (Function0)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final double apply() {
                                    return this.apply$mcD$sp();
                                }

                                public double apply$mcD$sp() {
                                    return 0.0;
                                }
                            }, ClassTag$.MODULE$.Double());
                            nr[this.i$3] = -1.0;
                            nr[j] = 1.0;
                            boxedUnit = ((ArrayBuffer)this.$outer.matrix$3.elem).$plus$eq((Object)nr);
                        }
                        ++this.$outer.row$1.elem;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$3 = i$3;
                    }
                });
            }
            {
                this.pep$1 = pep$1;
                this.naNRatiosIndexes$1 = naNRatiosIndexes$1;
                this.matrix$3 = matrix$3;
                this.row$1 = row$1;
            }
        });
        return (double[][])((ArrayBuffer)matrix.elem).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
    }

    /*
     * WARNING - void declaration
     */
    private double[] rowMedian(double[][] values) {
        void var2_2;
        double[] medians = (double[])Array$.MODULE$.fill(values[0].length, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), values[0].length - 1).foreach$mVc$sp((Function1)new Serializable(values, medians){
            public static final long serialVersionUID = 0L;
            private final double[][] values$1;
            private final double[] medians$1;

            public final void apply(int col) {
                this.apply$mcVI$sp(col);
            }

            public void apply$mcVI$sp(int col) {
                double[] colValues = (double[])Array$.MODULE$.fill(this.values$1.length, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return Double.NaN;
                    }
                }, ClassTag$.MODULE$.Double());
                IntRef k = IntRef.create((int)0);
                Predef$.MODULE$.refArrayOps((Object[])this.values$1).foreach((Function1)new Serializable(this, colValues, k, col){
                    public static final long serialVersionUID = 0L;
                    private final double[] colValues$1;
                    private final IntRef k$1;
                    private final int col$1;

                    public final void apply(double[] row) {
                        this.colValues$1[this.k$1.elem] = row[this.col$1];
                        ++this.k$1.elem;
                    }
                    {
                        this.colValues$1 = colValues$1;
                        this.k$1 = k$1;
                        this.col$1 = col$1;
                    }
                });
                this.medians$1[col] = package$.MODULE$.filteredMedian(colValues);
            }
            {
                this.values$1 = values$1;
                this.medians$1 = medians$1;
            }
        });
        return var2_2;
    }

    public float fr$profi$util$math$RatioFitting$$_calcAbundanceSum(float[] abundances) {
        float[] defAbundances = (float[])Predef$.MODULE$.floatArrayOps(abundances).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(float x$14) {
                return this.apply$mcZF$sp(x$14);
            }

            public boolean apply$mcZF$sp(float x$14) {
                return !fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(x$14);
            }
        });
        return defAbundances.length == 0 ? Float.NaN : BoxesRunTime.unboxToFloat((Object)Predef$.MODULE$.floatArrayOps(defAbundances).sum((Numeric)Numeric.FloatIsFractional$.MODULE$));
    }

    private RatioFitting$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
    }
}

