/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.util.random;

import org.apache.commons.math3.stat.StatUtils;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class package$ {
    public static final package$ MODULE$;

    static {
        new package$();
    }

    public String randomString(String chars, int lengthMin, int lengthMax) {
        Predef$.MODULE$.require(chars != null, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "chars is null";
            }
        });
        Predef$.MODULE$.require(!chars.isEmpty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "chars is empty";
            }
        });
        Predef$.MODULE$.require(lengthMin > 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "lengthMin must be strictly positive";
            }
        });
        int length = this.randomInt(lengthMin, lengthMax);
        String newKey = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), length).map((Function1)new Serializable(chars){
            public static final long serialVersionUID = 0L;
            private final String chars$1;

            public final char apply(int x) {
                int index = Random$.MODULE$.nextInt(this.chars$1.length());
                return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.chars$1), index);
            }
            {
                this.chars$1 = chars$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("");
        return newKey;
    }

    public int randomInt(int minInclu, int maxInclu) {
        Predef$.MODULE$.require(minInclu <= maxInclu);
        return minInclu == maxInclu ? minInclu : Random$.MODULE$.nextInt(maxInclu + 1 - minInclu) + minInclu;
    }

    public float randomFloat(float minInclu, float maxExclu) {
        Predef$.MODULE$.require(minInclu <= maxExclu);
        return minInclu == maxExclu ? minInclu : Random$.MODULE$.nextFloat() * (maxExclu - minInclu) + minInclu;
    }

    public double randomDouble(double minInclu, double maxExclu) {
        Predef$.MODULE$.require(minInclu <= maxExclu);
        return minInclu == maxExclu ? minInclu : Random$.MODULE$.nextDouble() * (maxExclu - minInclu) + minInclu;
    }

    public double randomGaussian(double minInclu, double maxInclu, double stddev) {
        double randomValue;
        Predef$.MODULE$.require(minInclu <= maxInclu);
        return minInclu == maxInclu ? minInclu : ((randomValue = Random$.MODULE$.nextGaussian() * stddev + (minInclu + maxInclu) / (double)2) < minInclu ? minInclu : (randomValue > maxInclu ? maxInclu : randomValue));
    }

    public double randomGaussian(double mean, double stdDev) {
        return Random$.MODULE$.nextGaussian() * stdDev + mean;
    }

    public double[] generatePositiveGaussianValues(double expectedMean, double expectedStdDev, float stdDevTol, int nbValues, int maxIterations) {
        Predef$.MODULE$.require(!Predef$.MODULE$.double2Double(expectedMean).isNaN(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "mean is NaN";
            }
        });
        Predef$.MODULE$.require(!fr.profi.util.primitives.package$.MODULE$.isZeroOrNaN(expectedStdDev), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "expectedStdDev equals zero or is NaN";
            }
        });
        Predef$.MODULE$.require(stdDevTol >= 0.0f, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "stdDevTol must be greater than zero";
            }
        });
        Predef$.MODULE$.require(nbValues >= 3, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "can't generate less than 3 values to obtain the expectedStdDev";
            }
        });
        Predef$.MODULE$.require(maxIterations >= 0, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "maxIterations must be greater than zero";
            }
        });
        double stdDevAbsTol = expectedStdDev * (double)stdDevTol;
        ObjectRef values = ObjectRef.create((Object)new ArrayBuffer(nbValues));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nbValues).foreach((Function1)new Serializable(expectedMean, expectedStdDev, values){
            public static final long serialVersionUID = 0L;
            private final double expectedMean$1;
            private final double expectedStdDev$1;
            private final ObjectRef values$1;

            public final ArrayBuffer<Object> apply(int i) {
                return ((ArrayBuffer)this.values$1.elem).$plus$eq((Object)BoxesRunTime.boxToDouble((double)Math.abs(package$.MODULE$.randomGaussian(this.expectedMean$1, this.expectedStdDev$1))));
            }
            {
                this.expectedMean$1 = expectedMean$1;
                this.expectedStdDev$1 = expectedStdDev$1;
                this.values$1 = values$1;
            }
        });
        int centerIdx = nbValues / 2 - 1;
        double curStdDev = Math.sqrt(StatUtils.variance((double[])((double[])((ArrayBuffer)values.elem).toArray(ClassTag$.MODULE$.Double()))));
        double minValue = expectedMean - (double)3 * expectedStdDev;
        double maxValue = expectedMean + (double)3 * expectedStdDev;
        int i = 0;
        while (Math.abs(curStdDev - expectedStdDev) > stdDevAbsTol) {
            ArrayBuffer arrayBuffer;
            if (++i == maxIterations) {
                return null;
            }
            ArrayBuffer sortedValues = (ArrayBuffer)((ArrayBuffer)values.elem).sorted((Ordering)Ordering.Double$.MODULE$);
            if (curStdDev > expectedStdDev) {
                arrayBuffer = (ArrayBuffer)sortedValues.tail();
            } else {
                sortedValues.remove(centerIdx);
                arrayBuffer = sortedValues;
            }
            values.elem = arrayBuffer;
            Predef$.MODULE$.assert(((ArrayBuffer)values.elem).length() == nbValues - 1);
            boolean isValueInAcceptableRange = false;
            while (!isValueInAcceptableRange) {
                double value = Math.abs(this.randomGaussian(expectedMean, expectedStdDev));
                if (!(value > minValue) || !(value < maxValue)) continue;
                ((ArrayBuffer)values.elem).$plus$eq((Object)BoxesRunTime.boxToDouble((double)value));
                isValueInAcceptableRange = true;
            }
            curStdDev = Math.sqrt(StatUtils.variance((double[])((double[])((ArrayBuffer)values.elem).toArray(ClassTag$.MODULE$.Double()))));
        }
        double currentMean = BoxesRunTime.unboxToDouble((Object)((ArrayBuffer)values.elem).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)nbValues;
        ArrayBuffer centeredValues = (ArrayBuffer)((ArrayBuffer)values.elem).map((Function1)new Serializable(expectedMean, currentMean){
            public static final long serialVersionUID = 0L;
            private final double expectedMean$1;
            private final double currentMean$1;

            public final double apply(double x$1) {
                return this.apply$mcDD$sp(x$1);
            }

            public double apply$mcDD$sp(double x$1) {
                return x$1 * this.expectedMean$1 / this.currentMean$1;
            }
            {
                this.expectedMean$1 = expectedMean$1;
                this.currentMean$1 = currentMean$1;
            }
        }, ArrayBuffer$.MODULE$.canBuildFrom());
        return (double[])centeredValues.toArray(ClassTag$.MODULE$.Double());
    }

    public float generatePositiveGaussianValues$default$3() {
        return 0.05f;
    }

    public int generatePositiveGaussianValues$default$4() {
        return 3;
    }

    public int generatePositiveGaussianValues$default$5() {
        return 50000;
    }

    private package$() {
        MODULE$ = this;
    }
}

