/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.solid;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.internal.dbsupport.DbSupport;
import org.flywaydb.core.internal.dbsupport.JdbcTemplate;
import org.flywaydb.core.internal.dbsupport.Schema;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.dbsupport.solid.SolidSchema;
import org.flywaydb.core.internal.dbsupport.solid.SolidSqlStatementBuilder;

public class SolidDbSupport
extends DbSupport {
    public SolidDbSupport(Connection connection) {
        super(new JdbcTemplate(connection, 0));
    }

    @Override
    public Schema getSchema(String name) {
        return new SolidSchema(this.jdbcTemplate, this, name);
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new SolidSqlStatementBuilder();
    }

    @Override
    public String getDbName() {
        return "solid";
    }

    @Override
    protected String doGetCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT CURRENT_SCHEMA()", new String[0]);
    }

    @Override
    protected void doSetCurrentSchema(Schema schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + schema, new Object[0]);
    }

    @Override
    public String getCurrentUserFunction() {
        return "LOGIN_SCHEMA()";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    protected String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }

    @Override
    public boolean catalogIsSchema() {
        return false;
    }
}

