/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.chemistry.algo;

import fr.profi.chemistry.algo.DigestionUtils$;
import fr.profi.chemistry.model.Enzyme;
import fr.profi.chemistry.model.EnzymeCleavage;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class DigestionUtils$ {
    public static final DigestionUtils$ MODULE$;

    static {
        new DigestionUtils$();
    }

    public int getObservablePeptidesCount(String sequence, Enzyme enzyme) {
        int n = 0;
        int[] positions = (int[])Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.intArrayOps(this.getCleavagePositions(sequence, enzyme)).$plus$colon((Object)BoxesRunTime.boxToInteger((int)n), ClassTag$.MODULE$.Int())).$colon$plus((Object)BoxesRunTime.boxToInteger((int)sequence.length()), ClassTag$.MODULE$.Int());
        return Predef$.MODULE$.intArrayOps(positions).sliding(2).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int[] a) {
                return a[1] - a[0];
            }
        }).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int l) {
                return this.apply$mcZI$sp(l);
            }

            public boolean apply$mcZI$sp(int l) {
                return l >= 6 && l <= 30;
            }
        }).length();
    }

    public int[] getCleavagePositions(String sequence, Enzyme enzyme) {
        ObjectRef cleavagePositions = ObjectRef.create((Object)new ArrayBuffer());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), sequence.length() - 2).foreach$mVc$sp((Function1)new Serializable(sequence, enzyme, cleavagePositions){
            public static final long serialVersionUID = 0L;
            public final String sequence$1;
            private final Enzyme enzyme$1;
            public final ObjectRef cleavagePositions$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Predef$.MODULE$.refArrayOps((Object[])this.enzyme$1.enzymeCleavages()).foreach((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getCleavagePositions.1 $outer;
                    private final int i$1;

                    public final Object apply(EnzymeCleavage ec) {
                        BoxedUnit boxedUnit;
                        int restrictionPosition;
                        String string = ec.site();
                        String string2 = "C-term";
                        int n = !(string != null ? !string.equals(string2) : string2 != null) ? 1 : (restrictionPosition = -1);
                        if (new StringOps(Predef$.MODULE$.augmentString(ec.residues())).contains((Object)BoxesRunTime.boxToCharacter((char)this.$outer.sequence$1.charAt(this.i$1))) && !new StringOps(Predef$.MODULE$.augmentString((String)ec.restrictiveResidues().getOrElse((Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "";
                            }
                        }))).contains((Object)BoxesRunTime.boxToCharacter((char)this.$outer.sequence$1.charAt(this.i$1 + restrictionPosition)))) {
                            int shift = restrictionPosition < 0 ? 0 : 1;
                            boxedUnit = ((ArrayBuffer)this.$outer.cleavagePositions$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)(this.i$1 + shift)));
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return boxedUnit;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.i$1 = i$1;
                    }
                });
            }
            {
                this.sequence$1 = sequence$1;
                this.enzyme$1 = enzyme$1;
                this.cleavagePositions$1 = cleavagePositions$1;
            }
        });
        return (int[])((ArrayBuffer)cleavagePositions.elem).toArray(ClassTag$.MODULE$.Int());
    }

    public int countMissedCleavages(String sequence, EnzymeCleavage enzymeCleavage) {
        ObjectRef missedCleavages = ObjectRef.create((Object)new ArrayBuffer());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), sequence.length() - 1).foreach((Function1)new Serializable(sequence, enzymeCleavage, missedCleavages){
            public static final long serialVersionUID = 0L;
            private final String sequence$2;
            private final EnzymeCleavage enzymeCleavage$1;
            private final ObjectRef missedCleavages$1;

            /*
             * Enabled aggressive block sorting
             */
            public final Object apply(int i) {
                BoxedUnit boxedUnit;
                String string = this.enzymeCleavage$1.site();
                String string2 = "C-term";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (new StringOps(Predef$.MODULE$.augmentString(this.enzymeCleavage$1.residues())).contains((Object)BoxesRunTime.boxToCharacter((char)this.sequence$2.charAt(i))) && i + 1 < this.sequence$2.length() && !new StringOps(Predef$.MODULE$.augmentString((String)this.enzymeCleavage$1.restrictiveResidues().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }))).contains((Object)BoxesRunTime.boxToCharacter((char)this.sequence$2.charAt(i + 1)))) {
                        boxedUnit = ((ArrayBuffer)this.missedCleavages$1.elem).$plus$eq((Object)new StringBuilder().append(this.sequence$2.charAt(i)).append((Object)"(").append((Object)BoxesRunTime.boxToInteger((int)(i + 1))).append((Object)")").toString());
                        return boxedUnit;
                    }
                }
                String string3 = this.enzymeCleavage$1.site();
                String string4 = "N-term";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    if (i != 0 && new StringOps(Predef$.MODULE$.augmentString(this.enzymeCleavage$1.residues())).contains((Object)BoxesRunTime.boxToCharacter((char)this.sequence$2.charAt(i))) && (i + 1 >= this.sequence$2.length() || !new StringOps(Predef$.MODULE$.augmentString((String)this.enzymeCleavage$1.restrictiveResidues().getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }))).contains((Object)BoxesRunTime.boxToCharacter((char)this.sequence$2.charAt(i + 1))))) {
                        boxedUnit = ((ArrayBuffer)this.missedCleavages$1.elem).$plus$eq((Object)new StringBuilder().append(this.sequence$2.charAt(i)).append((Object)"(").append((Object)BoxesRunTime.boxToInteger((int)(i + 1))).append((Object)")").toString());
                        return boxedUnit;
                    }
                }
                boxedUnit = BoxedUnit.UNIT;
                return boxedUnit;
            }
            {
                this.sequence$2 = sequence$2;
                this.enzymeCleavage$1 = enzymeCleavage$1;
                this.missedCleavages$1 = missedCleavages$1;
            }
        });
        return ((ArrayBuffer)missedCleavages.elem).size();
    }

    public EnzymeCleavage[] getEnzymesCleavages(String sequence, Option<Object> residueBefore, Option<Object> residueAfter, Enzyme enzyme) {
        HashMap enzymeCleavages = new HashMap();
        Predef$.MODULE$.refArrayOps((Object[])enzyme.enzymeCleavages()).foreach((Function1)new Serializable(sequence, residueBefore, residueAfter, enzymeCleavages){
            public static final long serialVersionUID = 0L;
            private final String sequence$3;
            private final Option residueBefore$1;
            private final Option residueAfter$1;
            private final HashMap enzymeCleavages$1;

            public final Option<Object> apply(EnzymeCleavage ec) {
                int nbIndications = 0;
                String string = ec.site();
                String string2 = "C-term";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    if (new StringOps(Predef$.MODULE$.augmentString(ec.residues())).contains(new StringOps(Predef$.MODULE$.augmentString(this.sequence$3)).last())) {
                        ++nbIndications;
                    }
                    if (this.residueBefore$1.isDefined() && new StringOps(Predef$.MODULE$.augmentString(ec.residues())).contains(this.residueBefore$1.get())) {
                        ++nbIndications;
                    }
                } else {
                    if (new StringOps(Predef$.MODULE$.augmentString(ec.residues())).contains(new StringOps(Predef$.MODULE$.augmentString(this.sequence$3)).head())) {
                        ++nbIndications;
                    }
                    if (this.residueAfter$1.isDefined() && new StringOps(Predef$.MODULE$.augmentString(ec.residues())).contains(this.residueAfter$1.get())) {
                        ++nbIndications;
                    }
                }
                return this.enzymeCleavages$1.put((Object)ec, (Object)BoxesRunTime.boxToInteger((int)nbIndications));
            }
            {
                this.sequence$3 = sequence$3;
                this.residueBefore$1 = residueBefore$1;
                this.residueAfter$1 = residueAfter$1;
                this.enzymeCleavages$1 = enzymeCleavages$1;
            }
        });
        int maxIndications = ((Tuple2)enzymeCleavages.maxBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<EnzymeCleavage, Object> x$2) {
                return x$2._2$mcI$sp();
            }
        }, (Ordering)Ordering.Int$.MODULE$))._2$mcI$sp();
        return (EnzymeCleavage[])((MapLike)enzymeCleavages.filter((Function1)new Serializable(maxIndications){
            public static final long serialVersionUID = 0L;
            private final int maxIndications$1;

            public final boolean apply(Tuple2<EnzymeCleavage, Object> x$3) {
                return x$3._2$mcI$sp() == this.maxIndications$1;
            }
            {
                this.maxIndications$1 = maxIndications$1;
            }
        })).keys().toArray(ClassTag$.MODULE$.apply(EnzymeCleavage.class));
    }

    private DigestionUtils$() {
        MODULE$ = this;
    }
}

