/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.chemistry.model;

import fr.profi.chemistry.model.IMolecularEntity;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;

public final class AbundanceMapOps$ {
    public static final AbundanceMapOps$ MODULE$;

    static {
        new AbundanceMapOps$();
    }

    public <M extends IMolecularEntity> float sumAbundances(HashMap<M, Object> abundanceMap) {
        return BoxesRunTime.unboxToFloat((Object)abundanceMap.foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(float sum, Tuple2<M, Object> ab) {
                return sum + BoxesRunTime.unboxToFloat((Object)ab._2());
            }
        }));
    }

    public <M extends IMolecularEntity> float sumAbsoluteAbundances(HashMap<M, Object> abundanceMap) {
        return BoxesRunTime.unboxToFloat((Object)abundanceMap.foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final float apply(float sum, Tuple2<M, Object> ab) {
                return sum + package$.MODULE$.abs(BoxesRunTime.unboxToFloat((Object)ab._2()));
            }
        }));
    }

    public <M extends IMolecularEntity> double calcMass(HashMap<M, Object> abundanceMap, Function1<IMolecularEntity, Object> massExtractor) {
        DoubleRef mass = DoubleRef.create((double)0.0);
        abundanceMap.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<M, Object> check$ifrefutable$1) {
                Tuple2<M, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(massExtractor, mass){
            public static final long serialVersionUID = 0L;
            private final Function1 massExtractor$1;
            private final DoubleRef mass$1;

            public final void apply(Tuple2<M, Object> x$1) {
                Tuple2<M, Object> tuple2 = x$1;
                if (tuple2 != null) {
                    IMolecularEntity entity = (IMolecularEntity)tuple2._1();
                    float entityAb = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    double entityMass = BoxesRunTime.unboxToDouble((Object)this.massExtractor$1.apply((Object)entity));
                    this.mass$1.elem += (double)entityAb * entityMass;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.massExtractor$1 = massExtractor$1;
                this.mass$1 = mass$1;
            }
        });
        return mass.elem;
    }

    public <M extends IMolecularEntity> double calcMonoMass(HashMap<M, Object> abundanceMap) {
        return this.calcMass(abundanceMap, (Function1<IMolecularEntity, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(IMolecularEntity entity) {
                return entity.monoMass();
            }
        });
    }

    public <M extends IMolecularEntity> double calcAverageMass(HashMap<M, Object> abundanceMap) {
        return this.calcMass(abundanceMap, (Function1<IMolecularEntity, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(IMolecularEntity entity) {
                return entity.averageMass();
            }
        });
    }

    public <M extends IMolecularEntity> void multiplyBy(HashMap<M, Object> abundanceMap, float number) {
        AbundanceMapOps$ abundanceMapOps$ = this;
        synchronized (abundanceMapOps$) {
            abundanceMap.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<M, Object> check$ifrefutable$2) {
                    Tuple2<M, Object> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(abundanceMap, number){
                public static final long serialVersionUID = 0L;
                private final HashMap abundanceMap$2;
                private final float number$1;

                public final void apply(Tuple2<M, Object> x$2) {
                    Tuple2<M, Object> tuple2 = x$2;
                    if (tuple2 != null) {
                        IMolecularEntity key = (IMolecularEntity)tuple2._1();
                        this.abundanceMap$2.update((Object)key, (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)this.abundanceMap$2.apply((Object)key)) * this.number$1)));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.abundanceMap$2 = abundanceMap$2;
                    this.number$1 = number$1;
                }
            });
            return;
        }
    }

    public synchronized <M extends IMolecularEntity> void divideBy(HashMap<M, Object> abundanceMap, float number) {
        abundanceMap.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<M, Object> check$ifrefutable$3) {
                Tuple2<M, Object> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(abundanceMap, number){
            public static final long serialVersionUID = 0L;
            private final HashMap abundanceMap$3;
            private final float number$2;

            public final void apply(Tuple2<M, Object> x$3) {
                Tuple2<M, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    IMolecularEntity key = (IMolecularEntity)tuple2._1();
                    this.abundanceMap$3.update((Object)key, (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)this.abundanceMap$3.apply((Object)key)) / this.number$2)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.abundanceMap$3 = abundanceMap$3;
                this.number$2 = number$2;
            }
        });
    }

    public synchronized <M extends IMolecularEntity> void addAbundanceMap(HashMap<M, Object> abundanceMap, Map<M, Object> otherAbundanceMap) {
        otherAbundanceMap.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<M, Object> check$ifrefutable$4) {
                Tuple2<M, Object> tuple2 = check$ifrefutable$4;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(abundanceMap){
            public static final long serialVersionUID = 0L;
            private final HashMap abundanceMap$1;

            public final void apply(Tuple2<M, Object> x$4) {
                Tuple2<M, Object> tuple2 = x$4;
                if (tuple2 != null) {
                    IMolecularEntity key = (IMolecularEntity)tuple2._1();
                    float value = BoxesRunTime.unboxToFloat((Object)tuple2._2());
                    this.abundanceMap$1.getOrElseUpdate((Object)key, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final float apply() {
                            return this.apply$mcF$sp();
                        }

                        public float apply$mcF$sp() {
                            return 0.0f;
                        }
                    });
                    this.abundanceMap$1.update((Object)key, (Object)BoxesRunTime.boxToFloat((float)(BoxesRunTime.unboxToFloat((Object)this.abundanceMap$1.apply((Object)key)) + value)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.abundanceMap$1 = abundanceMap$1;
            }
        });
    }

    public <M extends IMolecularEntity> String stringifyToFormula(HashMap<M, Object> abundanceMap) {
        List sortedAtoms = (List)abundanceMap.keys().toList().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(M x$5) {
                return x$5.symbol();
            }
        }, (Ordering)Ordering.String$.MODULE$);
        List strings = (List)sortedAtoms.flatMap((Function1)new Serializable(abundanceMap){
            public static final long serialVersionUID = 0L;
            private final HashMap abundanceMap$4;

            public final Iterable<String> apply(M entity) {
                return Option$.MODULE$.option2Iterable(this.abundanceMap$4.get(entity).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(float x$6) {
                        return this.apply$mcIF$sp(x$6);
                    }

                    public int apply$mcIF$sp(float x$6) {
                        return (int)x$6;
                    }
                }).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(int abundance) {
                        return this.apply$mcZI$sp(abundance);
                    }

                    public boolean apply$mcZI$sp(int abundance) {
                        return abundance != 0;
                    }
                }).map((Function1)new Serializable(this, (IMolecularEntity)entity){
                    public static final long serialVersionUID = 0L;
                    private final IMolecularEntity entity$1;

                    public final String apply(int abundance) {
                        Object object;
                        StringBuilder sb = new StringBuilder();
                        if (abundance != 0) {
                            sb.append(this.entity$1.symbol());
                            object = abundance != 1 ? sb.append("(").append(abundance).append(")") : BoxedUnit.UNIT;
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return sb.toString();
                    }
                    {
                        this.entity$1 = entity$1;
                    }
                }));
            }
            {
                this.abundanceMap$4 = abundanceMap$4;
            }
        }, List$.MODULE$.canBuildFrom());
        return strings.mkString(" ");
    }

    private AbundanceMapOps$() {
        MODULE$ = this;
    }
}

