/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.cache;

import com.almworks.sqlite4java.SQLiteConnection;
import com.almworks.sqlite4java.SQLiteException;
import fr.profi.mzdb.AbstractMzDbReader;
import fr.profi.mzdb.db.model.params.ParamTree;
import fr.profi.mzdb.db.model.params.param.CVParam;
import fr.profi.mzdb.db.table.DataEncodingTable;
import fr.profi.mzdb.db.table.SpectrumTable;
import fr.profi.mzdb.io.reader.MzDbReaderQueries;
import fr.profi.mzdb.io.reader.cache.MzDbEntityCacheContainer;
import fr.profi.mzdb.io.reader.table.ParamTreeParser;
import fr.profi.mzdb.model.DataEncoding;
import fr.profi.mzdb.model.DataMode;
import fr.profi.mzdb.model.PeakEncoding;
import fr.profi.mzdb.util.sqlite.ISQLiteRecordExtraction;
import fr.profi.mzdb.util.sqlite.SQLiteQuery;
import fr.profi.mzdb.util.sqlite.SQLiteRecord;
import fr.profi.mzdb.util.sqlite.SQLiteRecordIterator;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDataEncodingReader
extends MzDbEntityCacheContainer {
    private static String _dataEncodingQueryStr = "SELECT * FROM data_encoding";
    private ISQLiteRecordExtraction<DataEncoding> _dataEncodingExtractor;

    public AbstractDataEncodingReader(AbstractMzDbReader mzDbReader) throws SQLiteException {
        super(mzDbReader);
    }

    private ISQLiteRecordExtraction<DataEncoding> _getDataEncodingExtractor(SQLiteConnection connection) throws SQLiteException {
        if (this._dataEncodingExtractor != null) {
            return this._dataEncodingExtractor;
        }
        String modelVersion = MzDbReaderQueries.getModelVersion(connection);
        this._dataEncodingExtractor = modelVersion.compareTo("0.6") > 0 ? new ISQLiteRecordExtraction<DataEncoding>(){

            @Override
            public DataEncoding extract(SQLiteRecord record) throws SQLiteException {
                int id = record.columnInt(DataEncodingTable.ID);
                String dmAsStr = record.columnString(DataEncodingTable.MODE);
                String compression = record.columnString(DataEncodingTable.COMPRESSION);
                String byteOrderAsStr = record.columnString(DataEncodingTable.BYTE_ORDER);
                DataMode dm = dmAsStr.equalsIgnoreCase("FITTED") ? DataMode.FITTED : (dmAsStr.equalsIgnoreCase("PROFILE") ? DataMode.PROFILE : DataMode.CENTROID);
                ByteOrder bo = byteOrderAsStr.equalsIgnoreCase("big_endian") ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                int mzPrecision = record.columnInt(DataEncodingTable.MZ_PRECISION);
                int intPrecision = record.columnInt(DataEncodingTable.INTENSITY_PRECISION);
                PeakEncoding peakEnc = null;
                peakEnc = mzPrecision == 32 ? PeakEncoding.LOW_RES_PEAK : (intPrecision == 32 ? PeakEncoding.HIGH_RES_PEAK : PeakEncoding.NO_LOSS_PEAK);
                return new DataEncoding(id, dm, peakEnc, compression, bo);
            }
        } : new ISQLiteRecordExtraction<DataEncoding>(){

            @Override
            public DataEncoding extract(SQLiteRecord record) throws SQLiteException {
                int id = record.columnInt(DataEncodingTable.ID);
                String dmAsStr = record.columnString(DataEncodingTable.MODE);
                String compression = record.columnString(DataEncodingTable.COMPRESSION);
                String byteOrderAsStr = record.columnString(DataEncodingTable.BYTE_ORDER);
                DataMode dm = dmAsStr.equalsIgnoreCase("FITTED") ? DataMode.FITTED : (dmAsStr.equalsIgnoreCase("PROFILE") ? DataMode.PROFILE : DataMode.CENTROID);
                ByteOrder bo = byteOrderAsStr.equalsIgnoreCase("big_endian") ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                String paramTreeAsStr = record.columnString(SpectrumTable.PARAM_TREE);
                ParamTree paramTree = ParamTreeParser.parseParamTree(paramTreeAsStr);
                List<CVParam> cvParams = paramTree.getCVParams();
                CVParam mzEncoding = cvParams.get(0);
                CVParam intEncoding = cvParams.get(1);
                PeakEncoding peakEnc = null;
                peakEnc = mzEncoding.getValue().equals("32") ? PeakEncoding.LOW_RES_PEAK : (intEncoding.getValue().equals("32") ? PeakEncoding.HIGH_RES_PEAK : PeakEncoding.NO_LOSS_PEAK);
                return new DataEncoding(id, dm, peakEnc, compression, bo);
            }
        };
        return this._dataEncodingExtractor;
    }

    protected DataEncoding getDataEncoding(int dataEncodingId, SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null) {
            return this.getDataEncodingById(connection).get(dataEncodingId);
        }
        String queryStr = _dataEncodingQueryStr + " WHERE id = ?";
        return new SQLiteQuery(connection, queryStr).bind(1, dataEncodingId).extractRecord(this._getDataEncodingExtractor(connection));
    }

    protected DataEncoding[] getDataEncodings(SQLiteConnection connection) throws SQLiteException {
        List<DataEncoding> dataEncodings = new SQLiteQuery(connection, _dataEncodingQueryStr).extractRecordList(this._getDataEncodingExtractor(connection));
        return dataEncodings.toArray(new DataEncoding[dataEncodings.size()]);
    }

    protected Map<Integer, DataEncoding> getDataEncodingById(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().dataEncodingById != null) {
            return this.getEntityCache().dataEncodingById;
        }
        DataEncoding[] dataEncodings = this.getDataEncodings(connection);
        HashMap<Integer, DataEncoding> dataEncodingById = new HashMap<Integer, DataEncoding>(dataEncodings.length);
        for (DataEncoding dataEncoding : dataEncodings) {
            dataEncodingById.put(dataEncoding.getId(), dataEncoding);
        }
        if (this.getEntityCache() != null) {
            this.getEntityCache().dataEncodingById = dataEncodingById;
        }
        return dataEncodingById;
    }

    public Map<Long, DataEncoding> getDataEncodingBySpectrumId(SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null && this.getEntityCache().dataEncodingBySpectrumId != null) {
            return this.getEntityCache().dataEncodingBySpectrumId;
        }
        Map<Integer, DataEncoding> dataEncodingById = this.getDataEncodingById(connection);
        String queryStr = "SELECT id, data_encoding_id FROM spectrum";
        SQLiteRecordIterator records = new SQLiteQuery(connection, queryStr).getRecordIterator();
        HashMap<Long, DataEncoding> dataEncodingBySpectrumId = new HashMap<Long, DataEncoding>();
        while (records.hasNext()) {
            SQLiteRecord record = records.next();
            long spectrumId = record.columnLong(SpectrumTable.ID);
            int spectrumDataEncodingId = record.columnInt(SpectrumTable.DATA_ENCODING_ID);
            DataEncoding dataEnc = dataEncodingById.get(spectrumDataEncodingId);
            dataEncodingBySpectrumId.put(spectrumId, dataEnc);
        }
        if (this.getEntityCache() != null) {
            this.getEntityCache().dataEncodingBySpectrumId = dataEncodingBySpectrumId;
        }
        return dataEncodingBySpectrumId;
    }

    protected DataEncoding getSpectrumDataEncoding(long spectrumId, SQLiteConnection connection) throws SQLiteException {
        if (this.getEntityCache() != null) {
            return this.getDataEncodingBySpectrumId(connection).get(spectrumId);
        }
        String queryStr = "SELECT data_encoding_id FROM spectrum WHERE id = " + spectrumId;
        return this.getDataEncoding(new SQLiteQuery(connection, queryStr).extractSingleInt(), connection);
    }
}

