/*
 * Decompiled with CFR 0.152.
 */
package fr.profi.mzdb.io.reader.iterator;

import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteStatement;
import fr.profi.mzdb.io.reader.iterator.IStatementExtractor;
import java.io.StreamCorruptedException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatementIterator<E>
implements Iterator<E>,
IStatementExtractor<E> {
    protected final Logger logger = LoggerFactory.getLogger(AbstractStatementIterator.class);
    protected final SQLiteStatement statement;
    protected boolean isStatementClosed = false;
    protected E nextElem = null;

    public AbstractStatementIterator(SQLiteStatement stmt) throws SQLiteException, StreamCorruptedException {
        this.statement = stmt;
        this.nextElem = null;
    }

    public void closeStatement() {
        this.statement.dispose();
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.statement.step()) {
                return true;
            }
            this.closeStatement();
            return false;
        }
        catch (SQLiteException e) {
            this.logger.error("SQLiteException has been caught: ", (Throwable)e);
            return false;
        }
    }

    @Override
    public E next() {
        try {
            this.nextElem = this.extractObject(this.statement);
            return this.nextElem;
        }
        catch (Exception e) {
            this.logger.error("Exception has been caught: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported Operation");
    }
}

