/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.msfiles.ConversionSettings;
import fr.proline.studio.msfiles.MsListener;
import fr.proline.studio.msfiles.MsListenerConverterParameter;
import fr.proline.studio.msfiles.MsListenerDownloadParameter;
import fr.proline.studio.msfiles.MsListenerEntryUpdateParameter;
import fr.proline.studio.msfiles.MsListenerParameter;
import fr.proline.studio.msfiles.MzdbUploadSettings;
import fr.proline.studio.msfiles.MzdbUploader;
import fr.proline.studio.msfiles.RawConverter;
import fr.proline.studio.rsmexplorer.MzdbFilesTopPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.swing.tree.TreePath;

public class ConvertionUploadBatch
implements Runnable,
MsListener {
    private ThreadPoolExecutor m_conversionExecutor;
    private ThreadPoolExecutor m_uploadExecutor;
    private HashMap<File, ConversionSettings> m_conversions;
    private TreePath m_pathToExpand;

    public ConvertionUploadBatch(HashMap<File, ConversionSettings> conversions) {
        this.m_conversions = conversions;
        this.m_conversionExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
        this.m_uploadExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(5);
    }

    public ConvertionUploadBatch(HashMap<File, ConversionSettings> conversions, TreePath pathToExpand) {
        this(conversions);
        this.m_pathToExpand = pathToExpand;
    }

    private void upload(File f, MzdbUploadSettings uploadSettings) {
        if (f.getAbsolutePath().toLowerCase().endsWith(".mzdb")) {
            if (uploadSettings.getMountingPointPath() == null) {
                return;
            }
            MzdbUploader uploader = new MzdbUploader(f, uploadSettings);
            uploader.addMsListener(this);
            this.m_uploadExecutor.execute(uploader);
        }
    }

    private void convert(File f, ConversionSettings conversionSettings) {
        if (f.getAbsolutePath().toLowerCase().endsWith(".raw") || f.getAbsolutePath().toLowerCase().endsWith(".wiff")) {
            RawConverter converter = new RawConverter(f, conversionSettings);
            converter.addMsListener(this);
            this.m_conversionExecutor.execute(converter);
        }
    }

    @Override
    public void run() {
        HashSet<String> m_parentDirectories = new HashSet<String>();
        if (this.m_pathToExpand == null) {
            Iterator<Map.Entry<File, ConversionSettings>> it = this.m_conversions.entrySet().iterator();
            String mountingPointPath = null;
            while (it.hasNext()) {
                Map.Entry<File, ConversionSettings> pair = it.next();
                ConversionSettings settings = pair.getValue();
                if (settings.getUploadSettings() != null && !settings.getUploadSettings().getDestination().equalsIgnoreCase("")) {
                    if (settings.getUploadSettings().getDestination().startsWith(File.separator)) {
                        m_parentDirectories.add(settings.getUploadSettings().getDestination().substring(1));
                    } else {
                        m_parentDirectories.add(settings.getUploadSettings().getDestination());
                    }
                }
                if (settings.getUploadSettings() == null || mountingPointPath != null) continue;
                mountingPointPath = settings.getUploadSettings().getMountingPointPath();
            }
            if (mountingPointPath != null) {
                MzdbFilesTopPanel.getExplorer().getTreeFileChooserPanel().expandMultipleTreePath(m_parentDirectories, mountingPointPath);
            }
        } else {
            MzdbFilesTopPanel.getExplorer().getTreeFileChooserPanel().expandTreePath(this.m_pathToExpand);
        }
        MzdbFilesTopPanel.getExplorer().getTreeFileChooserPanel().updateTree();
        for (Map.Entry<File, ConversionSettings> pair : this.m_conversions.entrySet()) {
            this.convert(pair.getKey(), pair.getValue());
        }
    }

    @Override
    public void conversionPerformed(ArrayList<MsListenerConverterParameter> list) {
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                MsListenerConverterParameter p = list.get(i);
                if (!p.wasSuccessful() || p.getConversionSettings() == null || p.getConversionSettings().getUploadSettings() == null) continue;
                MzdbFilesTopPanel.getExplorer().getLocalFileSystemView().updateTree();
                this.upload(p.getFile(), p.getConversionSettings().getUploadSettings());
            }
        }
    }

    @Override
    public void uploadPerformed(ArrayList<MsListenerParameter> list) {
        if (list != null && !list.isEmpty()) {
            boolean success = false;
            for (MsListenerParameter parameter : list) {
                if (!parameter.wasSuccessful()) continue;
                success = true;
                break;
            }
            if (success) {
                MzdbFilesTopPanel.getExplorer().getTreeFileChooserPanel().updateTree();
            }
        }
    }

    @Override
    public void downloadPerformed(ArrayList<MsListenerDownloadParameter> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void exportPerformed(ArrayList<MsListenerParameter> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void verificationPerformed(ArrayList<MsListenerParameter> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void entryStateUpdated(ArrayList<MsListenerEntryUpdateParameter> list) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

