/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.msfiles.MsListener;
import fr.proline.studio.msfiles.MsListenerParameter;
import fr.proline.studio.msfiles.MzdbEncodingVerificationTask;
import java.io.File;
import java.util.ArrayList;

public class MzdbEncodingVerificationBatch
implements Runnable {
    private final ArrayList<File> m_files;
    private ArrayList<MsListenerParameter> m_list;
    private MsListener m_listener;

    public MzdbEncodingVerificationBatch(ArrayList<File> files) {
        this.m_files = files;
        this.m_list = new ArrayList();
    }

    public void addMsListener(MsListener listener) {
        this.m_listener = listener;
    }

    @Override
    public void run() {
        for (int i = 0; i < this.m_files.size(); ++i) {
            this.verifyEncoding(this.m_files.get(i));
        }
    }

    private void verifyEncoding(final File f) {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (finished && MzdbEncodingVerificationBatch.this.m_listener != null) {
                    MzdbEncodingVerificationBatch.this.m_list.add(new MsListenerParameter(f, success));
                    if (MzdbEncodingVerificationBatch.this.m_list.size() == MzdbEncodingVerificationBatch.this.m_files.size()) {
                        MzdbEncodingVerificationBatch.this.m_listener.verificationPerformed(MzdbEncodingVerificationBatch.this.m_list);
                    }
                }
            }
        };
        MzdbEncodingVerificationTask encodingVerificationTask = new MzdbEncodingVerificationTask(callback, f);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)encodingVerificationTask);
    }
}

