/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.FileUploadTask;
import fr.proline.studio.msfiles.FileUtility;
import fr.proline.studio.msfiles.MsListener;
import fr.proline.studio.msfiles.MsListenerParameter;
import fr.proline.studio.msfiles.MzdbEncodingVerificationTask;
import fr.proline.studio.msfiles.MzdbIntegrityVerificationTask;
import fr.proline.studio.msfiles.MzdbUploadSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MzdbUploader
implements Runnable {
    private final File m_file;
    private MsListener m_msListener;
    private final MzdbUploadSettings m_uploadSettings;

    public MzdbUploader(File file, MzdbUploadSettings uploadSettings) {
        this.m_file = file;
        this.m_uploadSettings = uploadSettings;
    }

    public void addMsListener(MsListener listener) {
        this.m_msListener = listener;
    }

    @Override
    public void run() {
        this.verifyFinalization();
        this.verifyEncoding();
    }

    public File getFile() {
        return this.m_file;
    }

    private void verifyIntegrityAndUpload() {
        AbstractDatabaseCallback verificationCallback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return false;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    String[] result = new String[1];
                    AbstractJMSCallback callback = new AbstractJMSCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success) {
                            if (success) {
                                if (MzdbUploader.this.m_msListener != null && MzdbUploader.this.m_file.exists()) {
                                    ArrayList<MsListenerParameter> list = new ArrayList<MsListenerParameter>();
                                    list.add(new MsListenerParameter(MzdbUploader.this.m_file, true));
                                    MzdbUploader.this.m_msListener.uploadPerformed(list);
                                }
                                if (MzdbUploader.this.m_uploadSettings.getDeleteMzdb()) {
                                    while (!MzdbUploader.this.m_file.canWrite() && !MzdbUploader.this.m_file.exists()) {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException ex) {
                                            Logger.getLogger(MzdbUploader.class.getName()).log(Level.SEVERE, null, ex);
                                        }
                                    }
                                    MzdbUploader.this.m_file.setWritable(true);
                                    try {
                                        Thread.sleep(5000L);
                                    }
                                    catch (InterruptedException ex) {
                                        Logger.getLogger(MzdbUploader.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                    FileUtility.deleteFile(MzdbUploader.this.m_file);
                                }
                            } else if (MzdbUploader.this.m_msListener != null) {
                                ArrayList<MsListenerParameter> list = new ArrayList<MsListenerParameter>();
                                list.add(new MsListenerParameter(MzdbUploader.this.m_file, false));
                                MzdbUploader.this.m_msListener.uploadPerformed(list);
                            }
                        }
                    };
                    FileUploadTask task = new FileUploadTask(callback, MzdbUploader.this.m_file.getAbsolutePath(), result);
                    task.initUploadMZDB(MzdbUploader.this.m_uploadSettings.getMountingPointPath(), MzdbUploader.this.m_uploadSettings.getDestination());
                    AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
                }
            }
        };
        MzdbIntegrityVerificationTask verificationTask = new MzdbIntegrityVerificationTask(verificationCallback, this.m_file);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)verificationTask);
    }

    private void verifyFinalization() {
        try {
            while (!FileUtility.isCompletelyWritten(this.m_file)) {
                Thread.sleep(10000L);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(MzdbUploader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void verifyEncoding() {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    MzdbUploader.this.verifyIntegrityAndUpload();
                }
            }
        };
        MzdbEncodingVerificationTask encodingVerificationTask = new MzdbEncodingVerificationTask(callback, this.m_file);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)encodingVerificationTask);
    }
}

