/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.studio.msfiles.WorkingSetEntry;
import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class WorkingSet
implements Serializable {
    private String m_name;
    private String m_description;
    private JSONArray m_entries;
    private HashSet<String> m_index;

    public WorkingSet(String name, String description, JSONArray entries) {
        this.m_name = name;
        this.m_description = description;
        this.m_entries = entries;
        this.m_index = new HashSet();
        this.updateIndex();
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public JSONArray getEntries() {
        return this.m_entries;
    }

    public String toString() {
        return this.m_name;
    }

    public boolean removeEntry(String path) {
        for (int i = 0; i < this.m_entries.size(); ++i) {
            JSONObject innerObj = (JSONObject)this.m_entries.get(i);
            String currentPath = (String)innerObj.get((Object)"path");
            if (!path.equalsIgnoreCase(currentPath)) continue;
            this.m_entries.remove(i);
            this.m_index.remove(path);
            return true;
        }
        return false;
    }

    public boolean addEntry(String path, WorkingSetEntry.Location location) {
        if (!this.m_index.contains(path)) {
            JSONObject newJSONObject = new JSONObject();
            String delimiter = path.contains(File.separator) ? File.separator : "/";
            String filename = path.substring(path.lastIndexOf(delimiter) + 1);
            newJSONObject.put((Object)"filename", (Object)filename);
            newJSONObject.put((Object)"location", (Object)location.toString().toLowerCase());
            newJSONObject.put((Object)"path", (Object)path);
            this.m_index.add(path);
            this.m_entries.add((Object)newJSONObject);
            return true;
        }
        return false;
    }

    public boolean addEntry(JSONObject object) {
        String path = (String)object.get((Object)"path");
        if (!this.m_index.contains(path)) {
            this.m_index.add(path);
            this.m_entries.add((Object)object);
            return true;
        }
        return false;
    }

    private void updateIndex() {
        for (int i = 0; i < this.m_entries.size(); ++i) {
            JSONObject workingSetEntry = (JSONObject)this.m_entries.get(i);
            String path = (String)workingSetEntry.get((Object)"path");
            this.m_index.add(path);
        }
    }
}

