/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.msfiles;

import fr.proline.mzscope.utils.IPopupMenuDelegate;
import fr.proline.studio.msfiles.AddWorkingSetDialog;
import fr.proline.studio.msfiles.AddlWorkingSetEntryDialog;
import fr.proline.studio.msfiles.MsListener;
import fr.proline.studio.msfiles.MsListenerConverterParameter;
import fr.proline.studio.msfiles.MsListenerDownloadParameter;
import fr.proline.studio.msfiles.MsListenerEntryUpdateParameter;
import fr.proline.studio.msfiles.MsListenerParameter;
import fr.proline.studio.msfiles.MzdbDownloadBatch;
import fr.proline.studio.msfiles.MzdbEncodingVerificationBatch;
import fr.proline.studio.msfiles.WorkingSet;
import fr.proline.studio.msfiles.WorkingSetEntriesTransferHandler;
import fr.proline.studio.msfiles.WorkingSetEntry;
import fr.proline.studio.msfiles.WorkingSetModel;
import fr.proline.studio.msfiles.WorkingSetRoot;
import fr.proline.studio.msfiles.WorkingSetUtil;
import fr.proline.studio.pattern.MzScopeWindowBoxManager;
import fr.proline.studio.rsmexplorer.gui.MzScope;
import fr.proline.studio.rsmexplorer.gui.TreeUtils;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.json.simple.JSONArray;

public class WorkingSetView
extends JPanel
implements IPopupMenuDelegate {
    private static WorkingSetView m_singleton = null;
    private WorkingSetModel m_workingSetModel;
    private JTree m_tree;
    private JMenuItem m_addWorkingSet;
    private JMenuItem m_renameWorkingSet;
    private JMenuItem m_changeDescriptionAtWorkingSet;
    private JMenuItem m_removeWorkingSet;
    private JMenuItem m_addWorkingSetEntry;
    private JMenuItem m_removeWorkingSetEntry;
    private JMenuItem m_viewMzdb;
    private JMenuItem m_detectPeakels;
    private JPopupMenu m_popupMenu;
    private ActionListener m_viewMzdbAction;
    private WorkingSetRoot m_root;
    private ArrayList<WorkingSet> m_selectedWorkingSets;
    private ArrayList<WorkingSetEntry> m_selectedWorkingSetEntries;
    private ArrayList<WorkingSetEntry> m_existingSelectedWorkingSetEntries;
    private WorkingSetRoot m_selectedRoot;
    private HashSet<String> m_downloadIndex;

    public static WorkingSetView getWorkingSetView() {
        if (m_singleton == null) {
            m_singleton = new WorkingSetView();
        }
        return m_singleton;
    }

    private WorkingSetView() {
        this.initComponents();
    }

    private void initComponents() {
        this.m_selectedWorkingSets = new ArrayList();
        this.m_selectedWorkingSetEntries = new ArrayList();
        this.m_existingSelectedWorkingSetEntries = new ArrayList();
        this.m_selectedRoot = null;
        this.m_downloadIndex = new HashSet();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Working Sets"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.m_root = new WorkingSetRoot((JSONArray)WorkingSetUtil.readJSON().get((Object)"working_sets"));
        this.m_workingSetModel = new WorkingSetModel(this.m_root);
        this.m_tree = new JTree(this.m_workingSetModel);
        this.m_tree.setTransferHandler(new WorkingSetEntriesTransferHandler());
        this.m_tree.setDragEnabled(true);
        this.m_tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean isLeaf, int row, boolean focused) {
                Object userObject;
                Component c = super.getTreeCellRendererComponent(tree, value, selected, expanded, isLeaf, row, focused);
                this.setForeground(Color.BLACK);
                if (!((DefaultMutableTreeNode)value).isRoot() && !((userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof WorkingSet) && userObject instanceof WorkingSetEntry) {
                    WorkingSetEntry entry = (WorkingSetEntry)userObject;
                    if (!entry.exists()) {
                        this.setForeground(Color.LIGHT_GRAY);
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SPECTRUM_EMISSION));
                    } else if (WorkingSetView.this.m_downloadIndex.contains(entry.getFile().getAbsolutePath())) {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW_DOWN));
                    } else {
                        this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SPECTRUM_EMISSION));
                    }
                }
                return c;
            }
        });
        this.m_tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    WorkingSetView.this.updatePopupMenu();
                    WorkingSetView.this.m_popupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.m_tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent tee) {
                TreeUtils.saveExpansionState(WorkingSetView.this.m_tree, TreeUtils.TreeType.WORKING_SET, null);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent tee) {
                TreeUtils.saveExpansionState(WorkingSetView.this.m_tree, TreeUtils.TreeType.WORKING_SET, null);
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.m_tree);
        this.m_popupMenu = new JPopupMenu();
        this.initPopupMenu(this.m_popupMenu);
        this.add((Component)scrollPane, c);
        this.resetTreeState();
    }

    public void initPopupMenu(JPopupMenu popupMenu) {
        this.m_viewMzdbAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                final ArrayList localFiles = WorkingSetView.this.getSelectedRawFiles(WorkingSetEntry.Location.LOCAL);
                ArrayList remoteEntries = WorkingSetView.this.getSelectedWorkingSetEntries(WorkingSetEntry.Location.REMOTE);
                final ArrayList totalFiles = new ArrayList();
                if (!remoteEntries.isEmpty()) {
                    MsListener msListener = new MsListener(){

                        @Override
                        public void conversionPerformed(ArrayList<MsListenerConverterParameter> list) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public void uploadPerformed(ArrayList<MsListenerParameter> list) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public void downloadPerformed(ArrayList<MsListenerDownloadParameter> list) {
                            totalFiles.addAll(localFiles);
                            for (int i = 0; i < list.size(); ++i) {
                                File newFile;
                                MsListenerDownloadParameter p = list.get(i);
                                if (!p.wasSuccessful() || !(newFile = p.getDestinationFile()).exists()) continue;
                                WorkingSetView.this.replaceEntry(p.getRemoteFile(), newFile);
                                totalFiles.add(newFile);
                            }
                            WorkingSetView.this.verifyEncodingAndProcess(totalFiles, ActionType.VIEW);
                        }

                        @Override
                        public void exportPerformed(ArrayList<MsListenerParameter> list) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public void verificationPerformed(ArrayList<MsListenerParameter> list) {
                        }

                        @Override
                        public void entryStateUpdated(ArrayList<MsListenerEntryUpdateParameter> list) {
                            WorkingSetView.this.updateDownloadIndex(list);
                        }
                    };
                    String localDirPath = WorkingSetUtil.getTempDirectory().getAbsolutePath();
                    MzdbDownloadBatch downloadBatch = new MzdbDownloadBatch(localDirPath, "", remoteEntries);
                    downloadBatch.addMsListener(msListener);
                    Thread downloadThread = new Thread(downloadBatch);
                    downloadThread.start();
                } else {
                    WorkingSetView.this.verifyEncodingAndProcess(localFiles, ActionType.VIEW);
                }
            }
        };
        this.m_viewMzdb = new JMenuItem("View");
        this.m_viewMzdb.addActionListener(this.m_viewMzdbAction);
        popupMenu.add(this.m_viewMzdb);
        this.m_detectPeakels = new JMenuItem("Detect peakels");
        this.m_detectPeakels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                final ArrayList localFiles = WorkingSetView.this.getSelectedRawFiles(WorkingSetEntry.Location.LOCAL);
                ArrayList remoteEntries = WorkingSetView.this.getSelectedWorkingSetEntries(WorkingSetEntry.Location.REMOTE);
                final ArrayList totalFiles = new ArrayList();
                if (!remoteEntries.isEmpty()) {
                    MsListener msListener = new MsListener(){

                        @Override
                        public void conversionPerformed(ArrayList<MsListenerConverterParameter> list) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public void uploadPerformed(ArrayList<MsListenerParameter> list) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public void downloadPerformed(ArrayList<MsListenerDownloadParameter> list) {
                            totalFiles.addAll(localFiles);
                            for (int i = 0; i < list.size(); ++i) {
                                File newFile;
                                MsListenerDownloadParameter p = list.get(i);
                                if (!p.wasSuccessful() || !(newFile = p.getDestinationFile()).exists()) continue;
                                WorkingSetView.this.replaceEntry(p.getRemoteFile(), newFile);
                                totalFiles.add(newFile);
                            }
                            WorkingSetView.this.verifyEncodingAndProcess(totalFiles, ActionType.DETECT_PEAKELS);
                        }

                        @Override
                        public void exportPerformed(ArrayList<MsListenerParameter> list) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public void verificationPerformed(ArrayList<MsListenerParameter> list) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }

                        @Override
                        public void entryStateUpdated(ArrayList<MsListenerEntryUpdateParameter> list) {
                            WorkingSetView.this.updateDownloadIndex(list);
                        }
                    };
                    String localDirPath = WorkingSetUtil.getTempDirectory().getAbsolutePath();
                    MzdbDownloadBatch downloadBatch = new MzdbDownloadBatch(localDirPath, "", remoteEntries);
                    downloadBatch.addMsListener(msListener);
                    Thread downloadThread = new Thread(downloadBatch);
                    downloadThread.start();
                } else {
                    WorkingSetView.this.verifyEncodingAndProcess(localFiles, ActionType.DETECT_PEAKELS);
                }
            }
        });
        popupMenu.add(this.m_detectPeakels);
        this.m_addWorkingSet = new JMenuItem("Add a working set");
        this.m_addWorkingSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AddWorkingSetDialog dialog = AddWorkingSetDialog.getDialog(null, WorkingSetView.this.m_root);
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
                WorkingSetView.this.reloadAndSave();
            }
        });
        popupMenu.add(this.m_addWorkingSet);
        this.m_renameWorkingSet = new JMenuItem("Rename working set");
        this.m_renameWorkingSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String message = "Rename working set";
                String text = JOptionPane.showInputDialog(null, (Object)message);
                if (text != null && WorkingSetView.this.m_selectedWorkingSets.size() == 1) {
                    WorkingSetView.this.m_workingSetModel.updateJSONObject(WorkingSetModel.JSONObjectType.WORKING_SET, ((WorkingSet)WorkingSetView.this.m_selectedWorkingSets.get(0)).getName(), "name", text);
                    ((WorkingSet)WorkingSetView.this.m_selectedWorkingSets.get(0)).setName(text);
                    WorkingSetView.this.reloadAndSave();
                }
            }
        });
        popupMenu.add(this.m_renameWorkingSet);
        this.m_changeDescriptionAtWorkingSet = new JMenuItem("Change description");
        this.m_changeDescriptionAtWorkingSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String message = "Change description";
                String text = JOptionPane.showInputDialog(null, (Object)message);
                if (text != null && WorkingSetView.this.m_selectedWorkingSets.size() == 1) {
                    WorkingSetView.this.m_workingSetModel.updateJSONObject(WorkingSetModel.JSONObjectType.WORKING_SET, ((WorkingSet)WorkingSetView.this.m_selectedWorkingSets.get(0)).getName(), "description", text);
                    ((WorkingSet)WorkingSetView.this.m_selectedWorkingSets.get(0)).setDescription(text);
                    WorkingSetView.this.reloadAndSave();
                }
            }
        });
        popupMenu.add(this.m_changeDescriptionAtWorkingSet);
        this.m_removeWorkingSet = new JMenuItem("Remove a working set");
        this.m_removeWorkingSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)WorkingSetView.this.m_workingSetModel.getRoot();
                WorkingSetRoot workingSetRoot = (WorkingSetRoot)root.getUserObject();
                boolean success = false;
                for (int i = 0; i < WorkingSetView.this.m_selectedWorkingSets.size(); ++i) {
                    if (!workingSetRoot.removeWorkingSet(((WorkingSet)WorkingSetView.this.m_selectedWorkingSets.get(i)).getName())) continue;
                    success = true;
                    break;
                }
                if (success) {
                    WorkingSetView.this.reloadModel();
                    WorkingSetView.this.resetTreeState();
                    WorkingSetUtil.saveJSON(workingSetRoot.getWorkingSets());
                }
            }
        });
        popupMenu.add(this.m_removeWorkingSet);
        this.m_addWorkingSetEntry = new JMenuItem("Add an entry");
        this.m_addWorkingSetEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AddlWorkingSetEntryDialog dialog = AddlWorkingSetEntryDialog.getDialog(null, (WorkingSet)WorkingSetView.this.m_selectedWorkingSets.get(0));
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
                TreePath pathToExpand = WorkingSetView.this.m_tree.getSelectionPaths()[0];
                WorkingSetView.this.m_tree.expandPath(pathToExpand);
                WorkingSetView.this.reloadAndSave();
            }
        });
        popupMenu.add(this.m_addWorkingSetEntry);
        this.m_removeWorkingSetEntry = new JMenuItem("Remove an entry");
        this.m_removeWorkingSetEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (!WorkingSetView.this.m_selectedWorkingSetEntries.isEmpty() || !WorkingSetView.this.m_existingSelectedWorkingSetEntries.isEmpty()) {
                    int i;
                    boolean success = false;
                    for (i = 0; i < WorkingSetView.this.m_selectedWorkingSetEntries.size(); ++i) {
                        if (!((WorkingSetEntry)WorkingSetView.this.m_selectedWorkingSetEntries.get(i)).getParent().removeEntry(((WorkingSetEntry)WorkingSetView.this.m_selectedWorkingSetEntries.get(i)).getPath())) continue;
                        success = true;
                    }
                    for (i = 0; i < WorkingSetView.this.m_existingSelectedWorkingSetEntries.size(); ++i) {
                        if (!((WorkingSetEntry)WorkingSetView.this.m_existingSelectedWorkingSetEntries.get(i)).getParent().removeEntry(((WorkingSetEntry)WorkingSetView.this.m_existingSelectedWorkingSetEntries.get(i)).getPath())) continue;
                        success = true;
                    }
                    if (success) {
                        WorkingSetView.this.reloadAndSave();
                    }
                }
            }
        });
        popupMenu.add(this.m_removeWorkingSetEntry);
    }

    public void resetTreeState() {
        TreeUtils.setExpansionState(TreeUtils.loadExpansionState(TreeUtils.TreeType.WORKING_SET, null), this.m_tree, (DefaultMutableTreeNode)this.m_tree.getModel().getRoot(), TreeUtils.TreeType.WORKING_SET, null);
    }

    public void updatePopupMenu() {
        this.updateSelectedObjects();
        this.setPopupEnabled(false);
        if (this.m_selectedRoot != null && this.m_selectedWorkingSets.isEmpty() && this.m_selectedWorkingSetEntries.isEmpty()) {
            this.m_addWorkingSet.setEnabled(true);
        }
        if (this.m_selectedRoot == null && this.m_selectedWorkingSetEntries.isEmpty() && this.m_selectedWorkingSets.size() == 1) {
            this.m_renameWorkingSet.setEnabled(true);
        }
        if (this.m_selectedRoot == null && this.m_selectedWorkingSetEntries.isEmpty() && this.m_selectedWorkingSets.size() == 1) {
            this.m_changeDescriptionAtWorkingSet.setEnabled(true);
        }
        if (this.m_selectedRoot == null && this.m_selectedWorkingSets.size() == 1 && this.m_selectedWorkingSetEntries.isEmpty()) {
            this.m_addWorkingSetEntry.setEnabled(true);
        }
        if (this.m_selectedRoot == null && this.m_selectedWorkingSets.isEmpty() && !this.m_selectedWorkingSetEntries.isEmpty()) {
            this.m_removeWorkingSetEntry.setEnabled(true);
        }
        if (this.m_selectedRoot == null && !this.m_selectedWorkingSets.isEmpty() && this.m_selectedWorkingSetEntries.isEmpty()) {
            this.m_removeWorkingSet.setEnabled(true);
        }
        if (!this.m_existingSelectedWorkingSetEntries.isEmpty()) {
            this.m_viewMzdb.setEnabled(true);
            this.m_detectPeakels.setEnabled(true);
        }
    }

    private void updateDownloadIndex(ArrayList<MsListenerEntryUpdateParameter> list) {
        for (int i = 0; i < list.size(); ++i) {
            MsListenerEntryUpdateParameter parameter = list.get(i);
            if (parameter.getState() == MsListenerEntryUpdateParameter.State.DOWNLOAD_COMPLETE) {
                this.m_downloadIndex.remove(parameter.getFile().getAbsolutePath());
                continue;
            }
            this.m_downloadIndex.add(parameter.getFile().getAbsolutePath());
        }
    }

    private void setPopupEnabled(boolean b) {
        this.m_addWorkingSet.setEnabled(b);
        this.m_renameWorkingSet.setEnabled(b);
        this.m_changeDescriptionAtWorkingSet.setEnabled(b);
        this.m_removeWorkingSet.setEnabled(b);
        this.m_addWorkingSetEntry.setEnabled(b);
        this.m_removeWorkingSetEntry.setEnabled(b);
        this.m_viewMzdb.setEnabled(b);
        this.m_detectPeakels.setEnabled(b);
    }

    public ActionListener getDefaultAction() {
        return null;
    }

    private void displayRaw(ArrayList<File> rawfiles) {
        MzScope mzScope = new MzScope(1, rawfiles);
        MzScopeWindowBoxManager.addMzdbScope(mzScope);
    }

    private void detectPeakels(ArrayList<File> rawfiles) {
        MzScope mzScope = new MzScope(0, rawfiles);
        MzScopeWindowBoxManager.addMzdbScope(mzScope);
    }

    private void updateSelectedObjects() {
        this.m_selectedWorkingSets.clear();
        this.m_selectedWorkingSetEntries.clear();
        this.m_existingSelectedWorkingSetEntries.clear();
        this.m_selectedRoot = null;
        TreePath[] paths = this.m_tree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : paths) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object userObject = node.getUserObject();
                if (userObject instanceof WorkingSetRoot) {
                    this.m_selectedRoot = (WorkingSetRoot)userObject;
                    continue;
                }
                if (userObject instanceof WorkingSet) {
                    this.m_selectedWorkingSets.add((WorkingSet)userObject);
                    continue;
                }
                if (!(userObject instanceof WorkingSetEntry)) continue;
                WorkingSetEntry entry = (WorkingSetEntry)userObject;
                this.m_selectedWorkingSetEntries.add(entry);
                if (!entry.exists()) continue;
                this.m_existingSelectedWorkingSetEntries.add(entry);
            }
        }
    }

    private ArrayList<File> getSelectedRawFiles(WorkingSetEntry.Location location) {
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < this.m_selectedWorkingSetEntries.size(); ++i) {
            WorkingSetEntry entry = this.m_selectedWorkingSetEntries.get(i);
            if (entry.getLocation() != location) continue;
            files.add(entry.getFile());
        }
        return files;
    }

    private ArrayList<WorkingSetEntry> getSelectedWorkingSetEntries(WorkingSetEntry.Location location) {
        ArrayList<WorkingSetEntry> entries = new ArrayList<WorkingSetEntry>();
        for (int i = 0; i < this.m_selectedWorkingSetEntries.size(); ++i) {
            WorkingSetEntry entry = this.m_selectedWorkingSetEntries.get(i);
            if (entry.getLocation() != location) continue;
            entries.add(entry);
        }
        return entries;
    }

    private void reloadModel() {
        if (this.m_workingSetModel != null) {
            this.m_tree.setModel(null);
            this.m_workingSetModel = new WorkingSetModel(this.m_root);
            this.m_tree.setModel(this.m_workingSetModel);
        }
    }

    private void replaceEntry(File oldFile, File newFile) {
        HashMap<String, ArrayList<WorkingSet>> index = this.m_workingSetModel.getAssociationsIndex();
        if (index.containsKey(oldFile.getAbsolutePath())) {
            ArrayList<WorkingSet> list = index.get(oldFile.getAbsolutePath());
            for (int i = 0; i < list.size(); ++i) {
                WorkingSet set = list.get(i);
                set.removeEntry(oldFile.getAbsolutePath());
                set.addEntry(newFile.getAbsolutePath(), WorkingSetEntry.Location.LOCAL);
            }
        }
    }

    private void verifyEncodingAndProcess(ArrayList<File> totalFiles, final ActionType actionType) {
        MsListener listener = new MsListener(){

            @Override
            public void conversionPerformed(ArrayList<MsListenerConverterParameter> list) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void uploadPerformed(ArrayList<MsListenerParameter> list) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void downloadPerformed(ArrayList<MsListenerDownloadParameter> list) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void exportPerformed(ArrayList<MsListenerParameter> list) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void verificationPerformed(ArrayList<MsListenerParameter> list) {
                WorkingSetView.this.reloadAndSave();
                ArrayList<File> verifiedFiles = new ArrayList<File>();
                for (int i = 0; i < list.size(); ++i) {
                    MsListenerParameter p = list.get(i);
                    if (!p.wasSuccessful()) continue;
                    verifiedFiles.add(p.getFile());
                }
                if (verifiedFiles.size() > 0) {
                    if (actionType == ActionType.DETECT_PEAKELS) {
                        WorkingSetView.this.detectPeakels(verifiedFiles);
                    } else if (actionType == ActionType.VIEW) {
                        WorkingSetView.this.displayRaw(verifiedFiles);
                    }
                }
            }

            @Override
            public void entryStateUpdated(ArrayList<MsListenerEntryUpdateParameter> list) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
        MzdbEncodingVerificationBatch batch = new MzdbEncodingVerificationBatch(totalFiles);
        batch.addMsListener(listener);
        Thread thread = new Thread(batch);
        thread.start();
    }

    public void reloadAndSave() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.m_workingSetModel.getRoot();
        WorkingSetRoot workingSetRoot = (WorkingSetRoot)root.getUserObject();
        WorkingSetUtil.saveJSON(workingSetRoot.getWorkingSets());
        this.reloadModel();
        this.resetTreeState();
    }

    public WorkingSetModel getModel() {
        return this.m_workingSetModel;
    }

    public void expand(TreePath path) {
        this.m_tree.expandPath(path);
    }

    public static enum ActionType {
        VIEW,
        DETECT_PEAKELS;

    }
}

