/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.memory.TransientMemoryCacheManager;
import fr.proline.studio.dam.memory.TransientMemoryClientInterface;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.id.ProjectId;
import fr.proline.studio.pattern.AddDataBoxActionListener;
import fr.proline.studio.pattern.AvailableParameters;
import fr.proline.studio.pattern.DataBoxAdjacencyMatrix;
import fr.proline.studio.pattern.DataBoxAdjacencyMatrixChoice;
import fr.proline.studio.pattern.DataBoxDataAnalyzerResults;
import fr.proline.studio.pattern.DataBoxImage;
import fr.proline.studio.pattern.DataBoxMSQueriesForRSM;
import fr.proline.studio.pattern.DataBoxMSQueriesForRset;
import fr.proline.studio.pattern.DataBoxMzScope;
import fr.proline.studio.pattern.DataBoxPTMClusters;
import fr.proline.studio.pattern.DataBoxPTMClustersSites;
import fr.proline.studio.pattern.DataBoxPTMPeptides;
import fr.proline.studio.pattern.DataBoxPTMPeptidesGraphic;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.DataBoxRsetAll;
import fr.proline.studio.pattern.DataBoxRsetAllProteinMatch;
import fr.proline.studio.pattern.DataBoxRsetMSDiag;
import fr.proline.studio.pattern.DataBoxRsetPSM;
import fr.proline.studio.pattern.DataBoxRsetPeptideFragmentation;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrum;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrumError;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrumValues;
import fr.proline.studio.pattern.DataBoxRsetProteinsForPeptideMatch;
import fr.proline.studio.pattern.DataBoxRsmAllProteinSet;
import fr.proline.studio.pattern.DataBoxRsmPSM;
import fr.proline.studio.pattern.DataBoxRsmPSMForMsQuery;
import fr.proline.studio.pattern.DataBoxRsmPeptideInstances;
import fr.proline.studio.pattern.DataBoxRsmPeptidesOfProtein;
import fr.proline.studio.pattern.DataBoxRsmProteinAndPeptideSequence;
import fr.proline.studio.pattern.DataBoxRsmProteinSetOfPeptides;
import fr.proline.studio.pattern.DataBoxRsmProteinsOfProteinSet;
import fr.proline.studio.pattern.DataBoxSystemTasks;
import fr.proline.studio.pattern.DataBoxTaskDescription;
import fr.proline.studio.pattern.DataBoxTaskList;
import fr.proline.studio.pattern.DataboxGraphics;
import fr.proline.studio.pattern.DataboxMultiGraphics;
import fr.proline.studio.pattern.DataboxRsetPSMForMsQuery;
import fr.proline.studio.pattern.DataboxRsetPeptidesOfProtein;
import fr.proline.studio.pattern.DataboxRsmPSMOfPeptide;
import fr.proline.studio.pattern.DataboxRsmPSMOfProteinSet;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.pattern.RemoveDataBoxActionListener;
import fr.proline.studio.pattern.SaveDataBoxActionListener;
import fr.proline.studio.pattern.xic.DataboxChildFeature;
import fr.proline.studio.pattern.xic.DataboxExperimentalDesign;
import fr.proline.studio.pattern.xic.DataboxMapAlignment;
import fr.proline.studio.pattern.xic.DataboxPSMOfMasterQuantPeptide;
import fr.proline.studio.pattern.xic.DataboxXicParentsPeptideIon;
import fr.proline.studio.pattern.xic.DataboxXicPeptideIon;
import fr.proline.studio.pattern.xic.DataboxXicPeptideSet;
import fr.proline.studio.pattern.xic.DataboxXicProteinSet;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.utils.IconManager;
import java.awt.Image;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataBox
implements ChangeListener,
ProgressInterface,
SplittedPanelContainer.UserActions,
TransientMemoryClientInterface {
    protected DataBoxPanelInterface m_panel;
    private ParameterList m_inParameters = null;
    private ParameterList m_outParameters = null;
    private final HashMap<Long, TaskInfo> m_taskMap = new HashMap();
    private final ProjectId m_projectId = new ProjectId();
    protected String m_typeName;
    protected String m_dataName;
    protected String m_fullName = null;
    protected String m_description = "";
    protected String m_userName = null;
    private SplittedPanelContainer.PanelLayout m_layout = SplittedPanelContainer.PanelLayout.VERTICAL;
    protected ArrayList<AbstractDataBox> m_nextDataBoxArray = null;
    protected AbstractDataBox m_previousDataBox = null;
    private int m_loadingId = 0;
    private int m_id = -1;
    private static int m_idCount = 0;
    private Image m_icon;
    protected DataboxStyle m_style;
    protected DataboxType m_type;
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.databox");
    private static LinkedList<AbstractDataBox> queueList = new LinkedList();
    private HashMap<Class, HashSet<ParameterSubtypeEnum>> m_dataChangedMap = new HashMap();
    private static StringBuilder m_sb = new StringBuilder();

    public AbstractDataBox(DataboxType type, DataboxStyle style) {
        this.m_type = type;
        this.m_style = style;
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(ProjectId.class);
        this.registerOutParameter(outParameter);
    }

    protected void setDataBoxPanelInterface(DataBoxPanelInterface panelInterface) {
        this.m_panel = panelInterface;
        if (this.m_panel != null) {
            this.getDataBoxPanelInterface().addSingleValue(this.m_projectId);
        }
    }

    protected DataBoxPanelInterface getDataBoxPanelInterface() {
        return this.m_panel;
    }

    public void setUserName(String userName) {
        this.m_userName = userName;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public DataboxType getType() {
        return this.m_type;
    }

    public DataboxStyle getStyle() {
        return this.m_style;
    }

    public int getId() {
        if (this.m_id == -1) {
            this.m_id = ++m_idCount;
        }
        return this.m_id;
    }

    public void setIcon(Image icon) {
        this.m_icon = icon;
    }

    public Image getIcon() {
        return this.m_icon;
    }

    public Image getDefaultIcon() {
        switch (this.m_style) {
            case STYLE_RSET: {
                return IconManager.getImage((IconManager.IconType)IconManager.IconType.DATASET_RSET);
            }
            case STYLE_RSM: {
                return IconManager.getImage((IconManager.IconType)IconManager.IconType.DATASET_RSM);
            }
            case STYLE_XIC: {
                return IconManager.getImage((IconManager.IconType)IconManager.IconType.QUANT_XIC);
            }
            case STYLE_SC: {
                return IconManager.getImage((IconManager.IconType)IconManager.IconType.QUANT_SC);
            }
            case STYLE_UNKNOWN: {
                return null;
            }
        }
        return null;
    }

    protected void deleteThis() {
        this.unlinkCache();
        if (!this.m_taskMap.isEmpty()) {
            AccessDatabaseThread.getAccessDatabaseThread().abortTasks(this.m_taskMap.keySet());
            this.m_taskMap.clear();
        }
        if (this.m_nextDataBoxArray != null) {
            for (AbstractDataBox nextDataBox : this.m_nextDataBoxArray) {
                nextDataBox.deleteThis();
            }
        }
    }

    protected void linkCache(TransientDataInterface cache) {
        if (this.m_previousDataBox != null) {
            this.m_previousDataBox.linkCache(cache);
            return;
        }
        TransientMemoryCacheManager.getSingleton().linkCache((TransientMemoryClientInterface)this, cache);
    }

    private void unlinkCache() {
        if (this.m_previousDataBox != null) {
            this.m_previousDataBox.unlinkCache();
            return;
        }
        TransientMemoryCacheManager.getSingleton().unlinkCache((TransientMemoryClientInterface)this);
    }

    protected void registerTask(AbstractDatabaseTask task) {
        AccessDatabaseThread.getAccessDatabaseThread().addTask(task);
        this.m_taskMap.put(task.getId(), task.getTaskInfo());
    }

    protected void unregisterTask(Long taskId) {
        this.m_taskMap.remove(taskId);
    }

    protected TaskInfo getTaskInfo(Long taskId) {
        return this.m_taskMap.get(taskId);
    }

    protected final void registerInParameter(ParameterList parameter) {
        if (this.m_inParameters == null) {
            this.m_inParameters = parameter;
        } else {
            this.m_inParameters.addParameter(parameter);
        }
    }

    protected final void registerOutParameter(ParameterList parameter) {
        if (this.m_outParameters == null) {
            this.m_outParameters = parameter;
        } else {
            this.m_outParameters.addParameter(parameter);
        }
    }

    public ParameterList getOutParameters() {
        return this.m_outParameters;
    }

    public ParameterList getInParameters() {
        return this.m_inParameters;
    }

    public Object getExtraData(Class parameterType) {
        if (this.isDataDependant(parameterType, ParameterSubtypeEnum.SINGLE_DATA)) {
            return null;
        }
        if (this.m_previousDataBox != null) {
            return this.m_previousDataBox.getExtraData(parameterType);
        }
        return null;
    }

    public boolean isDataDependant(Class dataType, ParameterSubtypeEnum subtype) {
        return this.m_inParameters.isDataDependant(dataType, subtype);
    }

    public boolean isDataDependant(HashMap<Class, HashSet<ParameterSubtypeEnum>> dataTypeMap) {
        for (Class dataType : dataTypeMap.keySet()) {
            HashSet<ParameterSubtypeEnum> subtypeSet = dataTypeMap.get(dataType);
            for (ParameterSubtypeEnum subtype : subtypeSet) {
                if (!this.m_inParameters.isDataDependant(dataType, subtype)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDataProvider(Class dataType, ParameterSubtypeEnum subtype) {
        return this.m_outParameters.isDataDependant(dataType, subtype);
    }

    public boolean isDataOfInterest(Long rsetId, Long rsmId, Class dataType) {
        boolean isOfInterest;
        boolean bl = isOfInterest = rsetId == null || rsetId.equals(this.getRsetId());
        isOfInterest = rsmId != null ? isOfInterest && rsmId.equals(this.getRsmId()) : isOfInterest;
        return isOfInterest && this.isDataProvider(dataType, null);
    }

    public boolean isClosable() {
        return true;
    }

    public String getClosingWarningMessage() {
        return "";
    }

    public void loadedDataModified(Long rsetId, Long rsmId, Class dataType, ArrayList modificationsList, byte reason) {
        if (this.isDataProvider(dataType, null)) {
            this.dataMustBeRecalculated(rsetId, rsmId, dataType, modificationsList, reason);
        }
        if (this.m_nextDataBoxArray != null) {
            for (AbstractDataBox nextDataBox : this.m_nextDataBoxArray) {
                nextDataBox.loadedDataModified(rsetId, rsmId, dataType, modificationsList, reason);
            }
        }
    }

    public double calculateParameterCompatibilityDistance(ArrayList<ParameterList> outParameters) {
        if (this.m_inParameters.isCompatibleWithOutParameter(outParameters)) {
            return 0.0;
        }
        return -1.0;
    }

    public double calculateParameterCompatibilityDistance(AvailableParameters avalaibleParameters, AbstractDataBox nextDataBox, Class compulsoryInParameterClass) {
        return avalaibleParameters.calculateParameterCompatibilityDistance(nextDataBox, compulsoryInParameterClass);
    }

    public void addNextDataBox(AbstractDataBox nextDataBox) {
        if (this.m_nextDataBoxArray == null) {
            this.m_nextDataBoxArray = new ArrayList(1);
        }
        this.m_nextDataBoxArray.add(nextDataBox);
        if (nextDataBox != null) {
            nextDataBox.m_previousDataBox = this;
        }
    }

    public void removeNextDataBox(AbstractDataBox nextDataBox) {
        if (this.m_nextDataBoxArray == null) {
            return;
        }
        this.m_nextDataBoxArray.remove(nextDataBox);
    }

    public abstract void createPanel();

    public abstract void dataChanged();

    public void dataMustBeRecalculated(Long rsetId, Long rsmId, Class dataType, ArrayList modificationsList, byte reason) {
    }

    public final Object getData(Class parameterType) {
        return this.getData(parameterType, ParameterSubtypeEnum.SINGLE_DATA);
    }

    public final Object getData(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        this.checkDataAsked(parameterType, parameterSubtype);
        if (parameterSubtype == null) {
            parameterSubtype = ParameterSubtypeEnum.SINGLE_DATA;
        }
        return this.getDataImpl(parameterType, parameterSubtype);
    }

    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterType.equals(ProjectId.class)) {
            if ((this.m_projectId == null || this.m_projectId.getId() == -1L) && this.m_previousDataBox != null) {
                return this.m_previousDataBox.getDataImpl(parameterType, parameterSubtype);
            }
            return this.m_projectId;
        }
        if (this.m_previousDataBox != null) {
            Object result = this.m_previousDataBox.getDataImpl(parameterType, parameterSubtype);
            this.checkDataReturned(parameterType, parameterSubtype, result);
            return result;
        }
        return null;
    }

    private void checkDataAsked(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (!(parameterType.equals(ProjectId.class) || this.m_inParameters.isDataDependant(parameterType, parameterSubtype) || this.m_outParameters.isDataDependant(parameterType, parameterSubtype))) {
            boolean nextOk = false;
            if (this.m_nextDataBoxArray != null) {
                for (AbstractDataBox nextDataBox : this.m_nextDataBoxArray) {
                    if (!nextDataBox.m_inParameters.isDataDependant(parameterType, parameterSubtype)) continue;
                    nextOk = true;
                    break;
                }
            }
            if (!nextOk) {
                m_logger.warn("DataBox {} ask for unregistered in parameter {}", (Object)this.getClass().getName(), (Object)parameterType.getName());
            }
        }
    }

    private void checkDataReturned(Class parameterType, ParameterSubtypeEnum parameterSubtype, Object data) {
        if (data != null) {
            boolean errorFound = false;
            if (parameterSubtype.equals((Object)ParameterSubtypeEnum.SINGLE_DATA)) {
                if (!parameterType.equals(data.getClass()) && !parameterType.isAssignableFrom(data.getClass())) {
                    errorFound = true;
                }
            } else {
                Object elem;
                List l;
                Class<?> alternativeClass = null;
                if (data instanceof List && !(l = (List)data).isEmpty() && (elem = l.get(0)) != null) {
                    alternativeClass = l.get(0).getClass();
                }
                if (!(alternativeClass == null || parameterType.equals(data.getClass()) || parameterType.isAssignableFrom(data.getClass()) || parameterType.equals(alternativeClass) || parameterType.isAssignableFrom(alternativeClass))) {
                    errorFound = true;
                }
            }
            if (errorFound) {
                m_logger.warn("DataBox {} returns a wrong type : {} instead of {}. Error can come form ArrayList<A> instead of A.", new Object[]{this.m_previousDataBox.getClass().getName(), data.getClass().getName(), parameterType.getName()});
            }
        }
    }

    public void setEntryData(Object data) {
        throw new UnsupportedOperationException();
    }

    private static void propagateDataChanged(AbstractDataBox a) {
        if (queueList.contains(a)) {
            return;
        }
        queueList.add(a);
        if (queueList.size() > 1) {
            return;
        }
        try {
            while (!queueList.isEmpty()) {
                AbstractDataBox currentBox = queueList.peekFirst();
                if (m_logger.isDebugEnabled()) {
                    AbstractDataBox.logPropagateDataChanged(currentBox);
                }
                currentBox.propagateDataChanged(currentBox.m_dataChangedMap);
                currentBox.m_dataChangedMap.clear();
                queueList.pop();
            }
        }
        catch (Exception e) {
            queueList.clear();
            throw e;
        }
    }

    public void addDataChanged(Class dataType) {
        this.addDataChanged(dataType, ParameterSubtypeEnum.SINGLE_DATA);
    }

    public void addDataChanged(Class dataType, ParameterSubtypeEnum parameterSubtype) {
        if (this.m_nextDataBoxArray == null) {
            return;
        }
        HashSet<ParameterSubtypeEnum> hashSet = this.m_dataChangedMap.get(dataType);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.m_dataChangedMap.put(dataType, hashSet);
        }
        hashSet.add(parameterSubtype);
    }

    public void propagateDataChanged() {
        if (this.m_nextDataBoxArray == null) {
            return;
        }
        AbstractDataBox.propagateDataChanged(this);
    }

    private void propagateDataChanged(HashMap<Class, HashSet<ParameterSubtypeEnum>> dataTypeMap) {
        if (this.m_nextDataBoxArray != null) {
            for (AbstractDataBox nextDataBox : this.m_nextDataBoxArray) {
                if (!nextDataBox.isDataDependant(dataTypeMap)) continue;
                nextDataBox.dataChanged();
            }
            for (AbstractDataBox nextDataBox : this.m_nextDataBoxArray) {
                nextDataBox.propagateDataChanged(dataTypeMap);
            }
        }
    }

    public static void logPropagateDataChanged(AbstractDataBox box) {
        m_sb.setLength(0);
        m_sb.append((Object)box.getType()).append("#").append(box.getClass().getName()).append("@").append(Integer.toHexString(box.hashCode())).append("#").append(box.getFullName()).append(" : ");
        HashMap<Class, HashSet<ParameterSubtypeEnum>> dataChangedMap = box.m_dataChangedMap;
        Iterator<Class> itClass = dataChangedMap.keySet().iterator();
        while (itClass.hasNext()) {
            Class c = itClass.next();
            m_sb.append(c.getName()).append(" - ");
            HashSet<ParameterSubtypeEnum> subParameters = dataChangedMap.get(c);
            Iterator<ParameterSubtypeEnum> it = subParameters.iterator();
            while (it.hasNext()) {
                ParameterSubtypeEnum subtype = it.next();
                m_sb.append((Object)subtype);
                if (!it.hasNext()) continue;
                m_sb.append(", ");
            }
            if (!itClass.hasNext()) continue;
            m_sb.append("  | ");
        }
        m_logger.debug("propagateDataChanged() {}", (Object)m_sb.toString());
    }

    public void setProjectId(long projectId) {
        if (this.m_panel != null) {
            this.getDataBoxPanelInterface().addSingleValue(this.m_projectId);
        }
        this.m_projectId.setId(projectId);
    }

    public long getProjectId() {
        ProjectId projectId = (ProjectId)this.getData(ProjectId.class);
        if (projectId == null) {
            return -1L;
        }
        return projectId.getId();
    }

    public Long getRsetId() {
        if (this.m_previousDataBox != null) {
            return this.m_previousDataBox.getRsetId();
        }
        return null;
    }

    public Long getRsmId() {
        if (this.m_previousDataBox != null) {
            return this.m_previousDataBox.getRsmId();
        }
        return null;
    }

    public DataBoxPanelInterface getPanel() {
        return this.m_panel;
    }

    public void setLayout(SplittedPanelContainer.PanelLayout layout) {
        this.m_layout = layout;
    }

    public SplittedPanelContainer.PanelLayout getLayout() {
        return this.m_layout;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setDataName(String dataName) {
        this.m_dataName = dataName;
    }

    public String getDataName() {
        if (this.m_dataName != null) {
            return this.m_dataName;
        }
        if (this.m_previousDataBox != null) {
            return this.m_previousDataBox.getDataName();
        }
        return null;
    }

    public String getFullName() {
        if (this.m_userName != null) {
            return this.m_userName;
        }
        if (this.m_fullName != null) {
            return this.m_fullName;
        }
        String dataName = this.getDataName();
        if (dataName != null) {
            this.m_fullName = dataName + ' ' + this.m_typeName;
            return this.m_fullName;
        }
        return this.getTypeName();
    }

    public String getMemoryClientName() {
        return this.getFullName();
    }

    public String getMemoryDataName() {
        String dataName = this.getDataName();
        return dataName != null ? dataName : "";
    }

    public String getDescription() {
        return this.m_description;
    }

    public void windowClosed() {
        this.deleteThis();
    }

    public void windowOpened() {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }

    public int setLoading(boolean andCalculating) {
        int loadingId = this.m_loadingId++;
        this.getDataBoxPanelInterface().setLoading(loadingId, andCalculating);
        return loadingId;
    }

    public int setLoading() {
        int loadingId = this.m_loadingId++;
        this.getDataBoxPanelInterface().setLoading(loadingId);
        return loadingId;
    }

    public void setLoaded(int loadingId) {
        this.getDataBoxPanelInterface().setLoaded(loadingId);
    }

    protected void selectDataWhenLoaded(HashSet data) {
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return new RemoveDataBoxActionListener(splittedPanel, this);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return new AddDataBoxActionListener(splittedPanel, this);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return new SaveDataBoxActionListener(splittedPanel);
    }

    public int getLoadingPercentage() {
        if (this.m_taskMap.isEmpty()) {
            return 100;
        }
        float percentage = 0.0f;
        int nb = 0;
        for (TaskInfo info : this.m_taskMap.values()) {
            percentage += info.getPercentage();
            ++nb;
        }
        return Math.round(percentage /= (float)nb);
    }

    public boolean isLoaded() {
        if (this.m_taskMap.isEmpty()) {
            return true;
        }
        for (TaskInfo info : this.m_taskMap.values()) {
            if (info.isFinished() || info.isAborted()) continue;
            return false;
        }
        return true;
    }

    public void retrieveTableModels(ArrayList<TableInfo> list) {
        JXTable table;
        if (this.m_panel instanceof GlobalTabelModelProviderInterface && (table = ((GlobalTabelModelProviderInterface)this.m_panel).getGlobalAssociatedTable()) != null) {
            TableInfo info = new TableInfo(this.getId(), this.m_userName, this.getDataName(), this.getTypeName(), table);
            list.add(info);
        }
        if (this.m_nextDataBoxArray != null) {
            for (AbstractDataBox nextDataBox : this.m_nextDataBoxArray) {
                nextDataBox.retrieveTableModels(list);
            }
        }
    }

    public ArrayList<AbstractDataBox> getNextDataBoxArray() {
        return this.m_nextDataBoxArray;
    }

    public Class[] getDataboxNavigationOutParameterClasses() {
        return null;
    }

    public String getDataboxNavigationDisplayValue() {
        return null;
    }

    public static enum DataboxType {
        DataBoxRsetAll(0),
        DataBoxRsetAllProteinMatch(1),
        DataBoxRsetPSM(2),
        DataBoxRsetPeptideFragmentation(3),
        DataBoxRsetPeptideSpectrum(4),
        DataBoxRsetPeptideSpectrumError(5),
        DataBoxRsetProteinsForPeptideMatch(6),
        DataBoxRsmAllProteinSet(7),
        DataBoxRsmPSM(8),
        DataBoxRsmPeptideInstances(9),
        DataBoxRsmPeptidesOfProtein(10),
        DataBoxRsmProteinAndPeptideSequence(11),
        DataBoxRsmProteinSetOfPeptides(12),
        DataBoxRsmProteinsOfProteinSet(13),
        DataBoxTaskDescription(16),
        DataBoxTaskList(17),
        DataboxRsetPeptidesOfProtein(18),
        DataboxRsmPSMOfProteinSet(19),
        DataboxRsmPSMOfPeptide(20),
        DataboxXicProteinSet(21),
        DataboxRsetMSDiag(22),
        DataboxXicPeptideSetShortList(23),
        DataboxCompareResult(24),
        DataboxXicPeptideSet(25),
        DataboxXicPeptideIon(26),
        DataboxGraphics(27),
        DataboxXicChildFeature(28),
        DataboxMultiGraphics(29),
        DataboxPSMOfMasterQuantPeptide(30),
        DataBoxMzScope(31),
        DataboxDataAnalyzer(32),
        DataboxExperimentalDesign(33),
        DataBoxAdjacencyMatrix(34),
        DataBoxAdjacencyMatrixChoice(35),
        DataBoxMapAlignment(36),
        DataBoxMSQueriesForRSM(37),
        DataBoxRSMPSMForMsQuery(38),
        DataBoxRsetPeptideSpectrumValues(39),
        DataBoxMSQueriesForRset(40),
        DataBoxRsetPSMForMsQuery(41),
        DataBoxDataAnalyzerResults(43),
        DataBoxImage(44),
        DataBoxSystemTasks(45),
        DataBoxFrozenCopy(46),
        DataBoxPTMSiteProtein(47),
        DataBoxPTMSitePeptides(48),
        DataBoxPTMSitePepMatches(49),
        DataBoxXicPTMPeptides(50),
        DataBoxXicPTMPeptidesMatches(51),
        DataBoxPTMSitePeptidesGraphic(52),
        DataboxMultiGraphicsDoubleYAxis(53),
        DataBoxPTMPeptides(54),
        DataBoxPTMClusters(55),
        DataBoxPTMPeptidesMatches(56),
        DataBoxPTMPeptidesGraphic(57),
        DataboxXicParentsPeptideIon(58),
        DataBoxPTMSiteAsClusters(59),
        DataBoxPTMClustersSites(60),
        DataBoxXicPTMClustersSites(61);

        int m_type;
        private static HashMap<Integer, DataboxType> m_databoxTypeMap;

        private DataboxType(int type) {
            this.m_type = type;
        }

        public int intValue() {
            return this.m_type;
        }

        public AbstractDataBox getDatabox() {
            switch (this) {
                case DataBoxRsetAll: {
                    return new DataBoxRsetAll();
                }
                case DataBoxRsetAllProteinMatch: {
                    return new DataBoxRsetAllProteinMatch();
                }
                case DataBoxRsetPSM: {
                    return new DataBoxRsetPSM();
                }
                case DataBoxRsetPeptideFragmentation: {
                    return new DataBoxRsetPeptideFragmentation();
                }
                case DataBoxRsetPeptideSpectrum: {
                    return new DataBoxRsetPeptideSpectrum();
                }
                case DataBoxRsetPeptideSpectrumError: {
                    return new DataBoxRsetPeptideSpectrumError();
                }
                case DataBoxRsetProteinsForPeptideMatch: {
                    return new DataBoxRsetProteinsForPeptideMatch();
                }
                case DataBoxRsmAllProteinSet: {
                    return new DataBoxRsmAllProteinSet();
                }
                case DataBoxRsmPSM: {
                    return new DataBoxRsmPSM();
                }
                case DataBoxRsmPeptideInstances: {
                    return new DataBoxRsmPeptideInstances();
                }
                case DataBoxRsmPeptidesOfProtein: {
                    return new DataBoxRsmPeptidesOfProtein();
                }
                case DataBoxRsmProteinAndPeptideSequence: {
                    return new DataBoxRsmProteinAndPeptideSequence();
                }
                case DataBoxRsmProteinSetOfPeptides: {
                    return new DataBoxRsmProteinSetOfPeptides();
                }
                case DataBoxRsmProteinsOfProteinSet: {
                    return new DataBoxRsmProteinsOfProteinSet();
                }
                case DataBoxTaskDescription: {
                    return new DataBoxTaskDescription();
                }
                case DataBoxTaskList: {
                    return new DataBoxTaskList();
                }
                case DataboxRsetPeptidesOfProtein: {
                    return new DataboxRsetPeptidesOfProtein();
                }
                case DataboxRsmPSMOfProteinSet: {
                    return new DataboxRsmPSMOfProteinSet();
                }
                case DataboxRsmPSMOfPeptide: {
                    return new DataboxRsmPSMOfPeptide();
                }
                case DataboxXicProteinSet: {
                    return new DataboxXicProteinSet();
                }
                case DataboxXicPeptideSetShortList: {
                    return new DataboxXicPeptideSet(true);
                }
                case DataboxXicPeptideSet: {
                    return new DataboxXicPeptideSet();
                }
                case DataboxRsetMSDiag: {
                    return new DataBoxRsetMSDiag(null);
                }
                case DataboxXicPeptideIon: {
                    return new DataboxXicPeptideIon();
                }
                case DataboxGraphics: {
                    return new DataboxGraphics(false);
                }
                case DataboxXicChildFeature: {
                    return new DataboxChildFeature();
                }
                case DataboxMultiGraphics: {
                    return new DataboxMultiGraphics();
                }
                case DataboxMultiGraphicsDoubleYAxis: {
                    return new DataboxMultiGraphics(false, false, true);
                }
                case DataboxPSMOfMasterQuantPeptide: {
                    return new DataboxPSMOfMasterQuantPeptide();
                }
                case DataBoxMzScope: {
                    return new DataBoxMzScope();
                }
                case DataBoxAdjacencyMatrix: {
                    return new DataBoxAdjacencyMatrix();
                }
                case DataBoxAdjacencyMatrixChoice: {
                    return new DataBoxAdjacencyMatrixChoice();
                }
                case DataboxExperimentalDesign: {
                    return new DataboxExperimentalDesign();
                }
                case DataBoxMapAlignment: {
                    return new DataboxMapAlignment();
                }
                case DataBoxMSQueriesForRSM: {
                    return new DataBoxMSQueriesForRSM();
                }
                case DataBoxRSMPSMForMsQuery: {
                    return new DataBoxRsmPSMForMsQuery();
                }
                case DataBoxRsetPeptideSpectrumValues: {
                    return new DataBoxRsetPeptideSpectrumValues();
                }
                case DataBoxMSQueriesForRset: {
                    return new DataBoxMSQueriesForRset();
                }
                case DataBoxRsetPSMForMsQuery: {
                    return new DataboxRsetPSMForMsQuery();
                }
                case DataBoxDataAnalyzerResults: {
                    return new DataBoxDataAnalyzerResults();
                }
                case DataBoxImage: {
                    return new DataBoxImage();
                }
                case DataBoxSystemTasks: {
                    return new DataBoxSystemTasks();
                }
                case DataBoxPTMPeptides: {
                    return new DataBoxPTMPeptides(false, false);
                }
                case DataBoxXicPTMPeptides: {
                    return new DataBoxPTMPeptides(true, false);
                }
                case DataBoxPTMClusters: {
                    return new DataBoxPTMClusters();
                }
                case DataBoxFrozenCopy: {
                    return null;
                }
                case DataBoxPTMPeptidesMatches: {
                    return new DataBoxPTMPeptides(false, true);
                }
                case DataBoxXicPTMPeptidesMatches: {
                    return new DataBoxPTMPeptides(true, true);
                }
                case DataBoxPTMPeptidesGraphic: {
                    return new DataBoxPTMPeptidesGraphic();
                }
                case DataboxXicParentsPeptideIon: {
                    return new DataboxXicParentsPeptideIon();
                }
                case DataBoxPTMSiteAsClusters: {
                    return new DataBoxPTMClusters(true);
                }
                case DataBoxPTMClustersSites: {
                    return new DataBoxPTMClustersSites();
                }
                case DataBoxXicPTMClustersSites: {
                    return new DataBoxPTMClustersSites(true);
                }
            }
            return null;
        }

        private static HashMap<Integer, DataboxType> generateDataboxTypeMap() {
            DataboxType[] databoxTypeArray;
            HashMap<Integer, DataboxType> map = new HashMap<Integer, DataboxType>();
            for (DataboxType type : databoxTypeArray = DataboxType.values()) {
                map.put(type.m_type, type);
            }
            return map;
        }

        public static DataboxType getDataboxType(int type) {
            if (m_databoxTypeMap == null) {
                m_databoxTypeMap = DataboxType.generateDataboxTypeMap();
            }
            return m_databoxTypeMap.get(type);
        }

        static {
            m_databoxTypeMap = null;
        }
    }

    public static enum DataboxStyle {
        STYLE_XIC,
        STYLE_SC,
        STYLE_RSM,
        STYLE_RSET,
        STYLE_UNKNOWN;

    }
}

