/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.studio.WindowManager;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataboxManager;
import fr.proline.studio.rsmexplorer.gui.dialog.DataBoxChooserDialog;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddDataBoxActionListener
implements ActionListener {
    private final SplittedPanelContainer m_splittedPanel;
    private final AbstractDataBox m_previousDatabox;
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");

    public AddDataBoxActionListener(SplittedPanelContainer splittedPanel, AbstractDataBox previousDatabox) {
        this.m_splittedPanel = splittedPanel;
        this.m_previousDatabox = previousDatabox;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        DataBoxChooserDialog dialog = new DataBoxChooserDialog((Window)WindowManager.getDefault().getMainWindow(), this.m_previousDatabox, false, null);
        dialog.setLocationRelativeTo((Component)WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            AbstractDataBox genericDatabox = dialog.getSelectedDataBox();
            try {
                genericDatabox = DataboxManager.getDataboxNewInstance(genericDatabox);
            }
            catch (IllegalAccessException | InstantiationException e) {
                m_logger.error("Error creating new Databox ", (Throwable)e);
            }
            this.m_previousDatabox.addNextDataBox(genericDatabox);
            genericDatabox.createPanel();
            if (dialog.addBelow()) {
                this.m_splittedPanel.registerAddedPanel((JComponent)((JPanel)((Object)genericDatabox.getPanel())));
            } else if (dialog.addTabbed()) {
                this.m_splittedPanel.registerAddedPanelAsTab((JComponent)((JPanel)((Object)genericDatabox.getPanel())));
            } else {
                this.m_splittedPanel.registerAddedPanelAsSplitted((JComponent)((JPanel)((Object)genericDatabox.getPanel())));
            }
            final AbstractDataBox _genericDatabox = genericDatabox;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    _genericDatabox.dataChanged();
                }
            });
        }
    }
}

