/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.util.TransientDataInterface;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadMSQueriesTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.MsQueryInfoRsm;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.MSQueriesPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataBoxMSQueriesForRSM
extends AbstractDataBox {
    private ResultSummary m_rsm = null;
    private List<DMsQuery> m_msQueriesList = null;
    private Map<Long, Integer> m_nbPeptideMatchesByMsQueryIdMap;

    public DataBoxMSQueriesForRSM() {
        super(AbstractDataBox.DataboxType.DataBoxMSQueriesForRSM, AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = "MSQueries";
        this.m_description = "All MSQueries of an Identification Summary";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(ResultSummary.class);
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DMsQuery.class);
        outParameter.addParameter(ResultSummary.class);
        outParameter.addParameter(ResultSet.class);
        outParameter.addParameter(MsQueryInfoRsm.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        MSQueriesPanel p = new MSQueriesPanel(true);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        ResultSummary _rsm = this.m_rsm != null ? this.m_rsm : (ResultSummary)this.getData(ResultSummary.class);
        ResultSet _rset = _rsm != null ? _rsm.getResultSet() : (ResultSet)this.getData(ResultSet.class);
        this.linkCache((TransientDataInterface)_rsm);
        this.linkCache((TransientDataInterface)_rset);
        final int loadingId = this.setLoading();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (subTask == null) {
                    ((MSQueriesPanel)DataBoxMSQueriesForRSM.this.getDataBoxPanelInterface()).setData(taskId, DataBoxMSQueriesForRSM.this.m_msQueriesList, DataBoxMSQueriesForRSM.this.m_nbPeptideMatchesByMsQueryIdMap, finished);
                } else {
                    ((MSQueriesPanel)DataBoxMSQueriesForRSM.this.getDataBoxPanelInterface()).dataUpdated(subTask, finished);
                }
                DataBoxMSQueriesForRSM.this.setLoaded(loadingId);
                if (finished) {
                    DataBoxMSQueriesForRSM.this.unregisterTask(taskId);
                }
            }
        };
        this.m_msQueriesList = new ArrayList<DMsQuery>();
        this.m_nbPeptideMatchesByMsQueryIdMap = new HashMap<Long, Integer>();
        DatabaseLoadMSQueriesTask task = new DatabaseLoadMSQueriesTask(callback);
        task.initLoadMSQueries(this.getProjectId(), _rset, this.m_msQueriesList, this.m_nbPeptideMatchesByMsQueryIdMap);
        this.registerTask((AbstractDatabaseTask)task);
    }

    @Override
    public void setEntryData(Object data) {
        this.getDataBoxPanelInterface().addSingleValue(data);
        if (data instanceof ResultSummary) {
            this.m_rsm = (ResultSummary)data;
            this.dataChanged();
        }
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            if (parameterType.equals(DMsQuery.class)) {
                return ((MSQueriesPanel)this.getDataBoxPanelInterface()).getSelectedMsQuery();
            }
            if (parameterType.equals(ResultSummary.class)) {
                return this.m_rsm;
            }
            if (parameterType.equals(ResultSet.class)) {
                return this.m_rsm.getResultSet();
            }
            if (parameterType.equals(MsQueryInfoRsm.class)) {
                DMsQuery msq = ((MSQueriesPanel)this.getDataBoxPanelInterface()).getSelectedMsQuery();
                return new MsQueryInfoRsm(msq, this.m_rsm);
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        Class[] classList = new Class[]{DMsQuery.class, MsQueryInfoRsm.class};
        return classList;
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        DMsQuery q = (DMsQuery)this.getData(DMsQuery.class);
        if (q != null) {
            int id = q.getInitialId();
            return String.valueOf(id);
        }
        return null;
    }
}

