/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.dto.DMasterQuantProteinSet;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMDatasetPair;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.PTMClustersPanel;
import fr.proline.studio.rsmexplorer.gui.xic.QuantChannelInfo;
import fr.proline.studio.types.XicMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataBoxPTMClustersSites
extends AbstractDataBox {
    private final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.ptm");
    private PTMDatasetPair m_currentPtmDs;
    private ArrayList<PTMCluster> m_clusters;
    private QuantChannelInfo m_quantChannelInfo;
    private boolean m_isXicResult;

    public DataBoxPTMClustersSites() {
        this(false);
    }

    public DataBoxPTMClustersSites(boolean isXICResult) {
        super(isXICResult ? AbstractDataBox.DataboxType.DataBoxXicPTMClustersSites : AbstractDataBox.DataboxType.DataBoxPTMClustersSites, isXICResult ? AbstractDataBox.DataboxStyle.STYLE_XIC : AbstractDataBox.DataboxStyle.STYLE_RSM);
        this.m_typeName = isXICResult ? "Quantitation Clusters PTMs Sites" : "Clusters PTMs Sites";
        this.m_description = isXICResult ? "Quantitation Modification Sites of Clusters" : "Modification Sites of Clusters";
        this.m_isXicResult = isXICResult;
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(PTMCluster.class, ParameterSubtypeEnum.LIST_DATA);
        inParameter.addParameter(PTMDatasetPair.class);
        if (this.m_isXicResult) {
            inParameter.addParameter(QuantChannelInfo.class);
        }
        this.registerInParameter(inParameter);
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(PTMPeptideInstance.class, ParameterSubtypeEnum.LEAF_PTMPeptideInstance);
        outParameter.addParameter(PTMPeptideInstance.class, ParameterSubtypeEnum.PARENT_PTMPeptideInstance);
        outParameter.addParameter(DProteinMatch.class);
        outParameter.addParameter(DPeptideMatch.class);
        outParameter.addParameter(PTMCluster.class, ParameterSubtypeEnum.LIST_DATA);
        outParameter.addParameter(ExtendedTableModelInterface.class);
        outParameter.addParameter(CrossSelectionInterface.class);
        this.registerOutParameter(outParameter);
        if (this.m_isXicResult) {
            this.registerXicOutParameter();
        }
    }

    private boolean isXicResult() {
        return this.m_isXicResult;
    }

    private void registerXicOutParameter() {
        ParameterList outParameter = new ParameterList();
        outParameter.addParameter(DMasterQuantProteinSet.class);
        outParameter.addParameter(DProteinSet.class);
        outParameter.addParameter(QuantChannelInfo.class);
        this.registerOutParameter(outParameter);
    }

    @Override
    public void createPanel() {
        PTMClustersPanel p = new PTMClustersPanel(false);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        this.m_currentPtmDs = (PTMDatasetPair)this.m_previousDataBox.getData(PTMDatasetPair.class);
        List newClusters = (List)this.m_previousDataBox.getData(PTMCluster.class, ParameterSubtypeEnum.LIST_DATA);
        if (newClusters == null || newClusters.isEmpty()) {
            this.m_clusters = null;
            ((PTMClustersPanel)this.getDataBoxPanelInterface()).setData(null, this.m_clusters, true);
            this.m_logger.debug("No PTM Clusters'Site to display. ");
            return;
        }
        this.m_clusters = new ArrayList();
        if (this.m_isXicResult) {
            this.m_quantChannelInfo = (QuantChannelInfo)this.m_previousDataBox.getData(QuantChannelInfo.class);
            this.getDataBoxPanelInterface().addSingleValue(this.m_quantChannelInfo);
        }
        PTMDataset siteDS = this.m_currentPtmDs.getSitePTMDataset();
        for (PTMCluster c : newClusters) {
            c.getPTMSites().forEach(site -> {
                PTMCluster siteCluster = siteDS.getPTMCluster(site.getId());
                if (siteCluster != null && !this.m_clusters.contains(siteCluster)) {
                    this.m_clusters.add(siteCluster);
                }
            });
        }
        ((PTMClustersPanel)this.getDataBoxPanelInterface()).setData(null, this.m_clusters, true);
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null) {
            if (parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
                PTMCluster cluster2;
                if (parameterType.equals(DProteinMatch.class) && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null) {
                    return cluster2.getProteinMatch();
                }
                if (parameterType.equals(DPeptideMatch.class) && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null) {
                    return cluster2.getRepresentativePepMatch();
                }
                if (parameterType.equals(DMasterQuantProteinSet.class) && this.isXicResult() && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null) {
                    return cluster2.getMasterQuantProteinSet();
                }
                if (parameterType.equals(DProteinSet.class) && this.isXicResult() && (cluster2 = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster()) != null && cluster2.getMasterQuantProteinSet() != null) {
                    return cluster2.getMasterQuantProteinSet().getProteinSet();
                }
                if (parameterType.equals(QuantChannelInfo.class) && this.isXicResult()) {
                    return this.m_quantChannelInfo;
                }
                if (parameterType.equals(ExtendedTableModelInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getGlobalTableModelInterface();
                }
                if (parameterType.equals(CrossSelectionInterface.class)) {
                    return ((GlobalTabelModelProviderInterface)this.getDataBoxPanelInterface()).getCrossSelectionInterface();
                }
                if (parameterType.equals(XicMode.class) && this.m_currentPtmDs.getClusterPTMDataset().isQuantitation()) {
                    return new XicMode(true);
                }
            }
            if (parameterSubtype == ParameterSubtypeEnum.LIST_DATA && parameterType.equals(PTMCluster.class)) {
                return ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedPTMClusters();
            }
            if (parameterType.equals(PTMPeptideInstance.class) && (parameterSubtype.equals((Object)ParameterSubtypeEnum.PARENT_PTMPeptideInstance) || parameterSubtype.equals((Object)ParameterSubtypeEnum.LEAF_PTMPeptideInstance))) {
                boolean parentPTMPeptideInstance = parameterSubtype.equals((Object)ParameterSubtypeEnum.PARENT_PTMPeptideInstance);
                List<PTMCluster> clusters = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedPTMClusters();
                ArrayList ptmPeptideInstances = new ArrayList();
                if (!clusters.isEmpty()) {
                    Collections.sort(clusters);
                    Long protMatchId = ((PTMClustersPanel)this.getDataBoxPanelInterface()).getSelectedProteinPTMCluster().getProteinMatch().getId();
                    clusters.stream().filter(cluster -> protMatchId.equals(cluster.getProteinMatch().getId())).forEach(cluster -> ptmPeptideInstances.addAll(parentPTMPeptideInstance ? cluster.getParentPTMPeptideInstances() : cluster.getLeafPTMPeptideInstances()));
                }
                return ptmPeptideInstances;
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }

    @Override
    public Class[] getDataboxNavigationOutParameterClasses() {
        if (this.isXicResult()) {
            return new Class[]{DProteinMatch.class, DMasterQuantProteinSet.class};
        }
        return new Class[]{DProteinMatch.class};
    }

    @Override
    public String getDataboxNavigationDisplayValue() {
        DProteinMatch p = (DProteinMatch)this.getData(DProteinMatch.class);
        if (p != null) {
            return p.getAccession();
        }
        return null;
    }
}

