/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.dto.DMsQuery;
import fr.proline.core.orm.msi.dto.DPeptideMatch;
import fr.proline.core.orm.msi.dto.DSpectrum;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseLoadSpectrumsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataBoxRsetPeptideSpectrum;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.rsmexplorer.gui.spectrum.PeptideFragmentationData;
import fr.proline.studio.rsmexplorer.gui.spectrum.RsetPeptideSpectrumValuesPanel;

public class DataBoxRsetPeptideSpectrumValues
extends AbstractDataBox {
    private DPeptideMatch m_previousPeptideMatch = null;
    private Long m_previousTaskId = null;

    public DataBoxRsetPeptideSpectrumValues() {
        super(AbstractDataBox.DataboxType.DataBoxRsetPeptideSpectrumValues, AbstractDataBox.DataboxStyle.STYLE_RSET);
        this.m_typeName = "Spectrum Values";
        this.m_description = "Spectrum Values of a Peptide";
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(DPeptideMatch.class);
        inParameter.addParameter(PeptideFragmentationData.class, false);
        this.registerInParameter(inParameter);
    }

    @Override
    public void createPanel() {
        RsetPeptideSpectrumValuesPanel p = new RsetPeptideSpectrumValuesPanel();
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        DPeptideMatch peptideMatch;
        DPeptideMatch peptideMatchData = (DPeptideMatch)this.getData(DPeptideMatch.class);
        PeptideFragmentationData fragmentationData = (PeptideFragmentationData)this.getData(PeptideFragmentationData.class);
        DPeptideMatch dPeptideMatch = peptideMatch = fragmentationData != null ? fragmentationData.getPeptideMatch() : peptideMatchData;
        if (this.m_previousPeptideMatch == peptideMatch && fragmentationData == null) {
            return;
        }
        this.m_previousPeptideMatch = peptideMatch;
        if (peptideMatch == null) {
            ((RsetPeptideSpectrumValuesPanel)this.getDataBoxPanelInterface()).setData(null);
            return;
        }
        boolean needToLoadData = true;
        if (needToLoadData) {
            AbstractDataBox previousBox = this.m_previousDataBox;
            while (previousBox != null) {
                if (previousBox instanceof DataBoxRsetPeptideSpectrum) {
                    needToLoadData = false;
                    break;
                }
                previousBox = previousBox.m_previousDataBox;
            }
        }
        boolean bl = needToLoadData = !peptideMatch.isMsQuerySet() || !peptideMatch.getMsQuery().isSpectrumFullySet();
        if (needToLoadData) {
            final int loadingId = this.setLoading();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    ((RsetPeptideSpectrumValuesPanel)DataBoxRsetPeptideSpectrumValues.this.getDataBoxPanelInterface()).setData(peptideMatch);
                    DataBoxRsetPeptideSpectrumValues.this.setLoaded(loadingId);
                    if (finished) {
                        DataBoxRsetPeptideSpectrumValues.this.unregisterTask(taskId);
                    }
                }
            };
            DatabaseLoadSpectrumsTask task = new DatabaseLoadSpectrumsTask(callback, this.getProjectId(), peptideMatch);
            Long taskId = task.getId();
            if (this.m_previousTaskId != null) {
                AccessDatabaseThread.getAccessDatabaseThread().abortTask(this.m_previousTaskId);
            }
            this.m_previousTaskId = taskId;
            this.registerTask((AbstractDatabaseTask)task);
        } else {
            ((RsetPeptideSpectrumValuesPanel)this.getDataBoxPanelInterface()).setData(peptideMatch);
        }
    }

    @Override
    public Object getDataImpl(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        if (parameterType != null && parameterSubtype == ParameterSubtypeEnum.SINGLE_DATA) {
            DSpectrum spectrum;
            DMsQuery msQuery;
            DPeptideMatch peptideMatch;
            if (parameterType.equals(DMsQuery.class) && (peptideMatch = (DPeptideMatch)this.getData(DPeptideMatch.class)) != null && (msQuery = peptideMatch.getMsQuery()) != null) {
                return msQuery;
            }
            if (parameterType.equals(DSpectrum.class) && (peptideMatch = (DPeptideMatch)this.getData(DPeptideMatch.class)) != null && (msQuery = peptideMatch.getMsQuery()) != null && (spectrum = msQuery.getDSpectrum()) != null) {
                return spectrum;
            }
        }
        return super.getDataImpl(parameterType, parameterSubtype);
    }
}

