/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.pattern;

import fr.proline.core.orm.msi.dto.DMasterQuantPeptide;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.SecondAxisTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.pattern.extradata.GraphicExtraData;
import fr.proline.studio.rsmexplorer.gui.MultiGraphicsPanel;
import fr.proline.studio.rsmexplorer.gui.xic.XICComparePeptideTableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataboxMultiGraphics
extends AbstractDataBox {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private List<ExtendedTableModelInterface> m_plotValues = null;
    private SecondAxisTableModelInterface m_plotSecondAxisValues = null;
    private List<CrossSelectionInterface> m_crossSelectionValues = null;
    private boolean m_defaultLocked = false;
    private boolean m_canChooseColor = false;
    private boolean m_displayDoubleYAxis = false;
    private boolean m_hideSelection = false;
    private ArrayList<Integer> m_selectedIndexList;
    private boolean m_setHideButton;

    public DataboxMultiGraphics() {
        this(false, false, false);
    }

    public DataboxMultiGraphics(boolean defaultLocked, boolean canChooseColor) {
        this(defaultLocked, canChooseColor, false);
    }

    public DataboxMultiGraphics(boolean defaultLocked, boolean canChooseColor, boolean displayDoubleYAxis) {
        super(displayDoubleYAxis ? AbstractDataBox.DataboxType.DataboxMultiGraphicsDoubleYAxis : AbstractDataBox.DataboxType.DataboxMultiGraphics, AbstractDataBox.DataboxStyle.STYLE_UNKNOWN);
        this.m_defaultLocked = defaultLocked;
        this.m_canChooseColor = canChooseColor;
        this.m_displayDoubleYAxis = displayDoubleYAxis;
        if (this.m_displayDoubleYAxis) {
            this.m_typeName = "Graphic Linear Plot (two axis)";
            this.m_description = "Display two sets of data as linear plot using 2 axis";
        } else {
            this.m_typeName = "Graphic Linear Plot";
            this.m_description = "Display data as linear plot";
        }
        ParameterList inParameter = new ParameterList();
        inParameter.addParameter(Integer.class, ParameterSubtypeEnum.PEPTIDES_SELECTION_LIST, false);
        inParameter.addParameter(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
        inParameter.addParameter(CrossSelectionInterface.class, ParameterSubtypeEnum.LIST_DATA, false);
        if (this.m_displayDoubleYAxis) {
            inParameter.addParameter(SecondAxisTableModelInterface.class);
            inParameter.addParameter(PTMPeptideInstance.class, false);
            inParameter.addParameter(DMasterQuantPeptide.class, false);
        }
        this.registerInParameter(inParameter);
        this.m_setHideButton = false;
    }

    protected void setHideButton(boolean h) {
        this.m_setHideButton = h;
    }

    protected boolean isDoubleYAxis() {
        return this.m_displayDoubleYAxis;
    }

    @Override
    public void createPanel() {
        MultiGraphicsPanel p = new MultiGraphicsPanel(this.m_defaultLocked, this.m_canChooseColor, this.m_displayDoubleYAxis, this.m_setHideButton);
        p.setName(this.m_typeName);
        p.setDataBox(this);
        this.setDataBoxPanelInterface(p);
    }

    @Override
    public void dataChanged() {
        boolean valueUnchanged;
        List dataModelInterfaceSet1 = (List)this.getData(ExtendedTableModelInterface.class, ParameterSubtypeEnum.LIST_DATA);
        if (dataModelInterfaceSet1 != null && !dataModelInterfaceSet1.isEmpty() && dataModelInterfaceSet1.get(0) instanceof XICComparePeptideTableModel) {
            this.m_selectedIndexList = (ArrayList)this.getData(Integer.class, ParameterSubtypeEnum.PEPTIDES_SELECTION_LIST);
            if (!this.m_hideSelection && this.m_selectedIndexList != null && !this.m_selectedIndexList.isEmpty()) {
                for (int i = 0; i < dataModelInterfaceSet1.size(); ++i) {
                    XICComparePeptideTableModel data = (XICComparePeptideTableModel)dataModelInterfaceSet1.get(i);
                    if (!this.m_selectedIndexList.contains(i)) continue;
                    data.setSelected(true);
                }
            }
        }
        GraphicExtraData extraData = (GraphicExtraData)this.m_previousDataBox.getExtraData(ExtendedTableModelInterface.class);
        Boolean keepZoom = Boolean.FALSE;
        Double limitMinAxisY = null;
        if (extraData != null) {
            keepZoom = extraData.getKeepZoom();
            if (keepZoom == null) {
                keepZoom = Boolean.FALSE;
            }
            limitMinAxisY = extraData.getLimitMinY();
        }
        List crossSelectionInterfaceL = (List)this.getData(CrossSelectionInterface.class, ParameterSubtypeEnum.LIST_DATA);
        SecondAxisTableModelInterface dataModelInterfaceSet2 = this.m_displayDoubleYAxis ? (SecondAxisTableModelInterface)this.getData(SecondAxisTableModelInterface.class) : null;
        boolean bl = valueUnchanged = Objects.equals(dataModelInterfaceSet1, this.m_plotValues) && Objects.equals(crossSelectionInterfaceL, this.m_crossSelectionValues) && Objects.equals(dataModelInterfaceSet2, this.m_plotSecondAxisValues);
        if (valueUnchanged) {
            return;
        }
        this.m_plotValues = dataModelInterfaceSet1;
        this.m_crossSelectionValues = crossSelectionInterfaceL;
        this.m_plotSecondAxisValues = dataModelInterfaceSet2;
        if (this.m_plotValues != null) {
            ((MultiGraphicsPanel)this.getDataBoxPanelInterface()).setData(this.m_plotValues, this.m_crossSelectionValues, this.m_plotSecondAxisValues, keepZoom, limitMinAxisY);
        }
    }

    @Override
    public void setEntryData(Object data) {
        this.m_plotValues = (List)data;
        ((MultiGraphicsPanel)this.getDataBoxPanelInterface()).setData(this.m_plotValues, null);
    }

    public void hideSelection(boolean hide) {
        this.m_hideSelection = hide;
        if (this.m_plotValues != null && !this.m_plotValues.isEmpty() && this.m_plotValues.get(0) instanceof XICComparePeptideTableModel && this.m_selectedIndexList != null && !this.m_selectedIndexList.isEmpty()) {
            for (int i = 0; i < this.m_plotValues.size(); ++i) {
                XICComparePeptideTableModel data = (XICComparePeptideTableModel)this.m_plotValues.get(i);
                if (!this.m_selectedIndexList.contains(i)) continue;
                data.setSelected(!hide);
            }
        }
        ((MultiGraphicsPanel)this.getDataBoxPanelInterface()).setData(this.m_plotValues, this.m_crossSelectionValues, this.m_plotSecondAxisValues, false, null);
    }
}

