/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer;

import fr.proline.studio.WindowManager;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import java.util.ArrayList;
import java.util.HashSet;

public class DataBoxViewerManager {
    public static final String MODIFIED_TITLE_SUFFIX = "***";

    public static void loadedDataModified(long projectId, Long rsetId, Long rsmId, Class c, ArrayList modificationsList, byte reason) {
        HashSet tcs = WindowManager.getDefault().getMainWindow().getTopPanels();
        for (AbstractTopPanel topComponent : tcs) {
            DataBoxViewerTopPanel databoxViewerTP;
            long pId;
            if (!(topComponent instanceof DataBoxViewerTopPanel) || (pId = (databoxViewerTP = (DataBoxViewerTopPanel)topComponent).getProjectId()) != projectId) continue;
            databoxViewerTP.loadedDataModified(rsetId, rsmId, c, modificationsList, reason);
        }
    }

    public static enum REASON_MODIF {
        REASON_CHANGE_TITLE(0, false),
        REASON_PEPTIDE_SUPPRESSED(1, true),
        REASON_PROTEINS_REFINED(2, false),
        REASON_PTMCLUSTER_MERGED(4, true),
        REASON_PTMCLUSTER_MODIFIED(8, true),
        REASON_PTMDATASET_SAVED(16, false);

        private byte m_reasonValue;
        private boolean m_shouldSave;

        private REASON_MODIF(byte reasonValue, boolean shouldSave) {
            this.m_reasonValue = reasonValue;
            this.m_shouldSave = shouldSave;
        }

        public byte getReasonValue() {
            return this.m_reasonValue;
        }

        public static REASON_MODIF getReasonModifFor(byte value) {
            REASON_MODIF[] allVals;
            for (REASON_MODIF allVal : allVals = REASON_MODIF.values()) {
                if (allVal == REASON_CHANGE_TITLE || !REASON_MODIF.isReasonDefine(allVal, value)) continue;
                return allVal;
            }
            return null;
        }

        public boolean shouldBeSaved() {
            return this.m_shouldSave;
        }

        public static boolean isReasonDefine(REASON_MODIF reason, byte value) {
            return (reason.getReasonValue() & value) == reason.getReasonValue();
        }
    }
}

