/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer;

import fr.proline.studio.WindowManager;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.dock.container.DockComponent;
import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.rsmexplorer.DataBoxViewerManager;
import fr.proline.studio.table.TableInfo;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class DataBoxViewerTopPanel
extends AbstractTopPanel {
    private WindowBox m_windowBox;
    private boolean firstPaint = true;

    public DataBoxViewerTopPanel(WindowBox windowBox) {
        this.m_windowBox = windowBox;
        this.setLayout(new GridLayout());
        this.add(windowBox.getPanel());
        this.setName(windowBox.getName());
        this.setToolTipText(windowBox.getName());
    }

    public WindowBox getWindowBox() {
        return this.m_windowBox;
    }

    public void retrieveTableModels(ArrayList<TableInfo> list) {
        this.m_windowBox.retrieveTableModels(list);
    }

    public Action[] getActions(final DockComponent component) {
        ArrayList<Action> actionList;
        Action[] actions = super.getActions(component);
        AbstractAction renameAction = new AbstractAction("Rename..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionDialog dialog = new OptionDialog((Window)WindowManager.getDefault().getMainWindow(), "Rename", null, "New Name", OptionDialog.OptionDialogType.TEXTFIELD);
                dialog.setText(DataBoxViewerTopPanel.this.getName());
                dialog.setVisible(true);
                String newName = null;
                if (dialog.getButtonClicked() == 0) {
                    newName = dialog.getText();
                }
                if (newName != null && newName.length() > 0) {
                    DataBoxViewerTopPanel.this.setName(newName);
                    component.setTitle(newName);
                    DataBoxViewerTopPanel.this.m_windowBox.getEntryBox().setUserName(newName);
                }
            }
        };
        if (actions == null) {
            actionList = new ArrayList<Action>(2);
            actionList.add(renameAction);
        } else {
            actionList = new ArrayList(actions.length + 2);
            actionList.add(renameAction);
            actionList.add(null);
            for (Action a : actions) {
                actionList.add(a);
            }
        }
        return actionList.toArray(new Action[0]);
    }

    protected void componentOpened() {
        this.m_windowBox.windowOpened();
    }

    public boolean warnBeforeClosing() {
        return !this.m_windowBox.getEntryBox().isClosable();
    }

    public String getWarnClosingMessage() {
        return this.m_windowBox.getEntryBox().getClosingWarningMessage();
    }

    public void componentClosed() {
        this.m_windowBox.windowClosed();
    }

    public Image getIcon() {
        return this.m_windowBox.getIcon();
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.firstPaint) {
            this.firstPaint = false;
            this.m_windowBox.resetDefaultSize();
        }
    }

    public ParameterList getInParameters() {
        return this.m_windowBox.getEntryBox().getInParameters();
    }

    public ParameterList getOutParameters() {
        return this.m_windowBox.getEntryBox().getOutParameters();
    }

    public Object getData(Class parameterType) {
        return this.getData(parameterType, ParameterSubtypeEnum.SINGLE_DATA);
    }

    public Object getData(Class parameterType, ParameterSubtypeEnum parameterSubtype) {
        return this.m_windowBox.getEntryBox().getData(parameterType, parameterSubtype);
    }

    public long getProjectId() {
        return this.m_windowBox.getEntryBox().getProjectId();
    }

    public void loadedDataModified(Long rsetId, Long rsmId, Class c, ArrayList modificationsList, byte reason) {
        if (this.m_windowBox.getEntryBox().isDataOfInterest(rsetId, rsmId, c)) {
            if (reason == DataBoxViewerManager.REASON_MODIF.REASON_CHANGE_TITLE.getReasonValue()) {
                String title = (String)modificationsList.get(0);
                this.setName(title);
                this.fireTopPanelPropertyChange("TITLE");
            } else {
                DataBoxViewerManager.REASON_MODIF reasonModif = DataBoxViewerManager.REASON_MODIF.getReasonModifFor(reason);
                if (reasonModif != null && reasonModif.shouldBeSaved()) {
                    String title = this.getName();
                    if (!title.endsWith("***")) {
                        title = title + " " + "***";
                    }
                    this.setName(title);
                    this.fireTopPanelPropertyChange("TITLE");
                } else {
                    String title = this.getName();
                    if (title.endsWith("***")) {
                        title = title.substring(0, title.lastIndexOf("***") - 1);
                    }
                    this.setName(title);
                    this.fireTopPanelPropertyChange("TITLE");
                }
                this.m_windowBox.getEntryBox().loadedDataModified(rsetId, rsmId, c, modificationsList, reason);
            }
        }
        this.repaint();
    }

    public String getTopPanelIdentifierKey() {
        return null;
    }

    public String getTitle() {
        return this.getName();
    }
}

