/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.data.ptm.JSONPTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportPTMDatasetAction
extends AbstractRSMAction {
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer.ExportFastaAction");

    public ExportPTMDatasetAction(AbstractTree tree) {
        super("PTM Dataset", tree);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        DataSetNode dataSetNode = (DataSetNode)selectedNodes[0];
        if (dataSetNode.isChanging() || dataSetNode.isFolder()) {
            this.setEnabled(false);
            return;
        }
        if (!dataSetNode.hasResultSet() || !dataSetNode.hasResultSummary()) {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        DDataset dataSet = ((DataSetData)selectedNodes[0].getData()).getDataset();
        PTMDataset ptmDataset = DatabaseDataManager.getDatabaseDataManager().getClustersPTMDatasetForDS(Long.valueOf(dataSet.getId()));
        if (ptmDataset == null) {
            ptmDataset = DatabaseDataManager.getDatabaseDataManager().getSitesPTMDatasetForDS(Long.valueOf(dataSet.getId()));
        }
        if (ptmDataset != null) {
            this.exportPTMDataset(ptmDataset);
        } else {
            JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), "PTM Dataset not loaded yet ! Display it to load data...", "PTM Cluster Loading Error", 0);
        }
    }

    private void exportPTMDataset(PTMDataset ptmDataset) {
        try {
            JSONPTMDataset jsonPTMDataset = ptmDataset.createJSONPTMDataset();
            if (jsonPTMDataset == null) {
                return;
            }
            String ptmFileName = ptmDataset.getDataset().getName().trim();
            File ptmFile = new File("./" + ptmFileName + ".json");
            FileWriter writer = new FileWriter(ptmFile);
            Gson gson = new GsonBuilder().serializeNulls().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
            String jsonString = gson.toJson((Object)jsonPTMDataset);
            writer.write(jsonString);
            writer.flush();
            writer.close();
        }
        catch (IOException | IllegalAccessException e) {
            JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), e.getMessage(), "PTM Cluster Loading Error", 0);
            e.printStackTrace();
        }
        JOptionPane.showMessageDialog((Component)WindowManager.getDefault().getMainWindow(), "Export PTM DS with " + ptmDataset.getPTMClusters().size() + " clusters ", "PTM Cluster Loading Error", 0);
    }
}

