/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.AddAggregateDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdProjectIdentificationNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.tree.DefaultTreeModel;

public class AggregateAction
extends AbstractRSMAction {
    public AggregateAction(AbstractTree tree) {
        super("Add Dataset...", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        AddAggregateDialog dialog = AddAggregateDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            String name = dialog.getAggregateName();
            int nbAggregates = dialog.getNbAggregates();
            Aggregation.ChildNature aggregateType = dialog.getAggregateType();
            for (AbstractNode n : selectedNodes) {
                boolean isParentAProject = n.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION;
                int suffixNumber = 0;
                int nbChildren = n.getChildCount();
                for (int i = 0; i < nbChildren; ++i) {
                    AbstractNode child = (AbstractNode)n.getChildAt(i);
                    String childName = child.toString();
                    if (!childName.startsWith(name)) continue;
                    String suffix = childName.substring(name.length());
                    try {
                        int number = Integer.parseInt(suffix);
                        if (number <= suffixNumber) continue;
                        suffixNumber = number;
                        continue;
                    }
                    catch (NumberFormatException number) {
                        // empty catch block
                    }
                }
                if (suffixNumber == 0 && nbAggregates > 1) {
                    suffixNumber = 1;
                } else if (suffixNumber > 0) {
                    // empty if block
                }
                int suffixStart = ++suffixNumber;
                final ArrayList<DataSetNode> nodesCreated = new ArrayList<DataSetNode>();
                IdentificationTree tree = IdentificationTree.getCurrentTree();
                final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                for (int i = 0; i < nbAggregates; ++i) {
                    String aggregateName = name;
                    if (suffixNumber > 0) {
                        aggregateName = aggregateName + suffixNumber;
                        ++suffixNumber;
                    }
                    DataSetNode datasetNode = new DataSetNode((AbstractData)DataSetData.createTemporaryAggregate((String)aggregateName));
                    nodesCreated.add(datasetNode);
                    datasetNode.setIsChanging(true);
                    if (isParentAProject) {
                        n.insert(datasetNode, n.getChildCount() - 1);
                        continue;
                    }
                    n.add(datasetNode);
                }
                treeModel.nodeStructureChanged(n);
                tree.expandNodeIfNeeded(n);
                Project project = null;
                DDataset parentDataset = null;
                DataSetNode parentDatasetNode = null;
                if (n.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
                    project = ((IdProjectIdentificationNode)n).getProject();
                    parentDataset = null;
                } else if (n.getType() == AbstractNode.NodeTypes.DATA_SET) {
                    parentDatasetNode = (DataSetNode)n;
                    parentDataset = parentDatasetNode.getDataset();
                    project = parentDataset.getProject();
                }
                final ArrayList createdDatasetList = new ArrayList();
                AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                    public boolean mustBeCalledInAWT() {
                        return true;
                    }

                    public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                        if (!success) {
                            return;
                        }
                        int nbNodes = nodesCreated.size();
                        for (int i = 0; i < nbNodes; ++i) {
                            DataSetNode datasetNode = (DataSetNode)nodesCreated.get(i);
                            DDataset dataset = (DDataset)createdDatasetList.get(i);
                            datasetNode.setIsChanging(false);
                            ((DataSetData)datasetNode.getData()).setDataset(dataset);
                            treeModel.nodeChanged(datasetNode);
                        }
                    }
                };
                DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
                task.initCreateDatasetAggregate(project, parentDataset, aggregateType, name, suffixNumber > 0, suffixStart, suffixStart + nbAggregates - 1, createdDatasetList);
                AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
            }
        }
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes == 0) {
            this.setEnabled(false);
            return;
        }
        for (int i = 0; i < nbSelectedNodes; ++i) {
            AbstractNode node = selectedNodes[i];
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION || node.getType() != AbstractNode.NodeTypes.DATA_SET) continue;
            DDataset d = ((DataSetNode)node).getDataset();
            if (!d.isAggregation() && !d.isFolder()) {
                this.setEnabled(false);
                return;
            }
            if (!((DataSetNode)node).hasResultSet() && !((DataSetNode)node).hasResultSummary()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

