/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.data.DatasetToCopy;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;

public class CopySearchResult
extends AbstractRSMAction {
    public CopySearchResult(AbstractTree tree) {
        super("Copy Search Result", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        final DataSetNode node = (DataSetNode)selectedNodes[0];
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                DatasetToCopy copy = CopySearchResult.this.createCopy(node);
                DatasetToCopy.saveDatasetCopied((DatasetToCopy)copy);
            }
        };
        IdentificationTree.getCurrentTree().loadNode(node, callback, true);
    }

    private DatasetToCopy createCopy(DataSetNode node) {
        int nbChildren;
        DDataset dataset = ((DataSetData)node.getData()).getDataset();
        long projectId = dataset.getProject().getId();
        Long resultSetId = dataset.getResultSetId();
        DatasetToCopy copy = new DatasetToCopy();
        copy.setProjectId(projectId);
        copy.setName(dataset.getName());
        Aggregation aggregation = dataset.getAggregation();
        if (aggregation != null) {
            copy.setDatasetType(aggregation.getChildNature());
        }
        if ((nbChildren = node.getChildCount()) == 0) {
            copy.setResultSetId(resultSetId);
        }
        for (int childIndex = 0; childIndex < nbChildren; ++childIndex) {
            DataSetNode child = (DataSetNode)node.getChildAt(childIndex);
            copy.addChild(this.createCopy(child));
        }
        return copy;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        if (selectedNodes.length > 1) {
            this.setEnabled(false);
            return;
        }
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        int nbSelectedNodes = selectedNodes.length;
        for (int i = 0; i < nbSelectedNodes; ++i) {
            AbstractNode node = selectedNodes[i];
            if (!node.canBeDeleted()) {
                this.setEnabled(false);
                return;
            }
            if (!(selectedNodes[i] instanceof DataSetNode)) {
                this.setEnabled(false);
                return;
            }
            if (!((DataSetNode)selectedNodes[i]).isFolder()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

