/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Aggregation;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.CertifyIdentificationTask;
import fr.proline.studio.dpm.task.jms.ImportIdentificationTask;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.actions.identification.ImportManager;
import fr.proline.studio.rsmexplorer.actions.identification.ImportSearchResultAsRsetJMSAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.ImportIdentificationDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdProjectIdentificationNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.tree.DefaultTreeModel;

public class ImportSearchResultAsDatasetJMSAction
extends AbstractRSMAction {
    private static final String GENERAL_APPLICATION_SETTINGS = "General Application Settings";

    public ImportSearchResultAsDatasetJMSAction(AbstractTree tree) {
        super("Import Search Result...", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        AbstractNode n = selectedNodes[0];
        long projectId = 0L;
        if (n.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
            IdProjectIdentificationNode projectNode = (IdProjectIdentificationNode)n;
            projectId = projectNode.getProject().getId();
        } else if (n.getType() == AbstractNode.NodeTypes.DATA_SET) {
            DataSetNode dataSetNode = (DataSetNode)n;
            projectId = dataSetNode.getDataset().getProject().getId();
        }
        ImportIdentificationDialog dialog = ImportIdentificationDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            File[] filePaths = dialog.getFilePaths();
            final HashMap<String, String> parserArguments = dialog.getParserArguments();
            Project project = null;
            DDataset parentDataset = null;
            boolean isParentAProject = false;
            if (n.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
                IdProjectIdentificationNode projectNode = (IdProjectIdentificationNode)n;
                project = projectNode.getProject();
                isParentAProject = true;
            } else if (n.getType() == AbstractNode.NodeTypes.DATA_SET) {
                DataSetNode dataSetNode = (DataSetNode)n;
                project = dataSetNode.getDataset().getProject();
                parentDataset = dataSetNode.getDataset();
            }
            final Project _project = project;
            final DDataset _parentDataset = parentDataset;
            final String parserId = dialog.getParserId();
            final String decoyRegex = dialog.getDecoyRegex();
            final long instrumentId = dialog.getInstrumentId();
            final long peaklistSoftwareId = dialog.getPeaklistSoftwareId();
            final long fragRuleSetId = dialog.getFragmentationRuleSetId();
            IdentificationTree tree = IdentificationTree.getCurrentTree();
            final ArrayList<DataSetNode> allIdentificationNodes = new ArrayList<DataSetNode>();
            final ArrayList<String> allDatasetNames = new ArrayList<String>();
            final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            final int nbFiles = filePaths.length;
            for (int i = 0; i < nbFiles; ++i) {
                File f = filePaths[i];
                String datasetName = f.getName();
                int indexOfDot = datasetName.lastIndexOf(46);
                if (indexOfDot != -1) {
                    datasetName = datasetName.substring(0, indexOfDot);
                }
                allDatasetNames.add(datasetName);
                DataSetData identificationData = DataSetData.createTemporaryIdentification((String)datasetName);
                DataSetNode identificationNode = new DataSetNode((AbstractData)identificationData);
                identificationNode.setIsChanging(true);
                allIdentificationNodes.add(identificationNode);
                if (isParentAProject) {
                    treeModel.insertNodeInto(identificationNode, n, n.getChildCount() - 1);
                    continue;
                }
                treeModel.insertNodeInto(identificationNode, n, n.getChildCount());
            }
            if (nbFiles > 0) {
                tree.expandNodeIfNeeded(n);
            }
            final String[] pathArray = new String[nbFiles];
            for (int i = 0; i < nbFiles; ++i) {
                File f = filePaths[i];
                pathArray[i] = f.getPath();
            }
            String[] result = new String[1];
            AbstractJMSCallback callback = new AbstractJMSCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success) {
                    if (success) {
                        for (int i = 0; i < nbFiles; ++i) {
                            ImportSearchResultAsDatasetJMSAction.this.startImport(_project, (DataSetNode)allIdentificationNodes.get(i), _parentDataset, (String)allDatasetNames.get(i), pathArray[i], treeModel, parserId, parserArguments, decoyRegex, instrumentId, peaklistSoftwareId, fragRuleSetId);
                        }
                    } else {
                        for (DataSetNode allIdentificationNode : allIdentificationNodes) {
                            treeModel.removeNodeFromParent(allIdentificationNode);
                        }
                    }
                }
            };
            CertifyIdentificationTask task = new CertifyIdentificationTask(callback, parserId, parserArguments, pathArray, projectId, result);
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }
    }

    private void startImport(final Project project, final DataSetNode identificationNode, final DDataset parentDataset, final String datasetName, String canonicalPath, final DefaultTreeModel treeModel, String parserId, HashMap<String, String> parserArguments, String decoyRegex, long instrumentId, long peaklistSoftwareId, long fragmentationRuleSetId) {
        final Long[] _resultSetId = new Long[1];
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                if (success) {
                    ImportSearchResultAsRsetJMSAction.fireListener(project.getId());
                    ImportSearchResultAsDatasetJMSAction.this.createDataset(identificationNode, project, parentDataset, datasetName, _resultSetId[0], this.getTaskInfo());
                } else {
                    treeModel.removeNodeFromParent(identificationNode);
                }
            }
        };
        ImportIdentificationTask task = new ImportIdentificationTask(callback, parserId, parserArguments, canonicalPath, decoyRegex, instrumentId, peaklistSoftwareId, false, fragmentationRuleSetId, project.getId(), _resultSetId);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    private void createDataset(final DataSetNode identificationNode, Project project, DDataset parentDataset, String name, Long resultSetId, TaskInfo taskInfo) {
        identificationNode.setIsChanging(false);
        final IdentificationTree tree = IdentificationTree.getCurrentTree();
        final DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
        treeModel.nodeChanged(identificationNode);
        final ArrayList createdDatasetList = new ArrayList();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success) {
                    DDataset dataset = (DDataset)createdDatasetList.get(0);
                    identificationNode.setIsChanging(false);
                    ((DataSetData)identificationNode.getData()).setDataset(dataset);
                    treeModel.nodeChanged(identificationNode);
                    ImportManager.importRenaming(dataset, identificationNode, tree);
                } else {
                    treeModel.removeNodeFromParent(identificationNode);
                }
            }
        };
        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
        task.initCreateDatasetForIdentification(project, parentDataset, Aggregation.ChildNature.SAMPLE_ANALYSIS, name, resultSetId, null, createdDatasetList, taskInfo);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        if (node.isChanging()) {
            this.setEnabled(false);
            return;
        }
        if (node.getType() == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
            this.setEnabled(true);
            return;
        }
        if (node.getType() == AbstractNode.NodeTypes.DATA_SET) {
            DataSetNode dataSetNode = (DataSetNode)node;
            this.setEnabled(!dataSetNode.hasResultSet() && !dataSetNode.hasResultSummary());
            return;
        }
        this.setEnabled(false);
    }
}

