/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdProjectIdentificationNode;
import java.awt.Window;

public class RenameAction
extends AbstractRSMAction {
    public RenameAction(AbstractTree tree) {
        super("Rename...", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        AbstractNode n = selectedNodes[0];
        AbstractNode.NodeTypes nodeType = n.getType();
        if (nodeType == AbstractNode.NodeTypes.DATA_SET) {
            DataSetNode datasetNode = (DataSetNode)n;
            DDataset dataset = datasetNode.getDataset();
            String name = dataset.getName();
            String newName = this.showRenameDialog(name, x, y);
            datasetNode.rename(newName, this.getTree());
        } else if (nodeType == AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
            IdProjectIdentificationNode projectNode = (IdProjectIdentificationNode)n;
            Project project = projectNode.getProject();
            String name = project.getName();
            String newName = this.showRenameDialog(name, x, y);
            projectNode.changeNameAndDescription(newName, project.getDescription());
        }
    }

    private String showRenameDialog(String name, int x, int y) {
        OptionDialog dialog = new OptionDialog((Window)WindowManager.getDefault().getMainWindow(), "Rename", null, "New Name", OptionDialog.OptionDialogType.TEXTFIELD);
        dialog.setText(name);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        String newName = null;
        if (dialog.getButtonClicked() == 0) {
            newName = dialog.getText();
        }
        if (newName != null && newName.length() > 0) {
            return newName;
        }
        return null;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        int nbSelectedNodes = selectedNodes.length;
        if (nbSelectedNodes != 1) {
            this.setEnabled(false);
            return;
        }
        AbstractNode node = selectedNodes[0];
        AbstractNode.NodeTypes nodeType = node.getType();
        if (nodeType != AbstractNode.NodeTypes.DATA_SET && nodeType != AbstractNode.NodeTypes.PROJECT_IDENTIFICATION) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

