/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.identification;

import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.dam.taskinfo.TaskInfo;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseDataSetTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.data.ChangeTypicalRule;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.ChangeTypicalProteinTask;
import fr.proline.studio.dpm.task.jms.ValidationTask;
import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.gui.ProjectExplorerPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.ValidationDialog;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.AbstractTree;
import fr.proline.studio.rsmexplorer.tree.DataSetNode;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class ValidateJMSAction
extends AbstractRSMAction {
    public ValidateJMSAction(AbstractTree tree) {
        super("Validate Search Result...", tree);
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        HashMap<String, String> validationArguments;
        int nbAlreadyValidated = 0;
        boolean mergedDatasetSelected = false;
        int nbNodes = selectedNodes.length;
        ArrayList<DDataset> datasetList = new ArrayList<DDataset>(nbNodes);
        for (int i = 0; i < nbNodes; ++i) {
            DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
            DDataset d = dataSetNode.getDataset();
            datasetList.add(d);
            if (dataSetNode.hasResultSummary()) {
                ++nbAlreadyValidated;
            }
            if (!((DataSetData)dataSetNode.getData()).getDatasetType().isAggregation()) continue;
            mergedDatasetSelected = true;
        }
        if (nbAlreadyValidated > 0) {
            String message = nbAlreadyValidated == 1 ? (nbNodes == 1 ? "Search Result has been already validated.\nDo you want to re-validate it ?" : "One of the Search Results has been already validated.\nDo you want to re-validate it ?") : (nbNodes == nbAlreadyValidated ? "Search Results have been already validated.\nDo you want to re-validate them ?" : "Some of the Search Results have been already validated.\nDo you want to re-validate them ?");
            OptionDialog yesNoDialog = new OptionDialog((Window)WindowManager.getDefault().getMainWindow(), "Re-Validate ?", message);
            yesNoDialog.setLocation(x, y);
            yesNoDialog.setVisible(true);
            if (yesNoDialog.getButtonClicked() != 0) {
                return;
            }
        }
        ValidationDialog dialog = ValidationDialog.getDialog((Window)WindowManager.getDefault().getMainWindow());
        dialog.setLocation(x, y);
        dialog.setDatasetList(datasetList);
        dialog.setAllowPropagateFilters(mergedDatasetSelected);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0) {
            validationArguments = dialog.getArguments();
            List<ChangeTypicalRule> changeTypicalRules = dialog.getChangeTypicalRules();
            String scoringType = dialog.getScoringType();
            boolean propagateValidation = dialog.isPropagateFiltersSelected();
            IdentificationTree tree = IdentificationTree.getCurrentTree();
            DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
            for (int i = 0; i < nbNodes; ++i) {
                DataSetNode dataSetNode = (DataSetNode)selectedNodes[i];
                dataSetNode.setIsChanging(true);
                treeModel.nodeChanged(dataSetNode);
                DDataset d = dataSetNode.getDataset();
                if (dataSetNode.hasResultSummary() || propagateValidation) {
                    this.removePreviousValidation(dataSetNode, propagateValidation);
                }
                this.askValidation(dataSetNode, validationArguments, changeTypicalRules, scoringType, propagateValidation);
            }
        } else {
            validationArguments = dialog.getArguments();
            List<ChangeTypicalRule> list = dialog.getChangeTypicalRules();
        }
    }

    private void removePreviousValidation(final DataSetNode dataSetNode, final boolean removeInHierarchy) {
        if (removeInHierarchy) {
            Runnable callback = new Runnable(){

                @Override
                public void run() {
                    ValidateJMSAction.this.removePreviousValidationImpl(dataSetNode, removeInHierarchy);
                }
            };
            IdentificationTree.getCurrentTree().loadNode(dataSetNode, callback, true);
        } else {
            this.removePreviousValidationImpl(dataSetNode, removeInHierarchy);
        }
    }

    private void removePreviousValidationImpl(DataSetNode dataSetNode, boolean removeInHierarchy) {
        if (removeInHierarchy) {
            Enumeration<TreeNode> e = dataSetNode.children();
            while (e.hasMoreElements()) {
                this.removePreviousValidationImpl((DataSetNode)e.nextElement(), removeInHierarchy);
            }
        }
        DatabaseDataSetTask taskRemoveValidation = new DatabaseDataSetTask(null);
        taskRemoveValidation.initModifyDatasetToRemoveValidation(dataSetNode.getDataset());
        taskRemoveValidation.fetchData();
    }

    private void askValidation(final DataSetNode dataSetNode, HashMap<String, String> parserArguments, final List<ChangeTypicalRule> changeTypicalRules, String scoringType, boolean propagate) {
        final DDataset d = dataSetNode.getDataset();
        final Integer[] _resultSummaryId = new Integer[1];
        final HashMap _rsmIdsByRsIds = new HashMap();
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                if (success) {
                    ValidateJMSAction.this.updateDatasets(dataSetNode, d, _resultSummaryId[0].intValue(), _rsmIdsByRsIds, this.getTaskInfo(), changeTypicalRules);
                } else {
                    dataSetNode.setIsChanging(false);
                    IdentificationTree tree = IdentificationTree.getCurrentTree();
                    DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                    treeModel.nodeChanged(dataSetNode);
                }
            }
        };
        ValidationTask task = null;
        task = propagate ? new ValidationTask(callback, d, "", parserArguments, _resultSummaryId, _rsmIdsByRsIds, scoringType) : new ValidationTask(callback, d, "", parserArguments, _resultSummaryId, scoringType);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    private void changeTypicalProtein(final DataSetNode datasetNode, List<ChangeTypicalRule> changeTypicalRules) {
        DDataset d = datasetNode.getDataset();
        AbstractJMSCallback callback = new AbstractJMSCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success) {
                datasetNode.setIsChanging(false);
                IdentificationTree tree = IdentificationTree.getCurrentTree();
                DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                treeModel.nodeChanged(datasetNode);
            }
        };
        ChangeTypicalProteinTask task = new ChangeTypicalProteinTask(callback, d, changeTypicalRules);
        AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
    }

    private void updateDatasets(final DataSetNode rootDatasetNode, DDataset rootDS, long rootRsmId, final Map<Long, Long> rsmIdsByRsIds, final TaskInfo taskInfo, final List<ChangeTypicalRule> changeTypicalRules) {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                ValidateJMSAction.this.updateDatasetHierarchy(rootDatasetNode, rsmIdsByRsIds, taskInfo, changeTypicalRules);
            }
        };
        if (!rsmIdsByRsIds.isEmpty() && rsmIdsByRsIds.size() > 1) {
            IdentificationTree.getCurrentTree().loadInBackground(rootDatasetNode, callback);
        }
        this.updateDataset(rootDatasetNode, rootDS, rootRsmId, taskInfo, changeTypicalRules);
    }

    private void updateDatasetHierarchy(DataSetNode rootDatasetNode, final Map<Long, Long> rsmIdsByRsIds, final TaskInfo taskInfo, final List<ChangeTypicalRule> changeTypicalRules) {
        Enumeration<TreeNode> e = rootDatasetNode.children();
        while (e.hasMoreElements()) {
            final DataSetNode dsChild = (DataSetNode)e.nextElement();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    ValidateJMSAction.this.updateDatasetHierarchy(dsChild, rsmIdsByRsIds, taskInfo, changeTypicalRules);
                }
            };
            this.updateDataset(dsChild, dsChild.getDataset(), rsmIdsByRsIds.get(dsChild.getResultSetId()), taskInfo, changeTypicalRules);
            IdentificationTree.getCurrentTree().loadInBackground(dsChild, callback);
        }
    }

    private void updateDataset(final DataSetNode datasetNode, DDataset d, long resultSummaryId, TaskInfo taskInfo, final List<ChangeTypicalRule> changeTypicalRules) {
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                if (success && changeTypicalRules != null && !changeTypicalRules.isEmpty()) {
                    ValidateJMSAction.this.changeTypicalProtein(datasetNode, changeTypicalRules);
                } else {
                    datasetNode.setIsChanging(false);
                    IdentificationTree tree = IdentificationTree.getCurrentTree();
                    DefaultTreeModel treeModel = (DefaultTreeModel)tree.getModel();
                    treeModel.nodeChanged(datasetNode);
                }
            }
        };
        DatabaseDataSetTask task = new DatabaseDataSetTask(callback);
        task.initModifyDatasetForValidation(d, Long.valueOf(resultSummaryId), taskInfo);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        Project selectedProject = ProjectExplorerPanel.getProjectExplorerPanel().getSelectedProject();
        if (!DatabaseDataManager.getDatabaseDataManager().ownProject(selectedProject)) {
            this.setEnabled(false);
            return;
        }
        for (AbstractNode node : selectedNodes) {
            DataSetNode parentDatasetNode;
            DDatasetType.AggregationInformation mergeInfo;
            if (node.isChanging()) {
                this.setEnabled(false);
                return;
            }
            if (node.getType() != AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(false);
                return;
            }
            DataSetNode dataSetNode = (DataSetNode)node;
            if (!dataSetNode.hasResultSet()) {
                this.setEnabled(false);
                return;
            }
            DataSetData datasetData = (DataSetData)dataSetNode.getData();
            DDatasetType datasetType = datasetData.getDatasetType();
            if (datasetType.isAggregation() && dataSetNode.hasResultSummary() && ((mergeInfo = datasetData.getDataset().getAggregationInformation()).compareTo((Enum)DDatasetType.AggregationInformation.IDENTIFICATION_SUMMARY_AGG) == 0 || mergeInfo.compareTo((Enum)DDatasetType.AggregationInformation.IDENTIFICATION_SUMMARY_UNION) == 0)) {
                this.setEnabled(false);
                return;
            }
            AbstractNode parentNode = (AbstractNode)dataSetNode.getParent();
            if (parentNode.getType() != AbstractNode.NodeTypes.DATA_SET || !(parentDatasetNode = (DataSetNode)parentNode).hasResultSet()) continue;
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

