/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.actions.xic;

import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.DataSetData;
import fr.proline.studio.gui.OptionDialog;
import fr.proline.studio.rsmexplorer.actions.identification.AbstractRSMAction;
import fr.proline.studio.rsmexplorer.tree.AbstractNode;
import fr.proline.studio.rsmexplorer.tree.xic.QuantExperimentalDesignTree;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalGroupNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleAnalysisNode;
import fr.proline.studio.rsmexplorer.tree.xic.XICBiologicalSampleNode;
import java.awt.Window;
import javax.swing.tree.DefaultTreeModel;

public class CreateXICBiologicalNodeAction
extends AbstractRSMAction {
    private AbstractNode.NodeTypes m_createNodeType;
    private final QuantExperimentalDesignTree m_tree;

    public CreateXICBiologicalNodeAction(String actionName, AbstractNode.NodeTypes type, QuantExperimentalDesignTree tree) {
        super(actionName, tree);
        this.m_createNodeType = type;
        this.m_tree = tree;
    }

    @Override
    public void updateEnabled(AbstractNode[] selectedNodes) {
        AbstractNode.NodeTypes nodeType = selectedNodes[0].getType();
        if (selectedNodes.length == 1) {
            if (nodeType == AbstractNode.NodeTypes.DATA_SET) {
                this.setEnabled(true);
            } else if (nodeType == AbstractNode.NodeTypes.BIOLOGICAL_GROUP && this.m_createNodeType == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE || nodeType == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE && this.m_createNodeType == AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE_ANALYSIS) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(AbstractNode[] selectedNodes, int x, int y) {
        AbstractNode parentNode = selectedNodes[0];
        switch (this.m_createNodeType) {
            case BIOLOGICAL_GROUP: {
                this.createXICNode(parentNode, this.m_createNodeType, "Group 1", x, y, true);
                break;
            }
            case BIOLOGICAL_SAMPLE: {
                if (parentNode.getType() == AbstractNode.NodeTypes.BIOLOGICAL_GROUP) {
                    this.createXICNode(parentNode, this.m_createNodeType, "Sample 1", x, y, true);
                    break;
                }
                if (parentNode.getType() != AbstractNode.NodeTypes.DATA_SET) break;
                AbstractNode gNode = this.createXICNode(parentNode, AbstractNode.NodeTypes.BIOLOGICAL_GROUP, "New Group", x, y, false);
                AbstractNode abstractNode = this.createXICNode(gNode, this.m_createNodeType, "New Sample", x, y, true);
                break;
            }
            case BIOLOGICAL_SAMPLE_ANALYSIS: {
                if (parentNode.getType() == AbstractNode.NodeTypes.DATA_SET) {
                    AbstractNode gNode = this.createXICNode(parentNode, AbstractNode.NodeTypes.BIOLOGICAL_GROUP, "New Group", x, y, false);
                    AbstractNode sNode = this.createXICNode(gNode, AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE, "New Sample", x, y, false);
                    this.createXICNode(sNode, this.m_createNodeType, "Channel new 1", x, y, true);
                    break;
                }
                if (parentNode.getType() != AbstractNode.NodeTypes.BIOLOGICAL_SAMPLE) break;
                this.createXICNode(parentNode, this.m_createNodeType, "Channel new 1", x, y, true);
                break;
            }
        }
    }

    private AbstractNode createXICNode(AbstractNode parentNode, AbstractNode.NodeTypes creatNodeType, String defaultName, int x, int y, boolean withDialog) {
        AbstractNode createdNode = null;
        String itemName = defaultName;
        if (withDialog && (itemName = this.showItemNameDialog(defaultName, x, y)) == null) {
            return null;
        }
        DataSetData temporaryData = DataSetData.createTemporaryAggregate((String)itemName);
        switch (creatNodeType) {
            case BIOLOGICAL_GROUP: {
                createdNode = new XICBiologicalGroupNode((AbstractData)temporaryData);
                break;
            }
            case BIOLOGICAL_SAMPLE: {
                createdNode = new XICBiologicalSampleNode((AbstractData)temporaryData);
                break;
            }
            case BIOLOGICAL_SAMPLE_ANALYSIS: {
                createdNode = new XICBiologicalSampleAnalysisNode((AbstractData)temporaryData);
                break;
            }
        }
        if (createdNode == null) {
            return null;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)this.m_tree.getModel();
        treeModel.insertNodeInto(createdNode, parentNode, 0);
        this.m_tree.expandNodeIfNeeded(parentNode);
        return createdNode;
    }

    private String showItemNameDialog(String defaultName, int x, int y) {
        String createItemName = "New " + (String)super.getValue("Name") + "'s Name";
        OptionDialog dialog = new OptionDialog((Window)WindowManager.getDefault().getMainWindow(), "Name", null, createItemName, OptionDialog.OptionDialogType.TEXTFIELD);
        dialog.setText(defaultName);
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        String newName = null;
        if (dialog.getButtonClicked() == 0) {
            newName = dialog.getText();
        }
        if (newName != null && newName.length() > 0) {
            return newName;
        }
        return null;
    }
}

