/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.studio.export.ExportButton;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.rsmexplorer.gui.FlipButton;
import fr.proline.studio.rsmexplorer.gui.MSDiagOutput_AW;
import fr.proline.studio.rsmexplorer.gui.RsetMSDiagPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSDiag_PieChart
extends HourglassPanel {
    public static final String SERIES_NAME = "Pie chart";
    protected static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private static final long serialVersionUID = 1L;
    private final DefaultPieDataset m_dataSet;
    private final JFreeChart m_chart;
    private JPanel m_pieChartPanel;
    private final RsetMSDiagPanel m_msdiagPanel;

    public MSDiag_PieChart(RsetMSDiagPanel rsetMSDiagPanel) {
        this.m_msdiagPanel = rsetMSDiagPanel;
        this.m_dataSet = new DefaultPieDataset();
        this.m_chart = ChartFactory.createPieChart((String)"Chart Title", (PieDataset)this.m_dataSet, (boolean)true, (boolean)true, (boolean)false);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        ChartPanel cp = new ChartPanel(this.m_chart, true);
        cp.setMinimumDrawWidth(0);
        cp.setMinimumDrawHeight(0);
        cp.setMaximumDrawWidth(Integer.MAX_VALUE);
        cp.setMaximumDrawHeight(Integer.MAX_VALUE);
        this.m_chart.getPlot().setBackgroundPaint((Paint)Color.white);
        this.m_pieChartPanel = cp;
        JToolBar toolbar = this.initToolbar();
        this.add(toolbar, "West");
        this.add(this.m_pieChartPanel, "Center");
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        FlipButton flipModeButton = new FlipButton("flip button text", this.m_msdiagPanel);
        toolbar.add(flipModeButton);
        ExportButton exportImageButton = new ExportButton("pieChart", this.m_pieChartPanel);
        toolbar.add((Component)exportImageButton);
        return toolbar;
    }

    public void setData(MSDiagOutput_AW msdo) {
        this.constructPieChart(msdo);
    }

    private void constructPieChart(MSDiagOutput_AW msdo) {
        this.m_dataSet.clear();
        if (msdo == null) {
            return;
        }
        String title = msdo.description;
        this.m_chart.setTitle(title);
        this.m_chart.getPlot().setBackgroundPaint((Paint)Color.white);
        StandardPieSectionLabelGenerator gen = new StandardPieSectionLabelGenerator("{0}: {1} ({2})", (NumberFormat)new DecimalFormat("0"), (NumberFormat)new DecimalFormat("0%"));
        ((PiePlot)this.m_chart.getPlot()).setLabelGenerator((PieSectionLabelGenerator)gen);
        if (msdo.matrix.length == 1 && msdo.matrix[0].length == 2) {
            this.m_dataSet.setValue((Comparable)((Object)msdo.column_names[0]), (Number)Math.abs((Double)msdo.matrix[0][0]));
            this.m_dataSet.setValue((Comparable)((Object)msdo.column_names[1]), (Number)Math.abs((Double)msdo.matrix[0][1]));
            ((PiePlot)this.m_chart.getPlot()).setSectionPaint((Comparable)((Object)msdo.column_names[0]), (Paint)new Color(220, 220, 220));
            ((PiePlot)this.m_chart.getPlot()).setSectionPaint((Comparable)((Object)msdo.column_names[1]), (Paint)new Color(60, 60, 220));
        }
    }
}

