/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.dto.DProteinMatch;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.tasks.DatabaseDatasetPTMsTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dam.tasks.data.ptm.PTMCluster;
import fr.proline.studio.dam.tasks.data.ptm.PTMDataset;
import fr.proline.studio.dam.tasks.data.ptm.PTMDatasetPair;
import fr.proline.studio.dam.tasks.data.ptm.PTMPeptideInstance;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.AbstractMarker;
import fr.proline.studio.markerbar.BookmarkMarker;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.progress.ProgressBarDialog;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.DataBoxViewerManager;
import fr.proline.studio.rsmexplorer.actions.ViewColocalizedPTMClustersAction;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.EditClusterDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.ModifyClusterStatusPanel;
import fr.proline.studio.rsmexplorer.gui.model.PTMClusterTableModel;
import fr.proline.studio.rsmexplorer.gui.renderer.RendererMouseCallback;
import fr.proline.studio.rsmexplorer.gui.renderer.SelectLevelRenderer;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.ImportTableSelectionInterface;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import fr.proline.studio.utils.StudioResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTMClustersPanel
extends HourglassPanel
implements RendererMouseCallback,
DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private static final Logger m_logger = LoggerFactory.getLogger((String)"ProlineStudio.ResultExplorer");
    private AbstractDataBox m_dataBox;
    private JScrollPane m_scrollPane;
    private PTMClusterTable m_ptmClusterTable;
    private PTMClusterTableModel m_ptmClusterTableModel;
    private JTextField m_countModificationTextField;
    private MarkerContainerPanel m_markerContainerPanel;
    private ModifyStatusDialog m_modifyStatusDialog;
    private SearchToggleButton m_searchToggleButton;
    private InfoToggleButton m_infoToggleButton;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private boolean m_areClustersEditable;
    private boolean m_hideFirstTime = true;

    public PTMClustersPanel(boolean editable) {
        this.m_areClustersEditable = editable;
        this.initComponents();
    }

    public void setData(Long taskId, ArrayList<PTMCluster> ptmClusters, boolean finished) {
        this.m_ptmClusterTableModel.setData(taskId, ptmClusters);
        if (ptmClusters != null && ptmClusters.size() > 0) {
            this.m_ptmClusterTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(ptmClusters.size());
            if (this.m_hideFirstTime) {
                this.setColumnsVisibility();
                this.m_hideFirstTime = false;
            }
        }
        this.m_infoToggleButton.updateInfo();
        this.m_countModificationTextField.setText(this.m_ptmClusterTableModel.getModificationsInfo());
        if (finished) {
            this.m_ptmClusterTable.setSortable(true);
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_ptmClusterTable.dataUpdated(subTask, finished);
        this.m_countModificationTextField.setText(this.m_ptmClusterTableModel.getModificationsInfo());
    }

    public PTMCluster getSelectedProteinPTMCluster() {
        int selectedRow = this.m_ptmClusterTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        selectedRow = this.m_ptmClusterTable.convertRowIndexToModel(selectedRow);
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_ptmClusterTable.getModel();
        selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
        PTMClusterTableModel tableModel = (PTMClusterTableModel)compoundTableModel.getBaseModel();
        return tableModel.getProteinPTMCluster(selectedRow);
    }

    public List<PTMCluster> getSelectedPTMClusters() {
        int[] selectedRows = this.m_ptmClusterTable.getSelectedRows();
        int nbSelectedRows = selectedRows.length;
        ArrayList<PTMCluster> selectedPtmClusters = new ArrayList<PTMCluster>(nbSelectedRows);
        if (nbSelectedRows == 0) {
            return selectedPtmClusters;
        }
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_ptmClusterTable.getModel();
        for (int i = 0; i < nbSelectedRows; ++i) {
            int rowModelIndex = this.m_ptmClusterTable.convertRowIndexToModel(selectedRows[i]);
            int convertedSelectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(rowModelIndex);
            selectedPtmClusters.add(this.m_ptmClusterTableModel.getProteinPTMCluster(convertedSelectedRow));
        }
        return selectedPtmClusters;
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_ptmClusterTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_ptmClusterTable;
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_ptmClusterTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    @Override
    public void mouseAction(MouseEvent e) {
        int col = this.m_ptmClusterTable.columnAtPoint(e.getPoint());
        int row = this.m_ptmClusterTable.rowAtPoint(e.getPoint());
        if (row != -1 && this.m_areClustersEditable) {
            int rowModelIndex = this.m_ptmClusterTable.convertRowIndexToModel(row);
            if (this.m_ptmClusterTable.convertColumnIndexToModel(col) == 1) {
                PTMDatasetPair ptmDatasetpair;
                this.m_ptmClusterTable.getSelectionModel().setSelectionInterval(row, row);
                if (!this.m_ptmClusterTable.isLoaded()) {
                    ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)this.m_ptmClusterTable, (String)"Data loading", (String)"Edit is not available while data is loading. Please Wait.");
                    dialog.setLocation(e.getPoint());
                    dialog.setVisible(true);
                    if (!dialog.isWaitingFinished()) {
                        return;
                    }
                }
                if ((ptmDatasetpair = (PTMDatasetPair)this.m_dataBox.getData(PTMDatasetPair.class)).getPTMDatasetType() == PTMDatasetPair.ANNOTATED_PTM_DATASET) {
                    m_logger.debug(" ==> EDIT IN ANNOTATED DATA OK !!! ");
                } else {
                    PTMDatasetPair annPtmDatasetpair = DatabaseDataManager.getDatabaseDataManager().getAnnotatedPTMDatasetSetForDS(Long.valueOf(ptmDatasetpair.getDataset().getId()));
                    String existMsg = annPtmDatasetpair != null ? " Annotated PTM Exist " : " Annotated do NOT Exist !";
                    m_logger.debug("  ==> EDIT IN NOT ANNOTATED DATA NOO OK !!! " + existMsg);
                }
                if (this.m_ptmClusterTableModel.isRowEditable(rowModelIndex)) {
                    if (this.m_modifyStatusDialog == null) {
                        this.m_modifyStatusDialog = new ModifyStatusDialog();
                    }
                    PTMCluster cluster = this.getSelectedProteinPTMCluster();
                    this.m_modifyStatusDialog.setData(cluster);
                    this.m_modifyStatusDialog.setLocation(e.getLocationOnScreen().x, e.getLocationOnScreen().y);
                    this.m_modifyStatusDialog.setVisible(true);
                }
            }
        }
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel proteinPTMClusterPanel = this.createProteinPTMClusterPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                proteinPTMClusterPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)proteinPTMClusterPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), new Integer(JLayeredPane.PALETTE_LAYER + 1));
        this.setColumnsVisibility();
    }

    private void setColumnsVisibility() {
        List<Integer> listIdsToHide = this.m_ptmClusterTableModel.getDefaultColumnsToHide();
        List columns = this.m_ptmClusterTable.getColumns(true);
        for (Integer id : listIdsToHide) {
            boolean columnVisible = ((TableColumnExt)columns.get(id)).isVisible();
            if (!columnVisible) continue;
            this.m_ptmClusterTable.getColumnExt(this.m_ptmClusterTable.convertColumnIndexToView(id)).setVisible(false);
        }
    }

    private JPanel createProteinPTMClusterPanel() {
        JPanel proteinPTMClusterPanel = new JPanel();
        proteinPTMClusterPanel.setBounds(0, 0, 500, 400);
        proteinPTMClusterPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        proteinPTMClusterPanel.add((Component)toolbar, "West");
        proteinPTMClusterPanel.add((Component)internalPanel, "Center");
        return proteinPTMClusterPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_ptmClusterTable.getModel(), (SettingsInterface)this.m_ptmClusterTable);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_ptmClusterTable, (JXTable)this.m_ptmClusterTable, (FilterTableModelInterface)((CompoundTableModel)this.m_ptmClusterTable.getModel()));
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_ptmClusterTable.getModel())){

            protected void filteringDone() {
                PTMClustersPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                PTMClustersPanel.this.m_dataBox.propagateDataChanged();
                PTMClustersPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_ptmClusterTable.getModel()), "Protein Sets", (JXTable)this.m_ptmClusterTable);
        toolbar.add((Component)this.m_searchToggleButton);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_ptmClusterTable.getModel())){

            public void actionPerformed() {
                JXTable table = PTMClustersPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(PTMClustersPanel.this.m_dataBox.getId(), PTMClustersPanel.this.m_dataBox.getUserName(), PTMClustersPanel.this.m_dataBox.getDataName(), PTMClustersPanel.this.m_dataBox.getTypeName(), table);
                Image i = PTMClustersPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_ptmClusterTable, (InfoInterface)this.m_ptmClusterTable);
        toolbar.add((Component)this.m_addCompareDataButton);
        toolbar.add((Component)this.m_infoToggleButton);
        toolbar.addSeparator();
        SaveToggleButton saveButton = new SaveToggleButton(this.m_ptmClusterTable);
        MergeToggleButton mergeButton = new MergeToggleButton(this.m_ptmClusterTable);
        EditToggleButton editButton = new EditToggleButton(this.m_ptmClusterTable);
        toolbar.add(mergeButton);
        toolbar.add(editButton);
        toolbar.add(saveButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_scrollPane = new JScrollPane();
        this.m_ptmClusterTable = new PTMClusterTable();
        this.m_ptmClusterTableModel = new PTMClusterTableModel(this.m_ptmClusterTable, this);
        this.m_ptmClusterTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)this.m_ptmClusterTableModel, true));
        SelectLevelRenderer renderer = (SelectLevelRenderer)this.m_ptmClusterTableModel.getRenderer(0, 1);
        this.m_ptmClusterTable.addMouseListener(renderer);
        this.m_ptmClusterTable.addMouseMotionListener(renderer);
        this.m_ptmClusterTable.getColumnExt(this.m_ptmClusterTable.convertColumnIndexToView(2)).setVisible(false);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.m_ptmClusterTable.getModel());
        this.m_ptmClusterTable.setRowSorter(sorter);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_scrollPane, (MarkerComponentInterface)this.m_ptmClusterTable);
        this.m_scrollPane.setViewportView((Component)((Object)this.m_ptmClusterTable));
        this.m_ptmClusterTable.setFillsViewportHeight(true);
        this.m_ptmClusterTable.setViewport(this.m_scrollPane.getViewport());
        this.m_countModificationTextField = new JTextField();
        this.m_countModificationTextField.setEditable(false);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        internalPanel.add((Component)this.m_countModificationTextField, c);
        return internalPanel;
    }

    private class EditToggleButton
    extends JToggleButton {
        private ProgressInterface m_progressInterface;

        public EditToggleButton(ProgressInterface progressInterface) {
            this.m_progressInterface = progressInterface;
            this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.EDIT));
            this.setEnabled(PTMClustersPanel.this.m_areClustersEditable);
            this.init();
        }

        private void init() {
            this.setToolTipText("Edit selected cluster");
            this.addActionListener(e -> {
                if (this.m_progressInterface != null && !this.m_progressInterface.isLoaded()) {
                    ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)this.m_progressInterface, (String)"Data loading", (String)"Edit is not available while data is loading. Please Wait.");
                    dialog.setLocation(this.getLocationOnScreen().x + this.getWidth() + 5, this.getLocationOnScreen().y + this.getHeight() + 5);
                    dialog.setVisible(true);
                    if (!dialog.isWaitingFinished()) {
                        this.setSelected(false);
                        return;
                    }
                }
                if (PTMClustersPanel.this.m_ptmClusterTableModel.getRowCount() > 0 && PTMClustersPanel.this.m_ptmClusterTable.getSelectedRowCount() == 1) {
                    PTMCluster cluster = PTMClustersPanel.this.getSelectedProteinPTMCluster();
                    m_logger.debug(" Edit clusters id " + cluster.getId() + " (" + cluster.getProteinMatch().getAccession() + "_" + cluster.getRepresentativePepMatch().getPeptide().getSequence() + ")");
                    EditClusterDialog editClusterDialog = new EditClusterDialog(cluster);
                    editClusterDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                    editClusterDialog.setVisible(true);
                    if (editClusterDialog.getButtonClicked() == 0) {
                        ArrayList<PTMCluster> clustersToModify = new ArrayList<PTMCluster>();
                        clustersToModify.add(cluster);
                        byte reason = -1;
                        if (editClusterDialog.isPeptideDeleted()) {
                            editClusterDialog.getRemovedPeptideInstances().forEach(ptmPeptide -> cluster.removePeptide(ptmPeptide));
                            reason = DataBoxViewerManager.REASON_MODIF.REASON_PEPTIDE_SUPPRESSED.getReasonValue();
                        }
                        if (editClusterDialog.isStatusModified()) {
                            reason = reason == -1 ? DataBoxViewerManager.REASON_MODIF.REASON_PTMCLUSTER_MODIFIED.getReasonValue() : (byte)(reason | DataBoxViewerManager.REASON_MODIF.REASON_PTMCLUSTER_MODIFIED.getReasonValue());
                        }
                        if (editClusterDialog.isClusterModified()) {
                            DataBoxViewerManager.loadedDataModified(PTMClustersPanel.this.m_dataBox.getProjectId(), PTMClustersPanel.this.m_dataBox.getRsetId(), PTMClustersPanel.this.m_dataBox.getRsmId(), PTMCluster.class, clustersToModify, reason);
                        }
                    }
                } else {
                    InfoDialog err = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.INFO, "Edition Information", "Can't edit more than one modification cluster at the time. ");
                    err.setButtonVisible(1, false);
                    err.setButtonName(0, "OK");
                    err.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                    err.setVisible(true);
                }
            });
        }
    }

    private class MergeToggleButton
    extends JToggleButton {
        private ProgressInterface m_progressInterface;

        public MergeToggleButton(ProgressInterface progressInterface) {
            this.m_progressInterface = progressInterface;
            this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.MERGE_PTM));
            this.setEnabled(PTMClustersPanel.this.m_areClustersEditable);
            this.init();
        }

        private void init() {
            this.setToolTipText("Merge selected clusters");
            this.addActionListener(e -> {
                if (this.m_progressInterface != null && !this.m_progressInterface.isLoaded()) {
                    ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)this.m_progressInterface, (String)"Data loading", (String)"Merge is not available while data is loading. Please Wait.");
                    dialog.setLocation(this.getLocationOnScreen().x + this.getWidth() + 5, this.getLocationOnScreen().y + this.getHeight() + 5);
                    dialog.setVisible(true);
                    if (!dialog.isWaitingFinished()) {
                        this.setSelected(false);
                        return;
                    }
                }
                if (PTMClustersPanel.this.m_ptmClusterTableModel.getRowCount() > 0 && PTMClustersPanel.this.m_ptmClusterTable.getSelectedRowCount() > 1) {
                    List<PTMCluster> clusters = PTMClustersPanel.this.getSelectedPTMClusters();
                    PTMDataset ptmDS = clusters.get(0).getPTMDataset();
                    boolean merged = ptmDS.mergeClusters(clusters);
                    if (merged) {
                        PTMClustersPanel.this.m_ptmClusterTable.dataUpdated(null, true);
                        PTMClustersPanel.this.m_dataBox.propagateDataChanged();
                        PTMClustersPanel.this.m_infoToggleButton.updateInfo();
                        DataBoxViewerManager.loadedDataModified(PTMClustersPanel.this.m_dataBox.getProjectId(), PTMClustersPanel.this.m_dataBox.getRsetId(), PTMClustersPanel.this.m_dataBox.getRsmId(), PTMCluster.class, new ArrayList<PTMCluster>(clusters), DataBoxViewerManager.REASON_MODIF.REASON_PTMCLUSTER_MERGED.getReasonValue());
                    } else {
                        InfoDialog err = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Merge Error", "Merge has not be done. Be sure selected clusters are co-localized.");
                        err.setButtonVisible(1, false);
                        err.setButtonName(0, "OK");
                        err.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                        err.setVisible(true);
                    }
                } else {
                    InfoDialog err = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.INFO, "Merge Information", "Select more than one co-localized modification clusters.");
                    err.setButtonVisible(1, false);
                    err.setButtonName(0, "OK");
                    err.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                    err.setVisible(true);
                }
            });
        }
    }

    private class SaveToggleButton
    extends JToggleButton {
        private ProgressInterface m_progressInterface = null;

        public SaveToggleButton(ProgressInterface progressInterface) {
            this.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.SAVE_SETTINGS));
            this.m_progressInterface = progressInterface;
            this.setEnabled(PTMClustersPanel.this.m_areClustersEditable);
            this.init();
        }

        private void init() {
            this.setToolTipText("Save Annotated Modifications Clusters");
            this.addActionListener(e -> {
                PTMDatasetPair ptmDatasetpair;
                if (this.m_progressInterface != null && !this.m_progressInterface.isLoaded()) {
                    ProgressBarDialog dialog = ProgressBarDialog.getDialog((Window)WindowManager.getDefault().getMainWindow(), (ProgressInterface)this.m_progressInterface, (String)"Data loading", (String)"Save is not available while data is loading. Please Wait.");
                    dialog.setLocation(this.getLocationOnScreen().x + this.getWidth() + 5, this.getLocationOnScreen().y + this.getHeight() + 5);
                    dialog.setVisible(true);
                    if (!dialog.isWaitingFinished()) {
                        this.setSelected(false);
                        return;
                    }
                }
                if (!(ptmDatasetpair = (PTMDatasetPair)PTMClustersPanel.this.m_dataBox.getData(PTMDatasetPair.class)).shouldSavePTMDataset()) {
                    InfoDialog err = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.INFO, "Save Information", "No modification to save...");
                    err.setButtonVisible(1, false);
                    err.setButtonName(0, "OK");
                    err.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                    err.setVisible(true);
                    return;
                }
                boolean changeToAnnotated = false;
                if (ptmDatasetpair.getPTMDatasetType() == PTMDatasetPair.RAW_PTM_DATASET) {
                    InfoDialog err = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.INFO, "Save Warning", "If annotated modification clusters already exist, it will be replace by new modification. Are you sure ? ");
                    err.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                    err.setVisible(true);
                    int choice = err.getButtonClicked();
                    if (choice == 1) {
                        return;
                    }
                    DatabaseDataManager.getDatabaseDataManager().removeAllPTMDatasetsForDS(Long.valueOf(ptmDatasetpair.getDataset().getId()));
                    ptmDatasetpair.changePTMDatasetType(PTMDatasetPair.ANNOTATED_PTM_DATASET);
                    DatabaseDataManager.getDatabaseDataManager().addLoadedAnnotatedPTMDatasetSet(ptmDatasetpair);
                    changeToAnnotated = true;
                }
                PTMDataset ptmDataset = (PTMDataset)PTMClustersPanel.this.m_dataBox.getData(PTMDataset.class);
                DatabaseDatasetPTMsTask task = new DatabaseDatasetPTMsTask(null);
                task.initAddAnnotatedPTMDataset(Long.valueOf(PTMClustersPanel.this.m_dataBox.getProjectId()), ptmDataset);
                task.fetchData();
                PTMClustersPanel.this.m_infoToggleButton.updateInfo();
                DataBoxViewerManager.loadedDataModified(PTMClustersPanel.this.m_dataBox.getProjectId(), PTMClustersPanel.this.m_dataBox.getRsetId(), PTMClustersPanel.this.m_dataBox.getRsmId(), PTMCluster.class, new ArrayList(), DataBoxViewerManager.REASON_MODIF.REASON_PTMDATASET_SAVED.getReasonValue());
                if (changeToAnnotated) {
                    String newTitle = PTMClustersPanel.this.m_dataBox.getFullName();
                    if (!newTitle.contains("Annotated PTMs")) {
                        newTitle = newTitle.replace("Dataset PTMs", "Annotated PTMs");
                    }
                    ArrayList<String> modifData = new ArrayList<String>();
                    modifData.add(newTitle);
                    DataBoxViewerManager.loadedDataModified(PTMClustersPanel.this.m_dataBox.getProjectId(), PTMClustersPanel.this.m_dataBox.getRsetId(), PTMClustersPanel.this.m_dataBox.getRsmId(), PTMCluster.class, modifData, DataBoxViewerManager.REASON_MODIF.REASON_CHANGE_TITLE.getReasonValue());
                }
            });
        }
    }

    private class ModifyStatusDialog
    extends DefaultDialog {
        private ModifyClusterStatusPanel m_panel;
        private PTMCluster m_currentCluster;

        public ModifyStatusDialog() {
            super((Window)WindowManager.getDefault().getMainWindow(), Dialog.ModalityType.APPLICATION_MODAL);
            this.setTitle("Modify Modification Cluster Status");
            String helpText = StudioResourceBundle.getMessage(PTMClustersPanel.class, (String)"EditCluster.status.modif.html.help");
            this.setHelpHeaderText(helpText);
            this.m_panel = new ModifyClusterStatusPanel();
            this.setInternalComponent(this.m_panel);
            this.setResizable(true);
            this.setButtonVisible(5, false);
        }

        protected boolean okCalled() {
            ArrayList<PTMCluster> clustersToModify = new ArrayList<PTMCluster>();
            clustersToModify.add(this.m_currentCluster);
            if (this.m_panel.applyModifiedStatus()) {
                DataBoxViewerManager.loadedDataModified(PTMClustersPanel.this.m_dataBox.getProjectId(), PTMClustersPanel.this.m_dataBox.getRsetId(), PTMClustersPanel.this.m_dataBox.getRsmId(), PTMCluster.class, clustersToModify, DataBoxViewerManager.REASON_MODIF.REASON_PTMCLUSTER_MODIFIED.getReasonValue());
            }
            return true;
        }

        public void setData(PTMCluster clusterToModify) {
            this.m_currentCluster = clusterToModify;
            this.m_panel.setData(clusterToModify);
        }
    }

    private class PTMClusterTable
    extends LazyTable
    implements ImportTableSelectionInterface,
    CrossSelectionInterface,
    InfoInterface {
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public PTMClusterTable() {
            super(PTMClustersPanel.this.m_scrollPane.getVerticalScrollBar());
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            PTMClustersPanel.this.m_dataBox.addDataChanged(DProteinSet.class);
            PTMClustersPanel.this.m_dataBox.addDataChanged(DProteinMatch.class);
            PTMClustersPanel.this.m_dataBox.addDataChanged(PTMPeptideInstance.class, null);
            PTMClustersPanel.this.m_dataBox.propagateDataChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((PTMClusterTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                    PTMClustersPanel.this.setColumnsVisibility();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask != null && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return PTMClustersPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return PTMClustersPanel.this.m_dataBox.isLoaded();
        }

        public void importSelection(HashSet selectedData) {
            ListSelectionModel selectionTableModel = this.getSelectionModel();
            selectionTableModel.clearSelection();
            int firstRow = -1;
            int rowCount = PTMClustersPanel.this.m_ptmClusterTableModel.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Object v = PTMClustersPanel.this.m_ptmClusterTableModel.getValueAt(i, 2);
                if (!selectedData.remove(v)) continue;
                if (firstRow == -1) {
                    firstRow = i;
                }
                selectionTableModel.addSelectionInterval(i, i);
                BookmarkMarker marker = new BookmarkMarker(i);
                PTMClustersPanel.this.m_markerContainerPanel.addMarker((AbstractMarker)marker);
                if (selectedData.isEmpty()) break;
            }
            if (firstRow != -1) {
                this.scrollToVisible(firstRow);
            }
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(PTMClustersPanel.this);
            this.m_popupMenu.addAction(new ViewColocalizedPTMClustersAction());
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count = this.getModel().getRowCount();
            String modifInfo = PTMClustersPanel.this.m_ptmClusterTableModel.getModificationsInfo();
            return count + (count > 1 ? " PTM Clusters" : " PTM Cluster") + " \n " + modifInfo;
        }
    }
}

