/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.uds.Project;
import fr.proline.core.orm.uds.UserAccount;
import fr.proline.studio.NbPreferences;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.data.AbstractData;
import fr.proline.studio.dam.data.ClearProjectData;
import fr.proline.studio.dam.data.ProjectIdentificationData;
import fr.proline.studio.dam.data.ProjectQuantitationData;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseClearProjectTask;
import fr.proline.studio.dam.tasks.DatabaseProjectTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.dpm.AccessJMSManagerThread;
import fr.proline.studio.dpm.task.jms.AbstractJMSCallback;
import fr.proline.studio.dpm.task.jms.AbstractJMSTask;
import fr.proline.studio.dpm.task.jms.ClearProjectTask;
import fr.proline.studio.dpm.task.jms.CreateProjectTask;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.gui.InfoDialog;
import fr.proline.studio.pattern.DataParameter;
import fr.proline.studio.pattern.ParameterList;
import fr.proline.studio.pattern.ParameterSubtypeEnum;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import fr.proline.studio.rsmexplorer.actions.ConnectAction;
import fr.proline.studio.rsmexplorer.gui.dialog.AddProjectDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.ClearProjectDialog;
import fr.proline.studio.rsmexplorer.gui.model.properties.ProjectPropertiesTableModel;
import fr.proline.studio.rsmexplorer.tree.identification.IdentificationTree;
import fr.proline.studio.rsmexplorer.tree.quantitation.QuantitationTree;
import fr.proline.studio.utils.IconManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ProjectExplorerPanel
extends JPanel {
    private static ProjectExplorerPanel m_singleton = null;
    private JButton m_addProjectButton;
    private JButton m_editProjectButton;
    private JButton m_propertiesProjectButton;
    private JButton m_clearProjectButton;
    private JComboBox<ProjectItem> m_projectsComboBox;
    private JScrollPane m_identificationTreeScrollPane;
    private JScrollPane m_quantitationTreeScrollPane;

    public static ProjectExplorerPanel getProjectExplorerPanel() {
        if (m_singleton == null) {
            m_singleton = new ProjectExplorerPanel();
        }
        return m_singleton;
    }

    private ProjectExplorerPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_projectsComboBox = new JComboBox();
        this.m_projectsComboBox.setRenderer(new ProjectComboboxRenderer());
        this.m_projectsComboBox.setMaximumRowCount(16);
        JPanel buttonsPanel = this.createButtonPanel();
        this.m_identificationTreeScrollPane = new JScrollPane();
        this.m_identificationTreeScrollPane.getViewport().setBackground(Color.white);
        this.m_quantitationTreeScrollPane = new JScrollPane();
        this.m_quantitationTreeScrollPane.getViewport().setBackground(Color.white);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.add(this.m_projectsComboBox, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)buttonsPanel, c);
        JSplitPane splitPane = new JSplitPane(0, this.m_identificationTreeScrollPane, this.m_quantitationTreeScrollPane);
        splitPane.setResizeWeight(0.5);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        this.add((Component)splitPane, c);
    }

    public Project getSelectedProject() {
        ProjectItem pi = (ProjectItem)this.m_projectsComboBox.getSelectedItem();
        if (pi == null || pi.m_projectIdentificationData == null) {
            return null;
        }
        return pi.m_projectIdentificationData.getProject();
    }

    public void clearAll() {
        ConnectAction.setConnectionType(true, true);
        this.m_projectsComboBox.removeAllItems();
        this.m_identificationTreeScrollPane.setViewportView(null);
        this.m_quantitationTreeScrollPane.setViewportView(null);
    }

    private JPanel createButtonPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 1, 5, 1);
        this.m_propertiesProjectButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PROPERTY_SMALL_10X10));
        this.m_propertiesProjectButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_propertiesProjectButton.setToolTipText("Display Project Properties");
        this.m_propertiesProjectButton.setEnabled(false);
        this.m_editProjectButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.EDIT_SMALL_10X10));
        this.m_editProjectButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_editProjectButton.setToolTipText("Edit Project Name and Description");
        this.m_editProjectButton.setEnabled(false);
        this.m_addProjectButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS_SMALL_10X10));
        this.m_addProjectButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_addProjectButton.setToolTipText("Create a New Project");
        this.m_addProjectButton.setEnabled(false);
        this.m_clearProjectButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.CLEAN_UP));
        this.m_clearProjectButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_clearProjectButton.setToolTipText("Clean Up Project (Remove unused Search Result and Id. Summaries)...");
        this.m_clearProjectButton.setEnabled(false);
        c.gridx = 0;
        c.gridy = 0;
        buttonsPanel.add((Component)this.m_propertiesProjectButton, c);
        ++c.gridx;
        buttonsPanel.add((Component)this.m_editProjectButton, c);
        ++c.gridx;
        buttonsPanel.add((Component)this.m_addProjectButton, c);
        ++c.gridx;
        this.m_addProjectButton.addActionListener(e -> this.addProjectActionPerformed());
        this.m_editProjectButton.addActionListener(e -> this.editProjectActionPerformed());
        this.m_propertiesProjectButton.addActionListener(e -> this.showPropertiesProjectActionPerformed());
        this.m_clearProjectButton.addActionListener(e -> this.clearProjectActionPerformed());
        return buttonsPanel;
    }

    private void addProjectActionPerformed() {
        AddProjectDialog dialog = AddProjectDialog.getAddProjectDialog((Window)WindowManager.getDefault().getMainWindow());
        int x = (int)this.m_addProjectButton.getLocationOnScreen().getX() + this.m_addProjectButton.getWidth();
        int y = (int)this.m_addProjectButton.getLocationOnScreen().getY() + this.m_addProjectButton.getHeight();
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0 && dialog.canModifyValues()) {
            ProjectItem item;
            String itemProjectName;
            String projectName = dialog.getProjectName();
            String projectDescription = dialog.getProjectDescription();
            UserAccount owner = DatabaseDataManager.getDatabaseDataManager().getLoggedUser();
            final ArrayList<UserAccount> userAccountList = dialog.getUserAccountList();
            int insertionIndex = 0;
            ComboBoxModel<ProjectItem> model = this.m_projectsComboBox.getModel();
            int nbChildren = model.getSize();
            for (int i = 0; i < nbChildren && projectName.compareToIgnoreCase(itemProjectName = (item = (ProjectItem)model.getElementAt(i)).toString()) >= 0; ++i) {
                insertionIndex = i + 1;
            }
            ProjectIdentificationData projectIdentificationData = new ProjectIdentificationData(projectName);
            ProjectQuantitationData projectQuantitationData = new ProjectQuantitationData(projectName);
            final ProjectItem projectItem = new ProjectItem(projectIdentificationData, projectQuantitationData);
            projectItem.setIsChanging(true);
            this.m_projectsComboBox.insertItemAt(projectItem, insertionIndex);
            this.m_projectsComboBox.setSelectedItem(projectItem);
            AbstractJMSCallback callback = new AbstractJMSCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success) {
                    if (success) {
                        projectItem.setIsChanging(false);
                        ProjectExplorerPanel.getProjectExplorerPanel().selectProject(projectItem);
                        ProjectExplorerPanel.this.m_projectsComboBox.repaint();
                        ProjectExplorerPanel.this.m_projectsComboBox.setSelectedIndex(ProjectExplorerPanel.this.m_projectsComboBox.getSelectedIndex());
                        if (!userAccountList.isEmpty()) {
                            DatabaseProjectTask task = new DatabaseProjectTask(null);
                            Project p = projectItem.getProjectIdentificationData().getProject();
                            task.initChangeSettingsOfProject(p, p.getName(), p.getDescription(), userAccountList);
                            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                        }
                    } else {
                        ProjectExplorerPanel.this.m_projectsComboBox.removeItem(projectItem);
                    }
                }
            };
            CreateProjectTask task = new CreateProjectTask(callback, projectName, projectDescription, owner.getId(), projectIdentificationData, projectQuantitationData);
            AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)task);
        }
    }

    private void editProjectActionPerformed() {
        final ProjectItem projectItem = (ProjectItem)this.m_projectsComboBox.getSelectedItem();
        if (projectItem == null) {
            return;
        }
        ProjectIdentificationData projectData = projectItem.getProjectIdentificationData();
        final Project project = projectData.getProject();
        final String oldName = project.getName();
        AddProjectDialog dialog = AddProjectDialog.getModifyProjectDialog((Window)WindowManager.getDefault().getMainWindow(), project);
        int x = (int)this.m_addProjectButton.getLocationOnScreen().getX() + this.m_addProjectButton.getWidth();
        int y = (int)this.m_addProjectButton.getLocationOnScreen().getY() + this.m_addProjectButton.getHeight();
        dialog.setLocation(x, y);
        dialog.setVisible(true);
        if (dialog.getButtonClicked() == 0 && dialog.canModifyValues()) {
            final String projectName = dialog.getProjectName();
            final String projectDescription = dialog.getProjectDescription();
            ArrayList<UserAccount> userAccountList = dialog.getUserAccountList();
            projectItem.setIsChanging(true);
            project.setName(projectName + "...");
            this.m_projectsComboBox.repaint();
            AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                public boolean mustBeCalledInAWT() {
                    return true;
                }

                public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                    if (success) {
                        projectItem.setIsChanging(false);
                        project.setName(projectName);
                        project.setDescription(projectDescription);
                        ProjectExplorerPanel.this.m_projectsComboBox.repaint();
                    } else {
                        projectItem.setIsChanging(false);
                        project.setName(oldName);
                        ProjectExplorerPanel.this.m_projectsComboBox.repaint();
                    }
                }
            };
            DatabaseProjectTask task = new DatabaseProjectTask(callback);
            task.initChangeSettingsOfProject(project, projectName, projectDescription, userAccountList);
            AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
        }
    }

    private void showPropertiesProjectActionPerformed() {
        ProjectItem projectItem = (ProjectItem)this.m_projectsComboBox.getSelectedItem();
        if (projectItem == null) {
            return;
        }
        ProjectIdentificationData projectData = projectItem.getProjectIdentificationData();
        String projectName = projectData.getName();
        Project project = projectItem.getProjectIdentificationData().getProject();
        WindowBox windowBox = WindowBoxFactory.getGenericWindowBox(projectName, "Properties", IconManager.IconType.DOCUMENT_LIST, true);
        ProjectPropertiesTableModel model = new ProjectPropertiesTableModel(project);
        windowBox.setEntryData(-1L, (Object)model);
        DataBoxViewerTopPanel win2 = new DataBoxViewerTopPanel(windowBox);
        WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win2);
    }

    private void clearProjectActionPerformed() {
        ProjectItem projectItem = (ProjectItem)this.m_projectsComboBox.getSelectedItem();
        if (projectItem == null) {
            return;
        }
        ProjectIdentificationData projectData = projectItem.getProjectIdentificationData();
        final Project project = projectData.getProject();
        final ArrayList data = new ArrayList();
        List<ClearProjectData> openedData = ProjectExplorerPanel.getOpenedData(project);
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                ProjectExplorerPanel.this.openClearProjectDialog(project, data);
            }
        };
        DatabaseClearProjectTask task = new DatabaseClearProjectTask(callback);
        task.initLoadDataToClearProject(project, data, openedData);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    public static List<ClearProjectData> getOpenedData(Project project) {
        ArrayList<ClearProjectData> openedData = new ArrayList<ClearProjectData>();
        long projectId = project.getId();
        String allImportedWindowsName = project.getName() + " : All Imported";
        HashSet tcs = WindowManager.getDefault().getMainWindow().getTopPanels();
        for (AbstractTopPanel topComponent : tcs) {
            long pId;
            if (!(topComponent instanceof DataBoxViewerTopPanel) || topComponent.getName().startsWith(allImportedWindowsName) || (pId = ((DataBoxViewerTopPanel)topComponent).getProjectId()) != projectId) continue;
            ParameterList inParam = ((DataBoxViewerTopPanel)topComponent).getInParameters();
            for (DataParameter dataParam : inParam.getParameterList()) {
                if (dataParam.equalsData(ResultSummary.class, ParameterSubtypeEnum.SINGLE_DATA)) {
                    ResultSummary rsm = (ResultSummary)((DataBoxViewerTopPanel)topComponent).getData(ResultSummary.class);
                    openedData.add(new ClearProjectData(projectId, rsm));
                    openedData.add(new ClearProjectData(projectId, rsm.getResultSet()));
                    continue;
                }
                if (!dataParam.equalsData(ResultSet.class, ParameterSubtypeEnum.SINGLE_DATA)) continue;
                ResultSet rs = (ResultSet)((DataBoxViewerTopPanel)topComponent).getData(ResultSet.class);
                openedData.add(new ClearProjectData(projectId, rs));
            }
            ParameterList outParam = ((DataBoxViewerTopPanel)topComponent).getOutParameters();
            for (DataParameter dataParam : outParam.getParameterList()) {
                if (dataParam.equalsData(ResultSummary.class, ParameterSubtypeEnum.SINGLE_DATA)) {
                    ResultSummary rsm = (ResultSummary)((DataBoxViewerTopPanel)topComponent).getData(ResultSummary.class);
                    openedData.add(new ClearProjectData(projectId, rsm));
                    openedData.add(new ClearProjectData(projectId, rsm.getResultSet()));
                    continue;
                }
                if (!dataParam.equalsData(ResultSet.class, ParameterSubtypeEnum.SINGLE_DATA)) continue;
                ResultSet rs = (ResultSet)((DataBoxViewerTopPanel)topComponent).getData(ResultSet.class);
                openedData.add(new ClearProjectData(projectId, rs));
            }
        }
        return openedData;
    }

    public void openClearProjectDialog(final Project project, List<ClearProjectData> data) {
        final ClearProjectDialog clearProjectDialog = new ClearProjectDialog((Window)WindowManager.getDefault().getMainWindow(), project, data);
        int x = (int)this.m_clearProjectButton.getLocationOnScreen().getX() + this.m_clearProjectButton.getWidth();
        int y = (int)this.m_clearProjectButton.getLocationOnScreen().getY() + this.m_clearProjectButton.getHeight();
        clearProjectDialog.setLocation(x, y);
        DefaultDialog.ProgressTask task = new DefaultDialog.ProgressTask(){

            public int getMinValue() {
                return 0;
            }

            public int getMaxValue() {
                return 100;
            }

            protected Object doInBackground() throws Exception {
                if (clearProjectDialog.canModifyValues()) {
                    List<ClearProjectData> dataToClear = clearProjectDialog.getSelectedData();
                    ArrayList rsmIds = new ArrayList();
                    ArrayList rsIds = new ArrayList();
                    dataToClear.forEach(d -> {
                        if (d.isResultSet()) {
                            rsIds.add(d.getResultSet().getId());
                        } else if (d.isResultSummary()) {
                            rsmIds.add(d.getResultSummary().getId());
                        }
                    });
                    AbstractJMSCallback clearCallBack = new AbstractJMSCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success) {
                            this.setProgress(100);
                        }
                    };
                    ClearProjectTask clearTaskDb = new ClearProjectTask(clearCallBack, Long.valueOf(project.getId()), rsmIds, rsIds);
                    AccessJMSManagerThread.getAccessJMSManagerThread().addTask((AbstractJMSTask)clearTaskDb);
                }
                return null;
            }
        };
        clearProjectDialog.setTask(task);
        clearProjectDialog.setVisible(true);
    }

    public void startLoadingProjects() {
        ConnectAction.setConnectionType(true, false);
        this.m_projectsComboBox.addItem(null);
        final ArrayList projectList = new ArrayList();
        AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

            public boolean mustBeCalledInAWT() {
                return true;
            }

            public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProjectExplorerPanel.this.m_projectsComboBox.removeAllItems();
                        int nbProjects = projectList.size();
                        if (nbProjects > 0) {
                            ProjectExplorerPanel.this.m_projectsComboBox.addItem(new ProjectItem(null, null));
                        }
                        for (AbstractData abstractData : projectList) {
                            ProjectIdentificationData identificationData = (ProjectIdentificationData)abstractData;
                            ProjectExplorerPanel.this.m_projectsComboBox.addItem(new ProjectItem(identificationData, new ProjectQuantitationData(identificationData.getProject())));
                        }
                        ProjectExplorerPanel.this.m_addProjectButton.setEnabled(true);
                        ProjectExplorerPanel.this.m_projectsComboBox.addActionListener(e -> {
                            ProjectItem item = (ProjectItem)ProjectExplorerPanel.this.m_projectsComboBox.getSelectedItem();
                            ProjectExplorerPanel.getProjectExplorerPanel().selectProject(item);
                            if (item != null && item.getProjectIdentificationData() != null && !item.isChanging()) {
                                DatabaseDataManager.getDatabaseDataManager().setCurrentProject(item.getProjectIdentificationData().getProject());
                                ProjectExplorerPanel.this.m_editProjectButton.setEnabled(true);
                                ProjectExplorerPanel.this.m_propertiesProjectButton.setEnabled(true);
                                ProjectExplorerPanel.this.m_clearProjectButton.setEnabled(true);
                                Preferences preferences = NbPreferences.root();
                                preferences.put("DefaultSelectedProject", item.getProjectIdentificationData().getName());
                            } else {
                                DatabaseDataManager.getDatabaseDataManager().setCurrentProject(null);
                                ProjectExplorerPanel.this.m_editProjectButton.setEnabled(false);
                                ProjectExplorerPanel.this.m_propertiesProjectButton.setEnabled(false);
                                ProjectExplorerPanel.this.m_clearProjectButton.setEnabled(false);
                            }
                        });
                        Preferences preferences = NbPreferences.root();
                        String defaultProjectName = preferences.get("DefaultSelectedProject", null);
                        if (defaultProjectName != null) {
                            int count = ProjectExplorerPanel.this.m_projectsComboBox.getItemCount();
                            for (int i = 0; i < count; ++i) {
                                ProjectItem item = (ProjectItem)ProjectExplorerPanel.this.m_projectsComboBox.getItemAt(i);
                                if (item == null || item.toString().compareTo(defaultProjectName) != 0) continue;
                                ProjectExplorerPanel.this.m_projectsComboBox.setSelectedItem(item);
                            }
                        }
                        ConnectAction.setConnectionType(false, true);
                    }
                });
            }
        };
        DatabaseProjectTask task = new DatabaseProjectTask(callback);
        task.initLoadProject(DatabaseDataManager.getDatabaseDataManager().getLoggedUserName(), projectList);
        AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
    }

    public void selectProject(ProjectItem projectItem) {
        if (projectItem == null || projectItem.isInactive()) {
            this.m_identificationTreeScrollPane.setViewportView(null);
            this.m_quantitationTreeScrollPane.setViewportView(null);
            if (projectItem != null && projectItem.isInactive()) {
                SwingUtilities.invokeLater(() -> {
                    InfoDialog infoDialog = new InfoDialog((Window)WindowManager.getDefault().getMainWindow(), InfoDialog.InfoType.WARNING, "Project Deleted", "Databases corresponding to this project have been deleted.\nAsk to your Administrator to restore them.");
                    infoDialog.setButtonVisible(1, false);
                    infoDialog.centerToWindow((Window)WindowManager.getDefault().getMainWindow());
                    infoDialog.setVisible(true);
                });
            }
            return;
        }
        ProjectIdentificationData projectIdentificationData = projectItem.getProjectIdentificationData();
        ProjectQuantitationData projectQuantitationData = projectItem.getProjectQuantitationData();
        if (!projectItem.isChanging() && projectIdentificationData != null) {
            IdentificationTree identificationTree = IdentificationTree.getTree(projectIdentificationData);
            QuantitationTree quantitationTree = QuantitationTree.getTree(projectQuantitationData);
            this.m_identificationTreeScrollPane.setViewportView(identificationTree);
            this.m_quantitationTreeScrollPane.setViewportView(quantitationTree);
        } else {
            this.m_identificationTreeScrollPane.setViewportView(null);
            this.m_quantitationTreeScrollPane.setViewportView(null);
        }
    }

    public static class ProjectItem {
        private ProjectIdentificationData m_projectIdentificationData;
        private ProjectQuantitationData m_projectQuantitationData;
        private boolean m_isChanging = false;
        private boolean m_active = true;

        public ProjectItem(ProjectIdentificationData projectIdentificationData, ProjectQuantitationData projectQuantitationData) {
            this.m_projectIdentificationData = projectIdentificationData;
            this.m_projectQuantitationData = projectQuantitationData;
        }

        public ProjectIdentificationData getProjectIdentificationData() {
            return this.m_projectIdentificationData;
        }

        public ProjectQuantitationData getProjectQuantitationData() {
            return this.m_projectQuantitationData;
        }

        public void setIsChanging(boolean v) {
            this.m_isChanging = v;
        }

        public boolean isChanging() {
            return this.m_isChanging;
        }

        public String toString() {
            if (this.m_projectIdentificationData == null) {
                return "< Select a Project >";
            }
            return this.m_projectIdentificationData.getName();
        }

        public void setIsActive(boolean v) {
            this.m_active = v;
        }

        public boolean isInactive() {
            return !this.m_active;
        }
    }

    public static class ProjectComboboxRenderer
    extends BasicComboBoxRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ProjectItem projectItem = (ProjectItem)value;
            if (index == -1 && projectItem == null) {
                return this;
            }
            if (projectItem == null) {
                l.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.HOUR_GLASS));
                l.setText("Loading Projects...");
            } else if (projectItem.getProjectIdentificationData() == null) {
                l.setIcon(null);
            } else if (projectItem.isChanging()) {
                l.setIcon(IconManager.getIconWithHourGlass((IconManager.IconType)IconManager.IconType.PROJECT));
            } else {
                JsonObject jsonObject;
                JsonPrimitive isActiveObject;
                Project project = projectItem.getProjectIdentificationData().getProject();
                JsonParser parser = new JsonParser();
                String serializedProperties = project.getSerializedProperties();
                boolean isActive = true;
                if (serializedProperties != null && (isActiveObject = (jsonObject = parser.parse(serializedProperties).getAsJsonObject()).getAsJsonPrimitive("is_active")) != null) {
                    isActive = isActiveObject.getAsBoolean();
                }
                projectItem.setIsActive(isActive);
                if (!isActive) {
                    l.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PROJECT_DELETED));
                } else if (DatabaseDataManager.getDatabaseDataManager().ownProject(project)) {
                    l.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PROJECT));
                } else {
                    l.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PROJECT_READ_ONLY));
                }
            }
            return this;
        }
    }
}

