/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui;

import fr.proline.core.orm.msi.ResultSet;
import fr.proline.core.orm.msi.ResultSummary;
import fr.proline.core.orm.msi.dto.DProteinSet;
import fr.proline.studio.WindowManager;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.dock.AbstractTopPanel;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.extendedtablemodel.AddDataAnalyzerButton;
import fr.proline.studio.extendedtablemodel.CompoundTableModel;
import fr.proline.studio.extendedtablemodel.ExtendedTableModelInterface;
import fr.proline.studio.extendedtablemodel.GlobalTabelModelProviderInterface;
import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.filter.FilterButton;
import fr.proline.studio.filter.FilterTableModelInterface;
import fr.proline.studio.graphics.CrossSelectionInterface;
import fr.proline.studio.gui.HourglassPanel;
import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.info.InfoInterface;
import fr.proline.studio.info.InfoToggleButton;
import fr.proline.studio.markerbar.AbstractMarker;
import fr.proline.studio.markerbar.BookmarkMarker;
import fr.proline.studio.markerbar.MarkerComponentInterface;
import fr.proline.studio.markerbar.MarkerContainerPanel;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.pattern.AbstractDataBox;
import fr.proline.studio.pattern.DataAnalyzerWindowBoxManager;
import fr.proline.studio.pattern.DataBoxPanelInterface;
import fr.proline.studio.pattern.SaveDataBoxActionListener;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.pattern.WindowBoxFactory;
import fr.proline.studio.pattern.WindowSavedManager;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.DataBoxViewerTopPanel;
import fr.proline.studio.rsmexplorer.actions.table.DisplayTablePopupMenu;
import fr.proline.studio.rsmexplorer.gui.model.ProteinSetTableModel;
import fr.proline.studio.search.SearchToggleButton;
import fr.proline.studio.table.ImportTableSelectionInterface;
import fr.proline.studio.table.LazyTable;
import fr.proline.studio.table.TableInfo;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class RsmProteinSetPanel
extends HourglassPanel
implements DataBoxPanelInterface,
GlobalTabelModelProviderInterface {
    private AbstractDataBox m_dataBox;
    private JScrollPane m_proteinSetScrollPane;
    private ProteinSetTable m_proteinSetTable;
    private MarkerContainerPanel m_markerContainerPanel;
    private final boolean m_firstPanel;
    private JButton m_decoyButton;
    private SearchToggleButton m_searchToggleButton;
    private InfoToggleButton m_infoToggleButton;
    private SettingsButton m_settingsButton;
    private FilterButton m_filterButton;
    private ExportButton m_exportButton;
    private AddDataAnalyzerButton m_addCompareDataButton;
    private boolean m_hideFirstTime = true;

    public RsmProteinSetPanel(boolean firstPanel) {
        this.m_firstPanel = firstPanel;
        this.initComponents();
    }

    public void setData(Long taskId, DProteinSet[] proteinSets, boolean finished) {
        boolean mergedData = false;
        ResultSummary rsm = (ResultSummary)this.m_dataBox.getData(ResultSummary.class);
        if (rsm != null) {
            ResultSet.Type rsType;
            if (this.m_firstPanel) {
                this.m_decoyButton.setEnabled(rsm.getDecoyResultSummary() != null);
            }
            mergedData = (rsType = rsm.getResultSet().getType()) == ResultSet.Type.USER || rsType == ResultSet.Type.DECOY_USER;
        }
        ProteinSetTableModel tableModel = (ProteinSetTableModel)((CompoundTableModel)this.m_proteinSetTable.getModel()).getBaseModel();
        tableModel.setData(taskId, proteinSets, mergedData);
        if (proteinSets != null && proteinSets.length > 0) {
            this.m_proteinSetTable.getSelectionModel().setSelectionInterval(0, 0);
            this.m_markerContainerPanel.setMaxLineNumber(proteinSets.length);
            if (!this.m_firstPanel) {
                this.m_markerContainerPanel.removeAllMarkers();
            }
            if (this.m_hideFirstTime) {
                List<Integer> listIdsToHide = tableModel.getDefaultColumnsToHide();
                for (Integer id : listIdsToHide) {
                    this.m_proteinSetTable.getColumnExt(this.m_proteinSetTable.convertColumnIndexToView(id)).setVisible(false);
                }
                this.m_hideFirstTime = false;
            }
        }
        this.m_infoToggleButton.updateInfo();
        if (finished) {
            this.m_proteinSetTable.setSortable(true);
        }
    }

    public void dataUpdated(SubTask subTask, boolean finished) {
        this.m_proteinSetTable.dataUpdated(subTask, finished);
        if (this.m_hideFirstTime) {
            List<Integer> listIdsToHide = ((ProteinSetTableModel)((CompoundTableModel)this.m_proteinSetTable.getModel()).getBaseModel()).getDefaultColumnsToHide();
            for (Integer id : listIdsToHide) {
                this.m_proteinSetTable.getColumnExt(this.m_proteinSetTable.convertColumnIndexToView(id)).setVisible(false);
            }
            this.m_hideFirstTime = false;
        }
    }

    public DProteinSet getSelectedProteinSet() {
        int selectedRow = this.m_proteinSetTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        selectedRow = this.m_proteinSetTable.convertRowIndexToModel(selectedRow);
        CompoundTableModel compoundTableModel = (CompoundTableModel)this.m_proteinSetTable.getModel();
        selectedRow = compoundTableModel.convertCompoundRowToBaseModelRow(selectedRow);
        ProteinSetTableModel tableModel = (ProteinSetTableModel)compoundTableModel.getBaseModel();
        return tableModel.getProteinSet(selectedRow);
    }

    @Override
    public void setDataBox(AbstractDataBox dataBox) {
        this.m_dataBox = dataBox;
    }

    @Override
    public AbstractDataBox getDataBox() {
        return this.m_dataBox;
    }

    @Override
    public void addSingleValue(Object v) {
        this.getGlobalTableModelInterface().addSingleValue(v);
    }

    public GlobalTableModelInterface getGlobalTableModelInterface() {
        return (GlobalTableModelInterface)this.m_proteinSetTable.getModel();
    }

    public JXTable getGlobalAssociatedTable() {
        return this.m_proteinSetTable;
    }

    public CrossSelectionInterface getCrossSelectionInterface() {
        return this.m_proteinSetTable;
    }

    public ActionListener getRemoveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getRemoveAction(splittedPanel);
    }

    public ActionListener getAddAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getAddAction(splittedPanel);
    }

    public ActionListener getSaveAction(SplittedPanelContainer splittedPanel) {
        return this.m_dataBox.getSaveAction(splittedPanel);
    }

    private String getTopComponentName() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof AbstractTopPanel); c = c.getParent()) {
        }
        if (c != null && c instanceof AbstractTopPanel) {
            return ((AbstractTopPanel)c).getTitle();
        }
        return "";
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        final JPanel proteinSetPanel = this.createProteinSetPanel();
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                Component c = e.getComponent();
                proteinSetPanel.setBounds(0, 0, c.getWidth(), c.getHeight());
                layeredPane.revalidate();
                layeredPane.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(layeredPane, "Center");
        layeredPane.add((Component)proteinSetPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.m_infoToggleButton.getInfoPanel(), JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.m_searchToggleButton.getSearchPanel(), new Integer(JLayeredPane.PALETTE_LAYER + 1));
    }

    private JPanel createProteinSetPanel() {
        JPanel proteinSetPanel = new JPanel();
        proteinSetPanel.setBounds(0, 0, 500, 400);
        proteinSetPanel.setLayout(new BorderLayout());
        JPanel internalPanel = this.createInternalPanel();
        JToolBar toolbar = this.initToolbar();
        proteinSetPanel.add((Component)toolbar, "West");
        proteinSetPanel.add((Component)internalPanel, "Center");
        return proteinSetPanel;
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        if (this.m_firstPanel) {
            this.m_decoyButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DATASET_RSM_DECOY));
            this.m_decoyButton.setToolTipText("Display Decoy Data");
            this.m_decoyButton.setEnabled(false);
            this.m_decoyButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ResultSummary rsm = (ResultSummary)RsmProteinSetPanel.this.m_dataBox.getData(ResultSummary.class);
                    ResultSummary decoyRsm = rsm.getDecoyResultSummary();
                    if (decoyRsm == null) {
                        return;
                    }
                    String savedWindow = SaveDataBoxActionListener.saveParentContainer("tmp", RsmProteinSetPanel.this.m_decoyButton);
                    AbstractDataBox[] databoxes = WindowSavedManager.readBoxes(savedWindow);
                    WindowBox wbox = WindowBoxFactory.getFromBoxesWindowBox("Decoy " + RsmProteinSetPanel.this.getTopComponentName(), databoxes, true, false, '2');
                    wbox.setEntryData(RsmProteinSetPanel.this.m_dataBox.getProjectId(), decoyRsm);
                    DataBoxViewerTopPanel win = new DataBoxViewerTopPanel(wbox);
                    WindowManager.getDefault().getMainWindow().displayWindow((AbstractTopPanel)win);
                }
            });
            toolbar.add(this.m_decoyButton);
        }
        this.m_settingsButton = new SettingsButton((ProgressInterface)this.m_proteinSetTable.getModel(), (SettingsInterface)this.m_proteinSetTable);
        this.m_searchToggleButton = new SearchToggleButton((ProgressInterface)this.m_proteinSetTable, (JXTable)this.m_proteinSetTable, (FilterTableModelInterface)((CompoundTableModel)this.m_proteinSetTable.getModel()));
        toolbar.add((Component)this.m_searchToggleButton);
        this.m_filterButton = new FilterButton((FilterTableModelInterface)((CompoundTableModel)this.m_proteinSetTable.getModel())){

            protected void filteringDone() {
                RsmProteinSetPanel.this.m_dataBox.addDataChanged(ExtendedTableModelInterface.class);
                RsmProteinSetPanel.this.m_dataBox.propagateDataChanged();
                RsmProteinSetPanel.this.m_infoToggleButton.updateInfo();
            }
        };
        this.m_exportButton = new ExportButton((ProgressInterface)((CompoundTableModel)this.m_proteinSetTable.getModel()), "Protein Sets", (JXTable)this.m_proteinSetTable);
        toolbar.add((Component)this.m_filterButton);
        toolbar.add((Component)this.m_settingsButton);
        toolbar.add((Component)this.m_exportButton);
        this.m_addCompareDataButton = new AddDataAnalyzerButton((ProgressInterface)((CompoundTableModel)this.m_proteinSetTable.getModel())){

            public void actionPerformed() {
                JXTable table = RsmProteinSetPanel.this.getGlobalAssociatedTable();
                TableInfo tableInfo = new TableInfo(RsmProteinSetPanel.this.m_dataBox.getId(), RsmProteinSetPanel.this.m_dataBox.getUserName(), RsmProteinSetPanel.this.m_dataBox.getDataName(), RsmProteinSetPanel.this.m_dataBox.getTypeName(), table);
                Image i = RsmProteinSetPanel.this.m_dataBox.getIcon();
                if (i != null) {
                    tableInfo.setIcon(new ImageIcon(i));
                }
                DataAnalyzerWindowBoxManager.addTableInfo(tableInfo);
            }
        };
        toolbar.add((Component)this.m_addCompareDataButton);
        this.m_infoToggleButton = new InfoToggleButton((ProgressInterface)this.m_proteinSetTable, (InfoInterface)this.m_proteinSetTable);
        toolbar.add((Component)this.m_infoToggleButton);
        return toolbar;
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_proteinSetScrollPane = new JScrollPane();
        this.m_proteinSetTable = new ProteinSetTable();
        this.m_proteinSetTable.setModel((TableModel)new CompoundTableModel((GlobalTableModelInterface)new ProteinSetTableModel(this.m_proteinSetTable), true));
        this.m_proteinSetTable.getColumnExt(this.m_proteinSetTable.convertColumnIndexToView(0)).setVisible(false);
        this.m_markerContainerPanel = new MarkerContainerPanel(this.m_proteinSetScrollPane, (MarkerComponentInterface)this.m_proteinSetTable);
        this.m_proteinSetScrollPane.setViewportView((Component)((Object)this.m_proteinSetTable));
        this.m_proteinSetTable.setFillsViewportHeight(true);
        this.m_proteinSetTable.setViewport(this.m_proteinSetScrollPane.getViewport());
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        internalPanel.add((Component)this.m_markerContainerPanel, c);
        return internalPanel;
    }

    public void selectData(HashSet data) {
        this.m_proteinSetTable.importSelection(data);
    }

    private class ProteinSetTable
    extends LazyTable
    implements ImportTableSelectionInterface,
    CrossSelectionInterface,
    InfoInterface {
        private boolean selectionWillBeRestored;
        private DisplayTablePopupMenu m_popupMenu;

        public ProteinSetTable() {
            super(RsmProteinSetPanel.this.m_proteinSetScrollPane.getVerticalScrollBar());
            this.selectionWillBeRestored = false;
        }

        public void addTableModelListener(TableModelListener l) {
            this.getModel().addTableModelListener(l);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            super.valueChanged(e);
            if (this.selectionWillBeRestored) {
                return;
            }
            if (e.getValueIsAdjusting()) {
                return;
            }
            RsmProteinSetPanel.this.m_dataBox.addDataChanged(DProteinSet.class);
            RsmProteinSetPanel.this.m_dataBox.propagateDataChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dataUpdated(SubTask subTask, boolean finished) {
            LazyTable.LastAction keepLastAction = this.m_lastAction;
            try {
                int rowSelected = this.getSelectionModel().getMinSelectionIndex();
                int rowSelectedInModel = rowSelected == -1 ? -1 : this.convertRowIndexToModel(rowSelected);
                this.selectionWillBeRestored(true);
                try {
                    ((ProteinSetTableModel)((CompoundTableModel)this.getModel()).getBaseModel()).dataUpdated();
                }
                finally {
                    this.selectionWillBeRestored(false);
                }
                if (rowSelectedInModel != -1) {
                    int rowSelectedInView = this.convertRowIndexToView(rowSelectedInModel);
                    this.setSelection(rowSelectedInView);
                    if ((keepLastAction == LazyTable.LastAction.ACTION_SELECTING || keepLastAction == LazyTable.LastAction.ACTION_SORTING) && subTask.getSubTaskId() == ((CompoundTableModel)this.getModel()).getSubTaskId(this.getSortedColumnIndex())) {
                        this.scrollRowToVisible(rowSelectedInView);
                    }
                }
            }
            finally {
                this.m_lastAction = keepLastAction;
            }
            if (finished) {
                this.setSortable(true);
            }
        }

        public void selectionWillBeRestored(boolean b) {
            this.selectionWillBeRestored = b;
        }

        public int getLoadingPercentage() {
            return RsmProteinSetPanel.this.m_dataBox.getLoadingPercentage();
        }

        public boolean isLoaded() {
            return RsmProteinSetPanel.this.m_dataBox.isLoaded();
        }

        public void importSelection(HashSet selectedData) {
            ListSelectionModel selectionTableModel = this.getSelectionModel();
            selectionTableModel.clearSelection();
            int firstRow = -1;
            ProteinSetTableModel model = (ProteinSetTableModel)((CompoundTableModel)RsmProteinSetPanel.this.m_proteinSetTable.getModel()).getBaseModel();
            int rowCount = model.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                Object v = model.getValueAt(i, 0);
                if (!selectedData.remove(v)) continue;
                if (firstRow == -1) {
                    firstRow = i;
                }
                selectionTableModel.addSelectionInterval(i, i);
                BookmarkMarker marker = new BookmarkMarker(i);
                RsmProteinSetPanel.this.m_markerContainerPanel.addMarker((AbstractMarker)marker);
                if (selectedData.isEmpty()) break;
            }
            if (firstRow != -1) {
                int row = firstRow;
                this.scrollToVisible(row);
            }
        }

        public TablePopupMenu initPopupMenu() {
            this.m_popupMenu = new DisplayTablePopupMenu(RsmProteinSetPanel.this);
            return this.m_popupMenu;
        }

        public void prepostPopupMenu() {
            this.m_popupMenu.prepostPopupMenu();
        }

        public String getInfo() {
            int count = this.getModel().getRowCount();
            return count + (count > 1 ? " Proteins Sets" : " Protein Set");
        }
    }
}

