/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.admin;

import fr.proline.core.orm.uds.FragmentationRule;
import fr.proline.core.orm.uds.FragmentationRuleSet;
import fr.proline.studio.dam.AccessDatabaseThread;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.dam.tasks.AbstractDatabaseCallback;
import fr.proline.studio.dam.tasks.AbstractDatabaseTask;
import fr.proline.studio.dam.tasks.DatabaseAdminTask;
import fr.proline.studio.dam.tasks.SubTask;
import fr.proline.studio.export.ExportButton;
import fr.proline.studio.parameter.SettingsButton;
import fr.proline.studio.parameter.SettingsInterface;
import fr.proline.studio.progress.ProgressInterface;
import fr.proline.studio.rsmexplorer.gui.admin.FragmentationRuleSetDialog;
import fr.proline.studio.table.DecoratedTable;
import fr.proline.studio.table.DecoratedTableModel;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.TablePopupMenu;
import fr.proline.studio.table.renderer.DefaultLeftAlignRenderer;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class FragmentationRuleSetPanel
extends JPanel {
    private JDialog m_dialogOwner = null;
    private FragmentationRuleSetTable m_fragmentRuleSetsTable = null;
    private Boolean m_isEditable = true;

    public FragmentationRuleSetPanel(JDialog dialog) {
        this(dialog, (Boolean)true);
    }

    public FragmentationRuleSetPanel(JDialog dialog, Boolean editable) {
        this.m_dialogOwner = dialog;
        this.m_isEditable = editable;
        this.setBorder(BorderFactory.createTitledBorder("Fragmentation Rule Sets"));
        this.setLayout(new GridBagLayout());
        JScrollPane tableScrollPane = new JScrollPane();
        this.m_fragmentRuleSetsTable = new FragmentationRuleSetTable();
        tableScrollPane.setViewportView((Component)((Object)this.m_fragmentRuleSetsTable));
        this.m_fragmentRuleSetsTable.setFillsViewportHeight(true);
        JButton addFRSButton = new JButton("Add Fragmentation Rule Set");
        addFRSButton.setIcon(IconManager.getIcon((IconManager.IconType)IconManager.IconType.PLUS_16X16));
        addFRSButton.setEnabled(this.m_isEditable);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 0;
        JToolBar toolbar = this.initToolbar();
        this.add((Component)toolbar, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.fill = 1;
        this.add((Component)tableScrollPane, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 0.0;
        this.add(Box.createHorizontalGlue(), c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)addFRSButton, c);
        addFRSButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FragmentationRuleSetDialog frsDialog = FragmentationRuleSetDialog.getDialog(FragmentationRuleSetPanel.this.m_dialogOwner);
                frsDialog.setLocationRelativeTo(FragmentationRuleSetPanel.this.m_dialogOwner);
                frsDialog.setVisible(true);
                if (frsDialog.getButtonClicked() == 0) {
                    JOptionPane.showConfirmDialog(FragmentationRuleSetPanel.this.m_dialogOwner, "Are you sure you want to create " + frsDialog.getName() + " ?\n It will be saved in Datastore. No remove will be possible.");
                    AbstractDatabaseCallback callback = new AbstractDatabaseCallback(){

                        public boolean mustBeCalledInAWT() {
                            return true;
                        }

                        public void run(boolean success, long taskId, SubTask subTask, boolean finished) {
                            if (success) {
                                FragmentationRuleSetPanel.this.m_fragmentRuleSetsTable.updateFragmentationRuleSets();
                            }
                        }
                    };
                    DatabaseAdminTask task = new DatabaseAdminTask(callback);
                    task.initAddFragmentationRuleSet(frsDialog.getName(), frsDialog.getSelectedFragmentationRule());
                    AccessDatabaseThread.getAccessDatabaseThread().addTask((AbstractDatabaseTask)task);
                }
            }
        });
    }

    private JToolBar initToolbar() {
        JToolBar toolbar = new JToolBar(1);
        toolbar.setFloatable(false);
        SettingsButton m_settingsButton = new SettingsButton((ProgressInterface)this.m_fragmentRuleSetsTable.getModel(), (SettingsInterface)this.m_fragmentRuleSetsTable);
        ExportButton exportButton = new ExportButton((ProgressInterface)this.m_fragmentRuleSetsTable.getModel(), "Fragmentation Rule Set", (JXTable)this.m_fragmentRuleSetsTable);
        toolbar.add((Component)m_settingsButton);
        toolbar.add((Component)exportButton);
        return toolbar;
    }

    private class FragmentationRuleSetTableModel
    extends DecoratedTableModel
    implements ProgressInterface {
        private ArrayList<FragmentationRuleSet> m_fragmentationRuleSetArray = null;
        private FragmentationRule[] m_rules = DatabaseDataManager.getDatabaseDataManager().getFragmentationRulesArray();
        TableCellRenderer m_renderer = null;

        public FragmentationRuleSetTableModel(FragmentationRuleSet[] fragmentationRuleSets) {
            this.m_fragmentationRuleSetArray = new ArrayList(fragmentationRuleSets.length);
            this.m_fragmentationRuleSetArray.addAll(Arrays.asList(fragmentationRuleSets));
            this.m_renderer = new DefaultLeftAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class));
        }

        public void setData(FragmentationRuleSet[] fragmentationRuleSets) {
            this.m_fragmentationRuleSetArray.clear();
            this.m_fragmentationRuleSetArray.addAll(Arrays.asList(fragmentationRuleSets));
            this.fireTableStructureChanged();
        }

        public int getRowCount() {
            return this.m_rules.length;
        }

        public int getColumnCount() {
            int nbCol = 2;
            if (this.m_fragmentationRuleSetArray != null) {
                nbCol += this.m_fragmentationRuleSetArray.size();
            }
            return nbCol;
        }

        public String getColumnName(int col) {
            if (col == 0 || col == this.m_fragmentationRuleSetArray.size() + 1) {
                return "Ion Series";
            }
            return this.m_fragmentationRuleSetArray.get(col - 1).getName();
        }

        public Class getColumnClass(int col) {
            return String.class;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0 || columnIndex == this.m_fragmentationRuleSetArray.size() + 1) {
                String name = this.m_rules[rowIndex].getDescription();
                if (this.m_rules[rowIndex].getFragmentationSeries() != null) {
                    name = this.m_rules[rowIndex].getFragmentationSeries().getName();
                }
                return name;
            }
            FragmentationRuleSet fragmRuleSet = this.m_fragmentationRuleSetArray.get(columnIndex - 1);
            for (FragmentationRule nextFr : fragmRuleSet.getFragmentationRules()) {
                if (nextFr.getId() != (long)(rowIndex + 1)) continue;
                return "x";
            }
            return "";
        }

        public String getToolTipForHeader(int col) {
            return this.getColumnName(col);
        }

        public String getTootlTipValue(int row, int col) {
            if (col == 0 || col == this.m_fragmentationRuleSetArray.size() + 1) {
                return this.m_rules[row].getDescription();
            }
            return "Indicate if ion serie is defined in " + this.getToolTipForHeader(col);
        }

        public TableCellRenderer getRenderer(int row, int col) {
            return this.m_renderer;
        }

        public boolean isLoaded() {
            return true;
        }

        public int getLoadingPercentage() {
            return 100;
        }
    }

    private class FragmentationRuleSetTable
    extends DecoratedTable {
        public FragmentationRuleSetTable() {
            this.setSortable(false);
            this.initData();
        }

        private void initData() {
            FragmentationRuleSet[] allFragmRuleSet = DatabaseDataManager.getDatabaseDataManager().getFragmentationRuleSetsArray();
            FragmentationRuleSetTableModel model = new FragmentationRuleSetTableModel(allFragmRuleSet);
            this.setModel((TableModel)((Object)model));
            this.setRowSelectionInterval(0, 0);
        }

        public void updateFragmentationRuleSets() {
            FragmentationRuleSetTableModel tableModel = (FragmentationRuleSetTableModel)((Object)this.getModel());
            FragmentationRuleSet[] allFragmRuleSet = DatabaseDataManager.getDatabaseDataManager().getFragmentationRuleSetsArray();
            tableModel.setData(allFragmRuleSet);
        }

        public TablePopupMenu initPopupMenu() {
            return null;
        }

        public void prepostPopupMenu() {
        }
    }
}

