/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc;

import fr.proline.studio.gui.SplittedPanelContainer;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphGroup;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphNode;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class ProcessEngine
implements ProcessCallbackInterface {
    private static ProcessEngine m_processEngine = null;
    private int m_processEngineKey = 0;
    private String m_currentMacro = null;
    private GraphPanel m_panel;
    private JButton m_playButton;
    private boolean m_runAll = false;
    private final LinkedList<GraphNode> m_processingNodeList = new LinkedList();

    private ProcessEngine() {
    }

    public static ProcessEngine getProcessEngine() {
        if (m_processEngine == null) {
            m_processEngine = new ProcessEngine();
        }
        return m_processEngine;
    }

    public void setRunAll(boolean v) {
        this.m_runAll = v;
    }

    public boolean isRunAll() {
        return this.m_runAll;
    }

    public String getProcessName() {
        if (this.m_currentMacro != null) {
            return this.m_currentMacro;
        }
        return "Results";
    }

    public void run(LinkedList<GraphNode> graphNodeArray, GraphPanel panel, JButton playButton) {
        this.setRunAll(true);
        ++this.m_processEngineKey;
        this.m_panel = panel;
        this.m_playButton = playButton;
        this.m_processingNodeList.clear();
        for (GraphNode node : graphNodeArray) {
            if (node.hasInConnector()) continue;
            this.m_processingNodeList.add(node);
        }
        this.processNodes();
    }

    public Integer getProcessEngineKey(boolean bumpKey) {
        if (bumpKey) {
            ++this.m_processEngineKey;
        }
        return this.m_processEngineKey;
    }

    public void runANode(GraphNode node, GraphPanel panel) {
        this.setRunAll(false);
        this.m_panel = panel;
        this.m_playButton = null;
        this.m_processingNodeList.add(node);
        this.processNodes();
    }

    private void processNodes() {
        GraphNode firstNode = this.m_processingNodeList.pollFirst();
        this.process(firstNode);
    }

    @Override
    public void reprocess(GraphNode node) {
        this.process(node);
    }

    private void process(GraphNode node) {
        node.setHighlighted(true);
        this.m_panel.repaint();
        GraphGroup group = node.getGroup();
        this.m_currentMacro = group != null ? group.getGroupName() : null;
        node.process(this);
    }

    @Override
    public void stopped(GraphNode node) {
        node.setHighlighted(false);
        this.m_panel.repaint();
        this.m_processingNodeList.clear();
        if (this.m_playButton != null) {
            this.m_playButton.setEnabled(true);
            this.m_playButton = null;
        }
        this.m_panel = null;
        this.m_runAll = false;
    }

    @Override
    public void finished(GraphNode node) {
        LinkedList<GraphNode> nextNodes;
        node.setHighlighted(false);
        ArrayList<SplittedPanelContainer.PanelLayout> layout = node.getAutoDisplayLayoutDuringProcess();
        if (layout != null) {
            this.m_panel.displayBelow(node, false, null, layout, -1);
        }
        this.m_panel.repaint();
        if (this.m_runAll && (nextNodes = node.getOutLinkedGraphNodes()) != null) {
            for (GraphNode nextNode : nextNodes) {
                this.m_processingNodeList.add(nextNode);
            }
        }
        if (!this.m_processingNodeList.isEmpty()) {
            final GraphNode firstNode = this.m_processingNodeList.pollFirst();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProcessEngine.this.process(firstNode);
                }
            });
        } else {
            if (this.m_playButton != null) {
                this.m_playButton.setEnabled(true);
                this.m_playButton = null;
            }
            this.m_panel = null;
            this.m_currentMacro = null;
            this.m_runAll = false;
        }
    }
}

