/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.pattern.WindowBox;
import fr.proline.studio.python.data.Col;
import fr.proline.studio.python.data.ColDoubleData;
import fr.proline.studio.python.data.ColRef;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcCallback;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.python.interpreter.CalcInterpreterTask;
import fr.proline.studio.python.interpreter.CalcInterpreterThread;
import fr.proline.studio.python.interpreter.ResultVariable;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.graph.FunctionGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.table.TableDefaultRendererManager;
import fr.proline.studio.table.renderer.DefaultRightAlignRenderer;
import fr.proline.studio.table.renderer.DoubleRenderer;
import fr.proline.studio.types.PValue;
import fr.proline.studio.types.PvalueAdjusted;
import java.util.ArrayList;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import org.python.core.PyObject;

public class AdjustPFunction
extends AbstractFunction {
    private static final String SEL_COLS1 = "SEL_COLS1";
    private static final String PI0PARAMETER = "PI0PARAMETER";
    private static final String ALPHAPARAMETER = "ALPHAPARAMETER";
    private static final String NBBINSPARAMETER = "NBBINSPARAMETER";
    private static final String PZPARAMETER = "PZPARAMETER";
    private static final String NUMERICVALUEARAMETER = "NUMERICVALUEARAMETER";
    private ObjectParameter m_columnsParameter1 = null;
    private ObjectParameter m_pi0MethodParameter = null;
    private DoubleParameter m_numericValueParameter = null;
    private DoubleParameter m_alphaParameter = null;
    private IntegerParameter m_nbinsParameter = null;
    private DoubleParameter m_pzParameter = null;

    public AdjustPFunction(GraphPanel panel) {
        super(panel, AbstractFunction.FUNCTION_TYPE.AdjustPFunction);
    }

    @Override
    public void inLinkModified() {
        super.inLinkModified();
        this.m_columnsParameter1 = null;
        this.m_pi0MethodParameter = null;
        this.m_numericValueParameter = null;
        this.m_alphaParameter = null;
        this.m_nbinsParameter = null;
        this.m_pzParameter = null;
    }

    @Override
    public String getName(int index) {
        if (this.m_pi0MethodParameter == null) {
            return "PValue Adjustment";
        }
        StringBuilder columnNameSb = new StringBuilder("PValue Adjustment ");
        String pi0Method = this.m_pi0MethodParameter.getStringValue();
        if (pi0Method.compareTo("Numeric Value") == 0) {
            columnNameSb.append(this.m_numericValueParameter.getStringValue());
        } else {
            columnNameSb.append(pi0Method);
        }
        return columnNameSb.toString();
    }

    @Override
    public int getNumberOfInParameters() {
        return 1;
    }

    @Override
    public int getNumberOfOutParameters() {
        return 1;
    }

    @Override
    public void process(GraphConnector[] graphObjects, final FunctionGraphNode functionGraphNode, final ProcessCallbackInterface callback) {
        this.setInError(false, null);
        if (this.m_parameters == null) {
            callback.finished(functionGraphNode);
            return;
        }
        Integer colIndex = (Integer)this.m_columnsParameter1.getAssociatedObjectValue();
        if (colIndex == null || colIndex == -1) {
            callback.finished(functionGraphNode);
            return;
        }
        if (this.m_globalTableModelInterface != null) {
            callback.finished(functionGraphNode);
            return;
        }
        this.setCalculating(true);
        try {
            GlobalTableModelInterface srcModel = graphObjects[0].getGlobalTableModelInterface();
            final Table sourceTable = new Table(srcModel);
            ResultVariable[] parameters = new ResultVariable[1];
            ColRef col = sourceTable.getCol(colIndex.intValue());
            parameters[0] = new ResultVariable((PyObject)col);
            StringBuilder codeSB = new StringBuilder();
            StringBuilder columnNameSb = new StringBuilder();
            AdjustPFunction.createRCode(codeSB, columnNameSb, parameters, this.m_pi0MethodParameter, this.m_numericValueParameter, this.m_alphaParameter, this.m_nbinsParameter, this.m_pzParameter);
            final String columnName = columnNameSb.toString();
            CalcCallback calcCallback = new CalcCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ArrayList<ResultVariable> variables, CalcError error) {
                    try {
                        if (variables != null) {
                            for (ResultVariable var : variables) {
                                if (var.getName().compareTo("adjustP") != 0) continue;
                                ColDoubleData col = (ColDoubleData)var.getValue();
                                col.setColumnName(columnName);
                                sourceTable.addColumn((Col)col, (Object)new PvalueAdjusted(), (TableCellRenderer)new DoubleRenderer((TableCellRenderer)new DefaultRightAlignRenderer(TableDefaultRendererManager.getDefaultRenderer(String.class)), 4, true, true));
                                AdjustPFunction.this.addModel(sourceTable.getModel());
                            }
                        } else if (error != null) {
                            AdjustPFunction.this.setInError(error);
                        }
                        AdjustPFunction.this.setCalculating(false);
                    }
                    finally {
                        callback.finished(functionGraphNode);
                    }
                }
            };
            CalcInterpreterTask task = new CalcInterpreterTask(codeSB.toString(), parameters, calcCallback);
            CalcInterpreterThread.getCalcInterpreterThread().addTask(task);
        }
        catch (Exception e) {
            this.setInError(new CalcError((Throwable)e, null, -1));
            this.setCalculating(false);
            callback.finished(functionGraphNode);
        }
    }

    public static void createRCode(StringBuilder codeSB, StringBuilder columnNameSb, ResultVariable[] parameters, ObjectParameter pi0MethodParameter, DoubleParameter numericValueParameter, DoubleParameter alphaParameter, IntegerParameter nbinsParameter, DoubleParameter pzParameter) {
        codeSB.append("adjustP=Stats.adjustP(");
        for (int i = 0; i < parameters.length; ++i) {
            codeSB.append(parameters[i].getName());
        }
        columnNameSb.append("adjustP ");
        String pi0Method = pi0MethodParameter.getStringValue();
        if (pi0Method.compareTo("Numeric Value") == 0) {
            codeSB.append(',');
            codeSB.append(numericValueParameter.getStringValue());
            columnNameSb.append(numericValueParameter.getStringValue());
        } else {
            codeSB.append(",\"").append(pi0Method).append("\"");
            columnNameSb.append(pi0Method);
        }
        codeSB.append(",").append(alphaParameter.getStringValue());
        codeSB.append(",").append(nbinsParameter.getStringValue());
        codeSB.append(",").append(pzParameter.getStringValue());
        codeSB.append(')');
    }

    @Override
    public void askDisplay(FunctionGraphNode functionGraphNode, int index) {
        this.display(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public ArrayList<WindowBox> getDisplayWindowBox(FunctionGraphNode functionGraphNode, int index) {
        return this.getDisplayWindowBoxList(functionGraphNode.getPreviousDataName(), this.getName(index), index);
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        GlobalTableModelInterface model1 = graphObjects[0].getGlobalTableModelInterface();
        int nbColumns = model1.getColumnCount();
        int nbColumnsKept = 0;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(Float.class) && !c.equals(Double.class)) continue;
            ++nbColumnsKept;
        }
        Object[] objectArray1 = new Object[nbColumnsKept];
        Object[] associatedObjectArray1 = new Object[nbColumnsKept];
        int iKept = 0;
        int selectedIndex1 = -1;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(Float.class) && !c.equals(Double.class)) continue;
            objectArray1[iKept] = model1.getColumnName(i);
            PValue pvalue = (PValue)model1.getColValue(PValue.class, i);
            if (pvalue != null) {
                selectedIndex1 = iKept;
            }
            associatedObjectArray1[iKept] = i + 1;
            ++iKept;
        }
        ParameterList parameterList1 = new ParameterList("param1");
        this.m_columnsParameter1 = new ObjectParameter(SEL_COLS1, "P Values Column", null, objectArray1, associatedObjectArray1, selectedIndex1, null);
        Object[] pi0Values = new String[]{"Numeric Value", "abh", "bky", "jiang", "histo", "langaas", "pounds", "slim", "st.boot", "st.spline"};
        this.m_pi0MethodParameter = new ObjectParameter(PI0PARAMETER, "pi0 Method", pi0Values, 0, null);
        this.m_numericValueParameter = new DoubleParameter(NUMERICVALUEARAMETER, "Pi0 Value", JTextField.class, Double.valueOf(1.0), Double.valueOf(0.0), Double.valueOf(1.0));
        this.m_alphaParameter = new DoubleParameter(ALPHAPARAMETER, "Alpha", JTextField.class, Double.valueOf(0.05), Double.valueOf(0.0), Double.valueOf(1.0));
        this.m_nbinsParameter = new IntegerParameter(NBBINSPARAMETER, "Number of Bins", JSpinner.class, Integer.valueOf(20), Integer.valueOf(5), Integer.valueOf(100));
        this.m_pzParameter = new DoubleParameter(PZPARAMETER, "Pz", JTextField.class, Double.valueOf(0.05), Double.valueOf(0.01), Double.valueOf(0.1));
        AbstractLinkedParameters linkedParameters = new AbstractLinkedParameters(parameterList1){

            public void valueChanged(String value, Object associatedValue) {
                this.showParameter((AbstractParameter)AdjustPFunction.this.m_numericValueParameter, value.compareTo("Numeric Value") == 0);
                this.showParameter((AbstractParameter)AdjustPFunction.this.m_alphaParameter, value.compareTo("bky") == 0);
                this.showParameter((AbstractParameter)AdjustPFunction.this.m_nbinsParameter, value.compareTo("jiang") == 0 || value.compareTo("histo") == 0);
                this.showParameter((AbstractParameter)AdjustPFunction.this.m_pzParameter, value.compareTo("slim") == 0);
                this.updateParameterListPanel();
            }
        };
        this.m_parameters = new ParameterList[1];
        this.m_parameters[0] = parameterList1;
        parameterList1.add((Object)this.m_columnsParameter1);
        parameterList1.add((Object)this.m_pi0MethodParameter);
        parameterList1.add((Object)this.m_numericValueParameter);
        parameterList1.add((Object)this.m_alphaParameter);
        parameterList1.add((Object)this.m_nbinsParameter);
        parameterList1.add((Object)this.m_pzParameter);
        parameterList1.getPanel();
        this.m_pi0MethodParameter.addLinkedParameters(linkedParameters);
    }

    @Override
    public void userParametersChanged() {
        this.m_globalTableModelInterface = null;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        AdjustPFunction clone = new AdjustPFunction(p);
        clone.cloneInfo(this);
        return clone;
    }

    @Override
    public boolean calculationDone() {
        return this.m_globalTableModelInterface != null;
    }

    @Override
    public boolean settingsDone() {
        if (this.m_parameters == null) {
            return false;
        }
        if (this.m_columnsParameter1 == null) {
            return false;
        }
        Integer colIndex = (Integer)this.m_columnsParameter1.getAssociatedObjectValue();
        return colIndex != null && colIndex != -1;
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        return null;
    }
}

