/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.functions;

import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.ResultVariable;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractFunction;
import fr.proline.studio.rsmexplorer.gui.calc.functions.AbstractOnExperienceDesignFunction;
import javax.swing.JTextField;
import org.python.core.PyObject;

public class QuantiFilterFunction
extends AbstractOnExperienceDesignFunction {
    private static final String GROUP_SEL_KEY = "GROUP_SEL";
    private static final String GROUP_SEL_NAME = "Missing Values Algorithm";
    private static final String INTENSITY_VALUE_KEY = "INTENSITY_VALUE";
    private static final String INTENSITY_VALUE_NAME = "Number of Intensity Values";
    private static final String QUANTI_FILTER_FUNTION_PARAMETER_LIST_NAME = "Missing Values Filter";
    private ParameterList m_parameterList;
    private ObjectParameter m_groupsParameter = null;
    private IntegerParameter m_intensityThreshold = null;
    private ResultVariable m_tableResultVariable = null;

    public QuantiFilterFunction(GraphPanel panel) {
        super(panel, AbstractFunction.FUNCTION_TYPE.QuantiFilterFunction, QUANTI_FILTER_FUNTION_PARAMETER_LIST_NAME, "quantifilter", "quantifilter", "Rows Kept", null);
        this.addCalculationTodo(QUANTI_FILTER_FUNTION_PARAMETER_LIST_NAME, "quantifilterReversed", "quantifilterReversed", "Rows Filtered", null);
    }

    @Override
    public int getMinGroups() {
        return 2;
    }

    @Override
    public int getMaxGroups() {
        return 8;
    }

    @Override
    public AbstractFunction cloneFunction(GraphPanel p) {
        QuantiFilterFunction clone = new QuantiFilterFunction(p);
        clone.cloneInfo(this);
        return clone;
    }

    @Override
    public ParameterList getExtraParameterList() {
        this.m_parameterList = new ParameterList(QUANTI_FILTER_FUNTION_PARAMETER_LIST_NAME);
        Object[] options = new String[]{"Whole groups", "For every group", "At least one group"};
        Object[] associatedOptions = new Integer[]{0, 1, 2};
        this.m_groupsParameter = new ObjectParameter(GROUP_SEL_KEY, GROUP_SEL_NAME, null, options, associatedOptions, -1, null);
        this.m_intensityThreshold = new IntegerParameter(INTENSITY_VALUE_KEY, INTENSITY_VALUE_NAME, JTextField.class, Integer.valueOf(0), Integer.valueOf(0), null);
        this.m_parameterList.add((Object)this.m_groupsParameter);
        this.m_parameterList.add((Object)this.m_intensityThreshold);
        return this.m_parameterList;
    }

    @Override
    public String getExtraValuesForFunctionCall() {
        return "," + this.m_tableResultVariable.getName() + "," + this.m_groupsParameter.getAssociatedObjectValue().toString() + "," + this.m_intensityThreshold.getStringValue();
    }

    @Override
    public ResultVariable[] getExtraVariables(Table sourceTable) {
        this.m_tableResultVariable = new ResultVariable((PyObject)sourceTable);
        ResultVariable[] resultVariables = new ResultVariable[]{this.m_tableResultVariable};
        return resultVariables;
    }
}

