/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.graphics;

import fr.proline.studio.extendedtablemodel.GlobalTableModelInterface;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.python.data.ColRef;
import fr.proline.studio.python.data.PythonImage;
import fr.proline.studio.python.data.Table;
import fr.proline.studio.python.interpreter.CalcCallback;
import fr.proline.studio.python.interpreter.CalcError;
import fr.proline.studio.python.interpreter.CalcInterpreterTask;
import fr.proline.studio.python.interpreter.CalcInterpreterThread;
import fr.proline.studio.python.interpreter.ResultVariable;
import fr.proline.studio.rsmexplorer.gui.calc.GraphPanel;
import fr.proline.studio.rsmexplorer.gui.calc.ProcessCallbackInterface;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphicGraphNode;
import fr.proline.studio.rsmexplorer.gui.calc.graphics.AbstractGraphic;
import fr.proline.studio.types.LogInfo;
import fr.proline.studio.types.PValue;
import java.util.ArrayList;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import org.python.core.PyObject;

public class CalibrationPlotGraphic
extends AbstractGraphic {
    private static final String PVALUE = "PVALUE";
    private static final String PI0PARAMETER = "PI0PARAMETER";
    private static final String NBBINSPARAMETER = "NBBINSPARAMETER";
    private static final String PZPARAMETER = "PZPARAMETER";
    private static final String NUMERICVALUEARAMETER = "NUMERICVALUEARAMETER";
    private ObjectParameter m_columnsParameter1 = null;
    private ObjectParameter m_pi0MethodParameter = null;
    private DoubleParameter m_numericValueParameter = null;
    private IntegerParameter m_nbinsParameter = null;
    private DoubleParameter m_pzParameter = null;

    public CalibrationPlotGraphic(GraphPanel panel) {
        super(panel, AbstractGraphic.GRAPHIC_TYPE.CalibrationPlotGraphic);
    }

    @Override
    public void inLinkDeleted() {
        super.inLinkDeleted();
        this.m_columnsParameter1 = null;
        this.m_pi0MethodParameter = null;
        this.m_numericValueParameter = null;
        this.m_nbinsParameter = null;
        this.m_pzParameter = null;
    }

    @Override
    public String getName() {
        if (this.m_pi0MethodParameter == null) {
            return "Calibration Plot";
        }
        StringBuilder columnNameSb = new StringBuilder("Calibration Plot ");
        String pi0Method = this.m_pi0MethodParameter.getStringValue();
        if (pi0Method.compareTo("Numeric Value") == 0) {
            columnNameSb.append(this.m_numericValueParameter.getStringValue());
        } else {
            columnNameSb.append(pi0Method);
        }
        return columnNameSb.toString();
    }

    @Override
    public void process(GraphConnector[] graphObjects, final GraphicGraphNode graphicGraphNode, final ProcessCallbackInterface callback) {
        if (this.m_generatedImage != null) {
            callback.finished(graphicGraphNode);
            return;
        }
        this.setInError(false, null);
        if (this.m_columnsParameter1 == null) {
            callback.finished(graphicGraphNode);
            return;
        }
        Integer colIndex = (Integer)this.m_columnsParameter1.getAssociatedObjectValue();
        if (colIndex == null || colIndex == -1) {
            callback.finished(graphicGraphNode);
            return;
        }
        this.setCalculating(true);
        try {
            GlobalTableModelInterface srcModel = graphObjects[0].getGlobalTableModelInterface();
            Table sourceTable = new Table(srcModel);
            ResultVariable[] parameters = new ResultVariable[1];
            ColRef col = sourceTable.getCol(colIndex.intValue());
            parameters[0] = new ResultVariable((PyObject)col);
            StringBuilder codeSB = new StringBuilder();
            codeSB.append("calibrationPlot=Stats.calibrationPlot(");
            for (int i = 0; i < parameters.length; ++i) {
                codeSB.append(parameters[i].getName());
            }
            String pi0Method = this.m_pi0MethodParameter.getStringValue();
            if (pi0Method.compareTo("Numeric Value") == 0) {
                codeSB.append(',');
                codeSB.append(this.m_numericValueParameter.getStringValue());
            } else {
                codeSB.append(",\"").append(pi0Method).append("\"");
            }
            codeSB.append(",").append(this.m_nbinsParameter.getStringValue());
            codeSB.append(",").append(this.m_pzParameter.getStringValue());
            codeSB.append(')');
            CalcCallback calcCallback = new CalcCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(ArrayList<ResultVariable> variables, CalcError error) {
                    try {
                        if (variables != null) {
                            for (ResultVariable var : variables) {
                                if (var.getName().compareTo("calibrationPlot") != 0) continue;
                                PythonImage image = (PythonImage)var.getValue();
                                CalibrationPlotGraphic.this.m_generatedImage = image.getImage();
                            }
                        } else if (error != null) {
                            CalibrationPlotGraphic.this.setInError(error);
                        }
                        CalibrationPlotGraphic.this.setCalculating(false);
                    }
                    finally {
                        callback.finished(graphicGraphNode);
                    }
                }
            };
            CalcInterpreterTask task = new CalcInterpreterTask(codeSB.toString(), parameters, calcCallback);
            CalcInterpreterThread.getCalcInterpreterThread().addTask(task);
        }
        catch (Exception e) {
            this.setInError(new CalcError((Throwable)e, null, -1));
            this.setCalculating(false);
            callback.finished(graphicGraphNode);
        }
    }

    @Override
    public void generateDefaultParameters(GraphConnector[] graphObjects) {
        GlobalTableModelInterface model1 = graphObjects[0].getGlobalTableModelInterface();
        int nbColumns = model1.getColumnCount();
        int nbColumnsKept = 0;
        for (int i = 0; i < nbColumns; ++i) {
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(Float.class) && !c.equals(Double.class)) continue;
            ++nbColumnsKept;
        }
        Object[] objectArray1 = new Object[nbColumnsKept];
        Object[] associatedObjectArray1 = new Object[nbColumnsKept];
        int iKept = 0;
        int selectedIndex1 = -1;
        for (int i = 0; i < nbColumns; ++i) {
            LogInfo log;
            Class c = model1.getDataColumnClass(i);
            if (!c.equals(Float.class) && !c.equals(Double.class)) continue;
            objectArray1[iKept] = model1.getColumnName(i);
            PValue pvalue = (PValue)model1.getColValue(PValue.class, i);
            if (pvalue != null && ((log = (LogInfo)model1.getColValue(LogInfo.class, i)) == null || log.noLog())) {
                selectedIndex1 = iKept;
            }
            associatedObjectArray1[iKept] = i + 1;
            ++iKept;
        }
        ParameterList parameterList1 = new ParameterList("param1");
        this.m_columnsParameter1 = new ObjectParameter(PVALUE, "P Values Column", null, objectArray1, associatedObjectArray1, selectedIndex1, null);
        Object[] pi0Values = new String[]{"ALL", "Numeric Value", "abh", "jiang", "histo", "langaas", "pounds", "slim", "st.boot", "st.spline"};
        this.m_pi0MethodParameter = new ObjectParameter(PI0PARAMETER, "pi0 Method", pi0Values, 0, null);
        this.m_numericValueParameter = new DoubleParameter(NUMERICVALUEARAMETER, "Pi0 Value", JTextField.class, Double.valueOf(1.0), Double.valueOf(0.0), Double.valueOf(1.0));
        this.m_nbinsParameter = new IntegerParameter(NBBINSPARAMETER, "Number of Bins", JSpinner.class, Integer.valueOf(20), Integer.valueOf(5), Integer.valueOf(100));
        this.m_pzParameter = new DoubleParameter(PZPARAMETER, "Pz", JTextField.class, Double.valueOf(0.05), Double.valueOf(0.01), Double.valueOf(0.1));
        AbstractLinkedParameters linkedParameters = new AbstractLinkedParameters(parameterList1){

            public void valueChanged(String value, Object associatedValue) {
                this.showParameter((AbstractParameter)CalibrationPlotGraphic.this.m_numericValueParameter, value.compareTo("Numeric Value") == 0);
                this.showParameter((AbstractParameter)CalibrationPlotGraphic.this.m_nbinsParameter, value.compareTo("jiang") == 0 || value.compareTo("histo") == 0);
                this.showParameter((AbstractParameter)CalibrationPlotGraphic.this.m_pzParameter, value.compareTo("slim") == 0);
                this.updateParameterListPanel();
            }
        };
        this.m_parameters = new ParameterList[1];
        this.m_parameters[0] = parameterList1;
        parameterList1.add((Object)this.m_columnsParameter1);
        parameterList1.add((Object)this.m_pi0MethodParameter);
        parameterList1.add((Object)this.m_numericValueParameter);
        parameterList1.add((Object)this.m_nbinsParameter);
        parameterList1.add((Object)this.m_pzParameter);
        parameterList1.getPanel();
        this.m_pi0MethodParameter.addLinkedParameters(linkedParameters);
    }

    @Override
    public void userParametersChanged() {
        this.m_generatedImage = null;
    }

    @Override
    public AbstractGraphic cloneGraphic(GraphPanel p) {
        CalibrationPlotGraphic clone = new CalibrationPlotGraphic(p);
        clone.cloneInfo(this);
        return clone;
    }

    @Override
    public boolean calculationDone() {
        return this.m_generatedImage != null;
    }

    @Override
    public boolean settingsDone() {
        if (this.m_parameters == null || this.m_columnsParameter1 == null) {
            return false;
        }
        Integer colIndex = (Integer)this.m_columnsParameter1.getAssociatedObjectValue();
        return colIndex != null && colIndex != -1;
    }

    @Override
    public ParameterError checkParameters(GraphConnector[] graphObjects) {
        return null;
    }
}

