/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.calc.parameters;

import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.gui.calc.graph.GraphConnector;
import fr.proline.studio.rsmexplorer.gui.calc.parameters.CheckParameterInterface;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.JPanel;

public class FunctionParametersDialog
extends DefaultDialog {
    private final ParameterList[] m_parameterList;
    private final CheckParameterInterface m_checkParamInterface;
    private final GraphConnector[] m_graphObjects;
    private int m_currentPanelNumber = 0;

    public FunctionParametersDialog(String name, Window parent, ParameterList[] parameterList, CheckParameterInterface checkParamInterface, GraphConnector[] graphObjects) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.m_parameterList = parameterList;
        this.m_checkParamInterface = checkParamInterface;
        this.m_graphObjects = graphObjects;
        this.setTitle(name + " Settings");
        this.setButtonVisible(5, false);
        this.setInternalComponent(this.createInternalPanel(this.m_currentPanelNumber));
        this.setButtonsState(this.m_currentPanelNumber, this.m_parameterList.length);
    }

    private void setButtonsState(int panelNumber, int nbPanels) {
        if (nbPanels == 1) {
            return;
        }
        if (panelNumber < nbPanels - 1) {
            this.setButtonName(0, "Next");
            this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.ARROW));
        } else {
            this.setButtonName(0, "OK");
            this.setButtonIcon(0, IconManager.getIcon((IconManager.IconType)IconManager.IconType.OK));
        }
        this.setButtonVisible(6, panelNumber > 0);
    }

    private JPanel createInternalPanel(int panelNumber) {
        JPanel containerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        ParameterList parameterList = this.m_parameterList[panelNumber];
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        ParameterList.ParametersPanel panel = parameterList.getPanel();
        panel.setParentDialog((DefaultDialog)this);
        containerPanel.add((Component)panel, c);
        return containerPanel;
    }

    protected boolean okCalled() {
        ParameterError error = this.m_parameterList[this.m_currentPanelNumber].checkParameters();
        if (error == null) {
            error = this.m_checkParamInterface.checkParameters(this.m_graphObjects);
        }
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        do {
            if (this.m_currentPanelNumber == this.m_parameterList.length - 1) {
                return true;
            }
            ++this.m_currentPanelNumber;
        } while (!this.m_parameterList[this.m_currentPanelNumber].isEnable());
        this.replaceInternalComponent(this.createInternalPanel(this.m_currentPanelNumber));
        this.setButtonsState(this.m_currentPanelNumber, this.m_parameterList.length);
        this.repack();
        this.revalidate();
        this.repaint();
        return false;
    }

    protected boolean backCalled() {
        do {
            if (this.m_currentPanelNumber == 0) {
                return false;
            }
            --this.m_currentPanelNumber;
        } while (!this.m_parameterList[this.m_currentPanelNumber].isEnable());
        this.replaceInternalComponent(this.createInternalPanel(this.m_currentPanelNumber));
        this.setButtonsState(this.m_currentPanelNumber, this.m_parameterList.length);
        this.repack();
        this.revalidate();
        this.repaint();
        return false;
    }
}

