/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.gui.AbstractParameterListTree;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.DoubleParameter;
import fr.proline.studio.parameter.FileParameter;
import fr.proline.studio.parameter.IntegerParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.StringParameter;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import org.slf4j.LoggerFactory;

public class ApplicationSettingsDialog
extends DefaultDialog
implements TreeSelectionListener,
TreeWillExpandListener {
    private static ApplicationSettingsDialog m_singletonDialog = null;
    private AbstractParameterListTree m_parameterListTree;
    private ParameterList m_jmsParameterList;
    private ParameterList m_generalParameterList;
    private ParameterList m_tablePrameterList;
    private ParameterList m_msParameterList;
    private ParameterList m_plotParameterList;
    private JPanel m_cards;
    private final Hashtable<String, JPanel> m_existingPanels;
    private final Hashtable<String, ParameterList> m_existingLists;
    private static final String GENERAL_APPLICATION_SETTINGS = "General";
    public static final String MS_FILES_SETTINGS = "MsFiles";
    public static final String OTHER_PREVIOUS_MS_FILES_SETTINGS = "Conversion/Upload Settings";
    public static final String FILENAME = "Filename";
    public static final String ABSOLUTE_PATH = "Absolute Path";
    public static final String WORKING_SET_ENTRY_NAMING_KEY = "WsEntryLabel";
    public static final String WORKING_SET_ENTRY_NAMING_NAME = "Working Set Entry Label";
    private static final String DIALOG_TITLE = "General Settings";
    private static final String TREE_ROOT_NAME = "Settings";
    private FileParameter m_converterFilePath;
    private final Preferences m_preferences;

    public static ApplicationSettingsDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new ApplicationSettingsDialog(parent);
            m_singletonDialog.selectDefault();
        }
        m_singletonDialog.updateSettings();
        return m_singletonDialog;
    }

    public ApplicationSettingsDialog(Window parent) {
        super(parent, Dialog.ModalityType.MODELESS);
        this.setTitle(DIALOG_TITLE);
        this.setSize(new Dimension(720, 480));
        this.setMinimumSize(new Dimension(720, 480));
        this.setResizable(true);
        this.setDocumentationSuffix("h.1smtxgf");
        this.setButtonVisible(1, true);
        this.setButtonName(0, "OK");
        this.setStatusVisible(true);
        this.m_existingPanels = new Hashtable();
        this.m_existingLists = new Hashtable();
        this.m_preferences = NbPreferences.root();
        this.setInternalComponent(this.createInternalComponent());
    }

    private ParameterList getJMSParameterList() {
        this.m_jmsParameterList = new ParameterList("JMS");
        StringParameter serviceRequestQueueName = new StringParameter("JMSProlineQueueName", "Service Request Queue Name", JTextField.class, "ProlineServiceRequestQueue", Integer.valueOf(5), null);
        this.m_jmsParameterList.add((Object)serviceRequestQueueName);
        this.m_jmsParameterList.loadParameters(this.m_preferences);
        return this.m_jmsParameterList;
    }

    private ParameterList getGeneralParameters() {
        this.m_generalParameterList = new ParameterList(GENERAL_APPLICATION_SETTINGS);
        JCheckBox gettingStartedCheckBox = new JCheckBox("Hide Getting Started Dialog On Startup");
        BooleanParameter gettingStartedParameter = new BooleanParameter("Hide_Getting_Started_Dialog", "Hide Getting Started Dialog On Startup", (JComponent)gettingStartedCheckBox, Boolean.valueOf(false));
        this.m_generalParameterList.add((Object)gettingStartedParameter);
        Object[] namingAssosiatedTable = new Object[]{"Search Name", "Peaklist", "Msi Search Filename", "Mascot Rule"};
        JComboBox<Object> namingComboBox = new JComboBox<Object>(namingAssosiatedTable);
        Object[] namingObjectTable = new Object[]{"SEARCH_RESULT_NAME", "PEAKLIST_PATH", "MSI_SEARCH_FILE_NAME", "MASCOT_DAEMON_RULE"};
        ObjectParameter nameSourceParameter = new ObjectParameter("DefaultSearchResultNameSource", "Default Search Result Name Source", namingComboBox, namingAssosiatedTable, namingObjectTable, 2, null);
        this.m_generalParameterList.add((Object)nameSourceParameter);
        JCheckBox decoratedCheckBox = new JCheckBox("Export Decorated");
        BooleanParameter exportDecoratedParameter = new BooleanParameter("Export_Decorated", "Export Decorated", (JComponent)decoratedCheckBox, Boolean.valueOf(true));
        this.m_generalParameterList.add((Object)exportDecoratedParameter);
        JCheckBox xicCheckBox = new JCheckBox("Use dataset type to create Xic Design by DnD");
        BooleanParameter xicTransferHandlerParameter = new BooleanParameter("XIC_Transfer_Handler_Retains_Structure", "XIC Transfer Handler Retains Structure", (JComponent)xicCheckBox, Boolean.valueOf(true));
        this.m_generalParameterList.add((Object)xicTransferHandlerParameter);
        this.m_generalParameterList.loadParameters(this.m_preferences);
        return this.m_generalParameterList;
    }

    private ParameterList getMsFilesParameters() {
        this.m_msParameterList = new ParameterList(MS_FILES_SETTINGS);
        this.m_msParameterList.addBackwardCompatiblePrefix(OTHER_PREVIOUS_MS_FILES_SETTINGS);
        String[] converterExtentions = new String[]{"exe"};
        String[] converterFilterNames = new String[]{"raw2mzDB.exe"};
        this.m_converterFilePath = new FileParameter(null, "Converter_(.exe)", "Converter (.exe)", JTextField.class, "", converterFilterNames, converterExtentions);
        this.m_converterFilePath.setAllFiles(false);
        this.m_converterFilePath.setSelectionMode(0);
        this.m_converterFilePath.setDefaultDirectory(new File(this.m_preferences.get("mzDB_Settings.Converter_(.exe)", System.getProperty("user.home"))));
        this.m_msParameterList.add((Object)this.m_converterFilePath);
        Object[] namingAssosiatedTable = new Object[]{FILENAME, ABSOLUTE_PATH};
        JComboBox<Object> namingComboBox = new JComboBox<Object>(namingAssosiatedTable);
        Object[] namingObjectTable = new Object[]{FILENAME, ABSOLUTE_PATH};
        ObjectParameter entryLabel = new ObjectParameter(WORKING_SET_ENTRY_NAMING_KEY, WORKING_SET_ENTRY_NAMING_NAME, namingComboBox, namingAssosiatedTable, namingObjectTable, 1, null);
        this.m_msParameterList.add((Object)entryLabel);
        this.m_msParameterList.loadParameters(this.m_preferences);
        return this.m_msParameterList;
    }

    private ParameterList getTableParameters() {
        this.m_tablePrameterList = new ParameterList("Tables");
        Object[] associatedTable = new Object[]{"Automatic Column Size", "Fixed Column Size", "Smart Column Size"};
        JComboBox<Object> comboBox = new JComboBox<Object>(associatedTable);
        Object[] objectTable = new Object[]{0, 1, 2};
        final ObjectParameter columnsParameter = new ObjectParameter("Columns_Arrangement", "Columns Arrangement", comboBox, associatedTable, objectTable, 2, null);
        this.m_tablePrameterList.add((Object)columnsParameter);
        final IntegerParameter defaultFixedColumnSize = new IntegerParameter("Column_Width", "Column Width", JTextField.class, Integer.valueOf(120), Integer.valueOf(20), Integer.valueOf(300));
        this.m_tablePrameterList.add((Object)defaultFixedColumnSize);
        this.m_tablePrameterList.loadParameters(this.m_preferences);
        AbstractLinkedParameters linkedParameters = new AbstractLinkedParameters(this.m_tablePrameterList){

            public void valueChanged(String value, Object associatedValue) {
                int width = Integer.parseInt(defaultFixedColumnSize.getStringValue());
                int selection = Integer.parseInt(columnsParameter.getStringValue());
                this.showParameter((AbstractParameter)defaultFixedColumnSize, selection == 1 || selection == 2, width);
                this.updateParameterListPanel();
            }
        };
        columnsParameter.addLinkedParameters(linkedParameters);
        int m_selection = Integer.parseInt(columnsParameter.getStringValue());
        linkedParameters.valueChanged((String)associatedTable[m_selection], objectTable[m_selection]);
        return this.m_tablePrameterList;
    }

    private ParameterList getPlotParameters() {
        this.m_plotParameterList = new ParameterList("Plots");
        Object[] logOptions = new Object[]{"Suppress Negative and Null values", "Replace Negative and Null Values"};
        JComboBox<Object> comboBox = new JComboBox<Object>(logOptions);
        Object[] objectTable = new Object[]{0, 1};
        final ObjectParameter logAlgoParameter = new ObjectParameter("Log_Algo", "Log Axis Algorithm", comboBox, logOptions, objectTable, 0, null);
        this.m_plotParameterList.add((Object)logAlgoParameter);
        final DoubleParameter replaceValue = new DoubleParameter("Replacement_Value", "Replacement Value", JTextField.class, new Double(1.0), new Double(1.0E-13), new Double(1.0E15));
        this.m_plotParameterList.add((Object)replaceValue);
        this.m_plotParameterList.loadParameters(this.m_preferences);
        AbstractLinkedParameters linkedParameters = new AbstractLinkedParameters(this.m_plotParameterList){

            public void valueChanged(String value, Object associatedValue) {
                double valueDouble = Double.parseDouble(replaceValue.getStringValue());
                int selection = Integer.parseInt(logAlgoParameter.getStringValue());
                this.showParameter((AbstractParameter)replaceValue, selection == 1, valueDouble);
                this.updateParameterListPanel();
            }
        };
        logAlgoParameter.addLinkedParameters(linkedParameters);
        int selection = Integer.parseInt(logAlgoParameter.getStringValue());
        linkedParameters.valueChanged((String)logOptions[selection], objectTable[selection]);
        return this.m_plotParameterList;
    }

    private JComponent createInternalComponent() {
        JPanel externalPanel = new JPanel();
        externalPanel.setLayout(new GridLayout(1, 1));
        externalPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 1));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.m_parameterListTree = new AbstractParameterListTree(TREE_ROOT_NAME, (TreeSelectionListener)this, (TreeWillExpandListener)this);
        this.m_parameterListTree.addNodes(this.getJMSParameterList());
        this.m_parameterListTree.addNodes(this.getMsFilesParameters());
        this.m_parameterListTree.addNodes(this.getTableParameters());
        this.m_parameterListTree.addNodes(this.getGeneralParameters());
        this.m_parameterListTree.addNodes(this.getPlotParameters());
        this.m_parameterListTree.expandAllRows();
        JScrollPane scrollPane = new JScrollPane(this.m_parameterListTree.getTree());
        this.m_cards = new JPanel();
        this.m_cards.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.m_cards.setLayout(new CardLayout());
        JPanel rootPanel = new JPanel();
        this.m_cards.add((Component)rootPanel, TREE_ROOT_NAME);
        CardLayout cardLayout = (CardLayout)this.m_cards.getLayout();
        cardLayout.show(this.m_cards, TREE_ROOT_NAME);
        this.m_existingPanels.put(TREE_ROOT_NAME, rootPanel);
        JSplitPane splitPane = new JSplitPane(1, scrollPane, this.m_cards);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(200);
        splitPane.setOneTouchExpandable(false);
        Dimension minimumSize = new Dimension(200, 100);
        scrollPane.setMinimumSize(minimumSize);
        this.m_cards.setMinimumSize(minimumSize);
        panel.add(splitPane);
        externalPanel.add(panel);
        return externalPanel;
    }

    public void pack() {
    }

    protected boolean okCalled() {
        ParameterError error = this.checkExistingLists();
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            this.m_parameterListTree.getTree().setSelectionPath(new TreePath(TREE_ROOT_NAME));
            return false;
        }
        this.saveExistingsLists();
        return true;
    }

    protected boolean cancelCalled() {
        return true;
    }

    @Override
    public void valueChanged(TreeSelectionEvent tse) {
        Object lastSelectedPathComponent;
        if (tse.getSource() == this.m_parameterListTree.getTree() && (lastSelectedPathComponent = this.m_parameterListTree.getTree().getLastSelectedPathComponent()) instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)lastSelectedPathComponent;
            String panelKey = selectedNode.getUserObject().toString();
            if (this.m_existingPanels.containsKey(panelKey)) {
                CardLayout cardLayout = (CardLayout)this.m_cards.getLayout();
                cardLayout.show(this.m_cards, panelKey);
            } else {
                ParameterList.ParametersPanel newPanel = ((ParameterList)this.m_parameterListTree.getList().get(panelKey)).getPanel();
                this.m_cards.add((Component)newPanel, panelKey);
                CardLayout cardLayout = (CardLayout)this.m_cards.getLayout();
                cardLayout.show(this.m_cards, panelKey);
                this.m_existingPanels.put(panelKey, (JPanel)newPanel);
                this.m_existingLists.put(panelKey, (ParameterList)this.m_parameterListTree.getList().get(panelKey));
            }
        }
    }

    private ParameterError checkExistingLists() {
        Enumeration<String> enumKey = this.m_existingLists.keys();
        while (enumKey.hasMoreElements()) {
            String key = enumKey.nextElement();
            if (key.equalsIgnoreCase(MS_FILES_SETTINGS)) {
                File f;
                if (!this.m_converterFilePath.isEdited() && (this.m_converterFilePath.getStringValue() == null || this.m_converterFilePath.getStringValue().length() <= 0) || (f = new File(this.m_converterFilePath.getStringValue())).exists() && f.getAbsolutePath().endsWith("raw2mzDB.exe")) continue;
                ParameterError error = new ParameterError("The selected raw2mzDB.exe is not valid.", this.m_converterFilePath.getComponent());
                CardLayout cl = (CardLayout)this.m_cards.getLayout();
                cl.show(this.m_cards, key);
                return error;
            }
            ParameterList currentList = this.m_existingLists.get(key);
            ParameterError currentError = currentList.checkParameters();
            if (currentError == null) continue;
            CardLayout cl = (CardLayout)this.m_cards.getLayout();
            cl.show(this.m_cards, key);
            return currentError;
        }
        return null;
    }

    private void saveExistingsLists() {
        Enumeration<String> enumKey = this.m_existingLists.keys();
        while (enumKey.hasMoreElements()) {
            String key = enumKey.nextElement();
            ParameterList currentList = this.m_existingLists.get(key);
            currentList.saveParameters(NbPreferences.root());
        }
        try {
            NbPreferences.root().flush();
        }
        catch (BackingStoreException e) {
            LoggerFactory.getLogger((String)"ProlineStudio.DPM").error("Saving Parameters Failed", (Throwable)e);
        }
    }

    private void updateSettings() {
        Enumeration<String> enumKey = this.m_existingLists.keys();
        while (enumKey.hasMoreElements()) {
            String key = enumKey.nextElement();
            ParameterList currentList = this.m_existingLists.get(key);
            currentList.loadParameters(NbPreferences.root());
        }
    }

    private void selectDefault() {
        this.m_parameterListTree.selectNode(GENERAL_APPLICATION_SETTINGS);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent tee) throws ExpandVetoException {
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent tee) throws ExpandVetoException {
    }
}

