/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.dpm.serverfilesystem.ServerFileSystemView;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.msfiles.ConversionSettings;
import fr.proline.studio.msfiles.ConvertionUploadBatch;
import fr.proline.studio.msfiles.MzdbUploadSettings;
import fr.proline.studio.parameter.AbstractLinkedParameters;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.BooleanParameter;
import fr.proline.studio.parameter.FileParameter;
import fr.proline.studio.parameter.ObjectParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.rsmexplorer.gui.dialog.FileDialogInterface;
import fr.proline.studio.utils.IconManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ConvertRawDialog
extends DefaultDialog
implements FileDialogInterface {
    private static ConvertRawDialog m_singletonNonConnectedDialog = null;
    private static ConvertRawDialog m_singletonConnectedDialog = null;
    private boolean m_serverConnected;
    private JList m_fileList;
    private JScrollPane m_fileListScrollPane;
    private JButton m_addFileButton;
    private JButton m_removeFileButton;
    private ParameterList m_parameterList;
    private BooleanParameter m_deleteMzdb;
    private BooleanParameter m_deleteRaw;
    private BooleanParameter m_uploadMzdb;
    private BooleanParameter m_createParentDirectoryParameter;
    private BooleanParameter m_isConverter_v1;
    private FileParameter m_converterFilePath;
    private FileParameter m_outputFilePath;
    private static ObjectParameter m_uploadLabelParameter = null;
    private String m_lastParentDirectory;

    public static ConvertRawDialog getDialog(Window parent) {
        boolean connectedToServer;
        ArrayList labels = ServerFileSystemView.getServerFileSystemView().getLabels("mzdb_files");
        boolean bl = connectedToServer = labels != null;
        if (connectedToServer) {
            if (m_singletonConnectedDialog == null) {
                m_singletonConnectedDialog = new ConvertRawDialog(parent, true);
            } else {
                Object[] associatedTable = labels.toArray(new String[labels.size()]);
                Object[] objectTable = labels.toArray(new String[labels.size()]);
                m_uploadLabelParameter.updateAssociatedObjects(associatedTable);
                m_uploadLabelParameter.updateObjects(objectTable);
                ConvertRawDialog.m_singletonConnectedDialog.m_parameterList.loadParameters(NbPreferences.root());
                if (ConvertRawDialog.m_singletonConnectedDialog.m_fileList != null) {
                    DefaultListModel model = (DefaultListModel)ConvertRawDialog.m_singletonConnectedDialog.m_fileList.getModel();
                    model.clear();
                }
            }
            return m_singletonConnectedDialog;
        }
        if (m_singletonNonConnectedDialog == null) {
            m_singletonNonConnectedDialog = new ConvertRawDialog(parent, false);
        } else {
            ConvertRawDialog.m_singletonNonConnectedDialog.m_parameterList.loadParameters(NbPreferences.root());
            if (ConvertRawDialog.m_singletonNonConnectedDialog.m_fileList != null) {
                DefaultListModel model = (DefaultListModel)ConvertRawDialog.m_singletonNonConnectedDialog.m_fileList.getModel();
                model.clear();
            }
        }
        return m_singletonNonConnectedDialog;
    }

    private ConvertRawDialog(Window parent, boolean serverConnected) {
        super(parent, Dialog.ModalityType.MODELESS);
        this.m_serverConnected = serverConnected;
        this.setTitle("Convert raw file(s)");
        this.setSize(new Dimension(360, 480));
        this.setResizable(true);
        this.setDocumentationSuffix("h.j8sehv");
        this.setButtonVisible(1, true);
        this.setButtonName(0, "OK");
        this.setStatusVisible(true);
        this.setInternalComponent(this.createInternalComponent());
    }

    @Override
    public void setFiles(ArrayList<File> files) {
        ((DefaultListModel)this.m_fileList.getModel()).clear();
        if (files.size() > 0) {
            for (File f : files) {
                ((DefaultListModel)this.m_fileList.getModel()).addElement(f);
            }
            if (files.get(0).getParentFile() != null) {
                this.m_lastParentDirectory = files.get(0).getParentFile().getAbsolutePath();
            }
        }
    }

    private Component createInternalComponent() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new BorderLayout());
        internalPanel.add((Component)this.createFileSelectionPanel(), "Center");
        internalPanel.add((Component)this.createParameterPanel(), "South");
        return internalPanel;
    }

    private JPanel createParameterPanel() {
        Preferences preferences = NbPreferences.root();
        this.m_parameterList = new ParameterList("MsFiles");
        this.m_parameterList.addBackwardCompatiblePrefix("Conversion/Upload Settings");
        String[] converterExtentions = new String[]{"exe"};
        String[] converterFilterNames = new String[]{"raw2mzDB.exe"};
        this.m_converterFilePath = new FileParameter(null, "Converter_(.exe)", "Converter (.exe)", JTextField.class, "", converterFilterNames, converterExtentions);
        this.m_converterFilePath.setAllFiles(false);
        this.m_converterFilePath.setSelectionMode(0);
        this.m_converterFilePath.setDefaultDirectory(new File(preferences.get("mzDB_Settings.Converter_(.exe)", System.getProperty("user.home"))));
        this.m_parameterList.add((Object)this.m_converterFilePath);
        this.m_outputFilePath = new FileParameter(null, "Output_Path", "Output Path", JTextField.class, "", null, null);
        this.m_outputFilePath.setAllFiles(false);
        this.m_outputFilePath.setSelectionMode(1);
        this.m_outputFilePath.setDefaultDirectory(new File(preferences.get("mzDB_Settings.Output_Path", System.getProperty("user.home"))));
        this.m_parameterList.add((Object)this.m_outputFilePath);
        JCheckBox isConverterV1Checkbox = new JCheckBox("Converter version 1.1 or above");
        this.m_isConverter_v1 = new BooleanParameter("CONVERTER_V1", "Converter version is greater or equal to 1.1", (JComponent)isConverterV1Checkbox, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_isConverter_v1);
        JCheckBox rawCheckbox = new JCheckBox("Delete raw file after a successful conversion");
        this.m_deleteRaw = new BooleanParameter("DELETE_RAW", "Delete raw file after a successful conversion", (JComponent)rawCheckbox, Boolean.valueOf(false));
        this.m_parameterList.add((Object)this.m_deleteRaw);
        if (this.m_serverConnected) {
            JCheckBox uploadCheckbox = new JCheckBox("Upload .mzdb file successful conversion");
            this.m_uploadMzdb = new BooleanParameter("UPLOAD_CONVERTED", "Upload after conversion", (JComponent)uploadCheckbox, Boolean.valueOf(false));
            this.m_parameterList.add((Object)this.m_uploadMzdb);
            ArrayList labels = ServerFileSystemView.getServerFileSystemView().getLabels("mzdb_files");
            Object[] associatedTable = labels.toArray(new String[labels.size()]);
            Object[] objectTable = labels.toArray(new String[labels.size()]);
            JComboBox<String> namingComboBox = new JComboBox<String>(associatedTable);
            m_uploadLabelParameter = new ObjectParameter("MZDB_MOUNT_LABEL", "Server's mounting point", namingComboBox, associatedTable, objectTable, 0, null);
            this.m_parameterList.add((Object)m_uploadLabelParameter);
            JCheckBox mzdbCheckbox = new JCheckBox("Delete .mzdb file after a successful upload");
            this.m_deleteMzdb = new BooleanParameter("DELETE_MZDB", "Delete mzdb file after a successful upload", (JComponent)mzdbCheckbox, Boolean.valueOf(false));
            this.m_parameterList.add((Object)this.m_deleteMzdb);
            JCheckBox parentDirectoryCheckbox = new JCheckBox("Create Parent Directory in Destination");
            this.m_createParentDirectoryParameter = new BooleanParameter("CREATE_PARENT_DIRECTORY", "Create Parent Directory in Destination", (JComponent)parentDirectoryCheckbox, Boolean.valueOf(false));
            this.m_parameterList.add((Object)this.m_createParentDirectoryParameter);
        }
        this.m_parameterList.loadParameters(NbPreferences.root());
        AbstractLinkedParameters linkedParameters = null;
        if (this.m_serverConnected) {
            linkedParameters = new AbstractLinkedParameters(this.m_parameterList){

                public void valueChanged(String value, Object associatedValue) {
                    this.showParameter((AbstractParameter)ConvertRawDialog.this.m_deleteMzdb, (Boolean)ConvertRawDialog.this.m_uploadMzdb.getObjectValue(), (boolean)((Boolean)ConvertRawDialog.this.m_deleteMzdb.getObjectValue()));
                    this.showParameter((AbstractParameter)m_uploadLabelParameter, (Boolean)ConvertRawDialog.this.m_uploadMzdb.getObjectValue(), m_uploadLabelParameter.getObjectValue());
                    this.showParameter((AbstractParameter)ConvertRawDialog.this.m_createParentDirectoryParameter, (Boolean)ConvertRawDialog.this.m_uploadMzdb.getObjectValue(), (boolean)((Boolean)ConvertRawDialog.this.m_createParentDirectoryParameter.getObjectValue()));
                    this.updateParameterListPanel();
                }
            };
        }
        ParameterList.ParametersPanel parameterPanel = this.m_parameterList.getPanel();
        parameterPanel.setBorder(BorderFactory.createTitledBorder(" Conversion & Upload Options "));
        if (this.m_serverConnected) {
            this.m_uploadMzdb.addLinkedParameters(linkedParameters);
        }
        return parameterPanel;
    }

    private JPanel createFileSelectionPanel() {
        JPanel fileSelectionPanel = new JPanel(new GridBagLayout());
        fileSelectionPanel.setBorder(BorderFactory.createTitledBorder(" Files Selection "));
        this.m_fileList = new JList(new DefaultListModel());
        this.m_fileListScrollPane = new JScrollPane(this.m_fileList){
            private Dimension preferredSize;
            {
                this.preferredSize = new Dimension(360, 200);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.preferredSize;
            }
        };
        this.m_addFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.OPEN_FILE));
        this.m_addFileButton.setMargin(new Insets(2, 2, 2, 2));
        this.m_removeFileButton = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.ERASER));
        this.m_removeFileButton.setMargin(new Insets(2, 2, 2, 2));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridheight = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        fileSelectionPanel.add((Component)this.m_fileListScrollPane, c);
        ++c.gridx;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        fileSelectionPanel.add((Component)this.m_addFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add((Component)this.m_removeFileButton, c);
        ++c.gridy;
        fileSelectionPanel.add(Box.createVerticalStrut(30), c);
        this.m_fileList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                boolean sometingSelected = ConvertRawDialog.this.m_fileList.getSelectedIndex() != -1;
                ConvertRawDialog.this.m_removeFileButton.setEnabled(sometingSelected);
            }
        });
        this.m_addFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences preferences = NbPreferences.root();
                String initializationDirectory = preferences.get("mzDB_Settings.LAST_RAW_PATH", System.getProperty("user.home"));
                File f = new File(initializationDirectory);
                if (!f.exists() || !f.isDirectory()) {
                    initializationDirectory = System.getProperty("user.home");
                }
                JFileChooser fchooser = new JFileChooser(initializationDirectory);
                fchooser.setMultiSelectionEnabled(true);
                fchooser.addChoosableFileFilter(new FileNameExtensionFilter(".raw", "RAW"));
                fchooser.setAcceptAllFileFilterUsed(false);
                int result = fchooser.showOpenDialog((Component)((Object)(ConvertRawDialog.this.m_serverConnected ? m_singletonConnectedDialog : m_singletonNonConnectedDialog)));
                if (result == 0) {
                    File[] files = fchooser.getSelectedFiles();
                    int nbFiles = files.length;
                    for (int i = 0; i < nbFiles; ++i) {
                        ((DefaultListModel)ConvertRawDialog.this.m_fileList.getModel()).addElement(files[i]);
                    }
                    if (files.length > 0 && files[0].getParentFile() != null) {
                        ConvertRawDialog.this.m_lastParentDirectory = files[0].getParentFile().getAbsolutePath();
                    }
                }
            }
        });
        this.m_removeFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedValues = ConvertRawDialog.this.m_fileList.getSelectedValuesList();
                Iterator it = selectedValues.iterator();
                while (it.hasNext()) {
                    ((DefaultListModel)ConvertRawDialog.this.m_fileList.getModel()).removeElement(it.next());
                }
                ConvertRawDialog.this.m_removeFileButton.setEnabled(false);
            }
        });
        return fileSelectionPanel;
    }

    protected boolean okCalled() {
        if (this.m_fileList.getModel().getSize() == 0) {
            this.setStatus(true, "No files are selected.");
            this.highlight(this.m_fileList);
            return false;
        }
        if (this.m_converterFilePath.getStringValue() == null || this.m_converterFilePath.getStringValue().length() == 0) {
            this.setStatus(true, "An appropriate executable must be selected.");
            this.highlight(this.m_converterFilePath.getComponent((Object)this.m_converterFilePath.getStringValue()));
            return false;
        }
        if (!new File(this.m_converterFilePath.getStringValue()).exists()) {
            this.setStatus(true, "The selected executable no longer exists.");
            this.highlight(this.m_converterFilePath.getComponent((Object)this.m_converterFilePath.getStringValue()));
            return false;
        }
        if (this.m_outputFilePath.getStringValue() == null || this.m_outputFilePath.getStringValue().length() == 0) {
            this.setStatus(true, "An appropriate executable must be selected.");
            this.highlight(this.m_outputFilePath.getComponent((Object)this.m_outputFilePath.getStringValue()));
            return false;
        }
        if (!new File(this.m_outputFilePath.getStringValue()).exists()) {
            this.setStatus(true, "The selected directory no longer exists.");
            this.highlight(this.m_outputFilePath.getComponent((Object)this.m_outputFilePath.getStringValue()));
            return false;
        }
        ParameterError error = this.m_parameterList.checkParameters();
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        this.m_parameterList.saveParameters(NbPreferences.root());
        HashMap<File, ConversionSettings> conversions = new HashMap<File, ConversionSettings>();
        for (int i = 0; i < this.m_fileList.getModel().getSize(); ++i) {
            File file = (File)this.m_fileList.getModel().getElementAt(i);
            ConversionSettings conversionSettings = new ConversionSettings(this.m_converterFilePath.getStringValue(), this.m_outputFilePath.getStringValue(), (Boolean)this.m_deleteRaw.getObjectValue(), this.m_serverConnected ? (Boolean)this.m_uploadMzdb.getObjectValue() : false, (Boolean)this.m_isConverter_v1.getObjectValue());
            if (conversionSettings.getUploadAfterConversion()) {
                MzdbUploadSettings uploadSettings = new MzdbUploadSettings((Boolean)this.m_deleteMzdb.getObjectValue(), m_uploadLabelParameter.getStringValue(), (Boolean)this.m_createParentDirectoryParameter.getObjectValue() != false ? File.separator + file.getParentFile().getName() : "");
                conversionSettings.setUploadSettings(uploadSettings);
            } else {
                conversionSettings.setUploadSettings(null);
            }
            conversions.put((File)this.m_fileList.getModel().getElementAt(i), conversionSettings);
        }
        ConvertionUploadBatch conversionBatch = new ConvertionUploadBatch(conversions);
        if (this.m_lastParentDirectory != null) {
            Preferences preferences = NbPreferences.root();
            preferences.put("mzDB_Settings.LAST_RAW_PATH", this.m_lastParentDirectory);
        }
        Thread thread = new Thread(conversionBatch);
        thread.start();
        DefaultListModel listModel = (DefaultListModel)this.m_fileList.getModel();
        listModel.removeAllElements();
        return true;
    }

    protected boolean cancelCalled() {
        return true;
    }
}

