/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.studio.NbPreferences;
import fr.proline.studio.gui.DefaultStorableDialog;
import fr.proline.studio.parameter.AbstractParameter;
import fr.proline.studio.parameter.ParameterError;
import fr.proline.studio.parameter.ParameterList;
import fr.proline.studio.parameter.ParametersComboPanel;
import fr.proline.studio.rsmexplorer.gui.dialog.FilterProteinSetPanel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.JPanel;

public class FilterProtSetDialog
extends DefaultStorableDialog
implements ComponentListener {
    private static FilterProtSetDialog m_singletonDialog = null;
    private ParameterList m_parameterList;
    private AbstractParameter[] m_proteinFilterParameters;
    private ParametersComboPanel m_proteinPrefiltersPanel;
    private static final String SETTINGS_KEY = "ProtSetFiltering";

    public static FilterProtSetDialog getDialog(Window parent) {
        if (m_singletonDialog == null) {
            m_singletonDialog = new FilterProtSetDialog(parent);
        }
        return m_singletonDialog;
    }

    public FilterProtSetDialog(Window parent) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.setTitle("ProteinSet Filtering");
        this.setDocumentationSuffix("id.2lwamvv");
        this.m_parameterList = new ParameterList("ProtSet Filtering");
        this.m_proteinFilterParameters = FilterProteinSetPanel.createProteinSetFilterParameters("", this.m_parameterList);
        this.m_parameterList.updateValues(NbPreferences.root());
        this.setInternalComponent(this.createInternalPanel());
    }

    private JPanel createInternalPanel() {
        JPanel internalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        this.m_proteinPrefiltersPanel = new ParametersComboPanel(" Filter(s) ", this.m_proteinFilterParameters);
        this.m_proteinPrefiltersPanel.addComponentListener((ComponentListener)this);
        internalPanel.add((Component)this.m_proteinPrefiltersPanel, c);
        return internalPanel;
    }

    public HashMap<String, String> getArguments() {
        return this.m_parameterList.getValues();
    }

    protected boolean okCalled() {
        if (!this.checkParameters()) {
            return false;
        }
        Preferences preferences = NbPreferences.root();
        this.saveParameters(preferences);
        return true;
    }

    protected String getSettingsKey() {
        return SETTINGS_KEY;
    }

    protected void saveParameters(Preferences preferences) {
        this.m_parameterList.saveParameters(preferences);
    }

    protected boolean checkParameters() {
        ParameterError error = this.m_parameterList.checkParameters();
        if (error != null) {
            this.setStatus(true, error.getErrorMessage());
            this.highlight(error.getParameterComponent());
            return false;
        }
        return true;
    }

    protected void resetParameters() {
        this.m_parameterList.initDefaults();
        this.m_proteinPrefiltersPanel.clearPanel();
    }

    protected void loadParameters(Preferences filePreferences) throws Exception {
        String[] keys;
        Preferences preferences = NbPreferences.root();
        for (String key : keys = filePreferences.keys()) {
            String value = filePreferences.get(key, null);
            preferences.put(key, value);
        }
        this.m_parameterList.loadParameters(filePreferences);
        this.m_proteinPrefiltersPanel.updatePanel();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.repack();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

