/*
 * Decompiled with CFR 0.152.
 */
package fr.proline.studio.rsmexplorer.gui.dialog;

import fr.proline.core.orm.msi.MsiSearch;
import fr.proline.core.orm.uds.FragmentationRuleSet;
import fr.proline.core.orm.uds.dto.DDataset;
import fr.proline.core.orm.uds.dto.DDatasetType;
import fr.proline.studio.dam.DatabaseDataManager;
import fr.proline.studio.gui.DefaultDialog;
import fr.proline.studio.rsmexplorer.gui.dialog.FragmentationRuleSetViewer;
import fr.proline.studio.utils.IconManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class GenerateSpectrumMatchesDialog
extends DefaultDialog {
    private JLabel m_fragmentationRuleSetsLabel = null;
    private JComboBox m_fragmentationRuleSetsComboBox = null;
    private JCheckBox m_forceGenerateChB = null;
    private JCheckBox m_useDefinedFRSChB = null;
    private List<MsiSearch> m_msiSearches = null;
    private boolean oneMerged = false;

    public GenerateSpectrumMatchesDialog(Window parent, MsiSearch msiSearch) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.m_msiSearches = Collections.singletonList(msiSearch);
        this.initDialog();
    }

    public GenerateSpectrumMatchesDialog(Window parent, List<DDataset> allDSs) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        if (allDSs != null && !allDSs.isEmpty()) {
            this.m_msiSearches = allDSs.stream().map(ds -> ds.getResultSet().getMsiSearch()).collect(Collectors.toList());
            this.oneMerged = allDSs.stream().filter(ds -> !DDatasetType.AggregationInformation.NONE.equals((Object)ds.getAggregationInformation())).count() > 0L;
        }
        this.initDialog();
    }

    private void initDialog() {
        this.setTitle("Generate Spectrum Matches");
        this.setDocumentationSuffix("id.1idq7dh");
        this.setHelpHeaderText("Choose Fragmentation Rule Set that will be used to generate spectrum matches.<br> With force parameter set, new generated spectrum matches will overwrite existing ones.");
        this.initInternalPanel();
        this.pack();
    }

    private void initInternalPanel() {
        JPanel internalPanel = new JPanel();
        internalPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.m_forceGenerateChB = new JCheckBox("Force new spectrum matches generation", false);
        internalPanel.add((Component)this.m_forceGenerateChB, c);
        ++c.gridy;
        c.gridwidth = 3;
        internalPanel.add((Component)this.createFragmentatoinRuleSetPanel(), c);
        this.setInternalComponent(internalPanel);
    }

    private JPanel createFragmentatoinRuleSetPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Fragmentation Rules"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(5, 5, 5, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 1.0;
        String dsFrs = this.getFragmentationRuleSetsLabel();
        this.m_useDefinedFRSChB = new JCheckBox("Use fragmentation rule set defined at import (" + dsFrs + ")", false);
        this.m_useDefinedFRSChB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerateSpectrumMatchesDialog.this.m_fragmentationRuleSetsLabel.setEnabled(!GenerateSpectrumMatchesDialog.this.m_useDefinedFRSChB.isSelected());
                GenerateSpectrumMatchesDialog.this.m_fragmentationRuleSetsComboBox.setEnabled(!GenerateSpectrumMatchesDialog.this.m_useDefinedFRSChB.isSelected());
            }
        });
        panel.add((Component)this.m_useDefinedFRSChB, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.m_fragmentationRuleSetsLabel = new JLabel("Select Fragmentation Rule Set :");
        this.m_fragmentationRuleSetsLabel.setHorizontalAlignment(4);
        panel.add((Component)this.m_fragmentationRuleSetsLabel, c);
        ++c.gridx;
        c.gridwidth = 1;
        c.weightx = 1.0;
        this.m_fragmentationRuleSetsComboBox = new JComboBox<FragmentationRuleSet>(DatabaseDataManager.getDatabaseDataManager().getFragmentationRuleSetsWithNullArray());
        panel.add((Component)this.m_fragmentationRuleSetsComboBox, c);
        ++c.gridx;
        c.weightx = 0.0;
        JButton viewFragmentationRuleSet = new JButton(IconManager.getIcon((IconManager.IconType)IconManager.IconType.DOCUMENT_LIST));
        viewFragmentationRuleSet.setMargin(new Insets(2, 2, 2, 2));
        viewFragmentationRuleSet.setToolTipText("View Fragmentation Rule Sets");
        final GenerateSpectrumMatchesDialog dialog = this;
        viewFragmentationRuleSet.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FragmentationRuleSetViewer viewer = new FragmentationRuleSetViewer((Window)((Object)dialog));
                viewer.setVisible(true);
            }
        });
        panel.add((Component)viewFragmentationRuleSet, c);
        return panel;
    }

    private String getFragmentationRuleSetsLabel() {
        StringBuilder sb = new StringBuilder();
        boolean oneNull = false;
        boolean oneNotNull = false;
        if (this.m_msiSearches == null || this.m_msiSearches.isEmpty()) {
            return "unknown - see dataset properties";
        }
        for (MsiSearch msiSearch : this.m_msiSearches) {
            if (msiSearch == null) {
                oneNull = true;
                continue;
            }
            FragmentationRuleSet fragSet = DatabaseDataManager.getDatabaseDataManager().getFragmentationRuleSet(msiSearch.getSearchSetting().getFragmentationRuleSetId());
            if (fragSet == null) {
                oneNull = true;
                continue;
            }
            if (oneNotNull) {
                sb.append(", ");
            }
            sb.append(fragSet.getName());
            oneNotNull = true;
        }
        if (this.oneMerged) {
            if (oneNotNull) {
                sb.append("; ");
            }
            sb.append("merged dataset...");
        }
        if (oneNull) {
            if (oneNotNull) {
                sb.append("; ");
            }
            sb.append("unknown");
        }
        return sb.toString();
    }

    protected boolean okCalled() {
        if (!this.m_useDefinedFRSChB.isSelected() && this.m_fragmentationRuleSetsComboBox.getSelectedItem() == null) {
            this.setStatus(true, "A Fragmentation Rule Set should be selected");
            this.highlight(this.m_fragmentationRuleSetsComboBox);
            return false;
        }
        return true;
    }

    public Boolean getDoForceGenerate() {
        return this.m_forceGenerateChB.isSelected();
    }

    public long getFragmentationRuleSetId() {
        if (this.m_useDefinedFRSChB.isSelected()) {
            return -1L;
        }
        FragmentationRuleSet fragmentationRuleSet = (FragmentationRuleSet)this.m_fragmentationRuleSetsComboBox.getSelectedItem();
        if (fragmentationRuleSet == null) {
            return -1L;
        }
        return fragmentationRuleSet.getId();
    }
}

